
//   ன  ᮢ  ᭮ ࠭ ⥬ 

VOID Painter_SetDrawingRules( VOID )
{
 //  ࠢ  ᨬ  ⥬.
 switch( Painter.Settings.Theme )
  {
   case PAINTER_THEME_ECOMSTATION:
    {
     Painter.Settings.Draw_normal_frames = 0;
     Painter.Settings.Draw_const_frames = 0;
     Painter.Settings.Draw_point_frames = 0;
     Painter.Settings.Draw_flat_frames = 0;
     Painter.Settings.Draw_volume_lines = 0;
     Painter.Settings.Draw_system_menus = 0;
     Painter.Settings.Draw_titles = 1;
     Painter.Settings.Draw_menus = 0;
     Painter.Settings.Draw_buttons = 0;
    }
   break;

   case PAINTER_THEME_CLASSIC_GRAY:
   case PAINTER_THEME_CLASSIC_RGB:
    {
     Painter.Settings.Draw_normal_frames = 1;
     Painter.Settings.Draw_const_frames = 1;
     Painter.Settings.Draw_point_frames = 1;
     Painter.Settings.Draw_flat_frames = 1;
     Painter.Settings.Draw_volume_lines = 1;
     Painter.Settings.Draw_system_menus = 1;
     Painter.Settings.Draw_titles = 1;
     Painter.Settings.Draw_menus = 1;
     Painter.Settings.Draw_buttons = 1;
    }
   break;

   case PAINTER_THEME_WHITE_SNOW:
    {
     Painter.Settings.Draw_normal_frames = 1;
     Painter.Settings.Draw_const_frames = 1;
     Painter.Settings.Draw_point_frames = 1;
     Painter.Settings.Draw_flat_frames = 1;
     Painter.Settings.Draw_volume_lines = 0;
     Painter.Settings.Draw_system_menus = 1;
     Painter.Settings.Draw_titles = 1;
     Painter.Settings.Draw_menus = 0;
     Painter.Settings.Draw_buttons = 1;
    }
   break;
  }

 // .
 return;
}

//  ⠭ ன  㬮砭 

// Division -  ன  ⠭.
VOID Painter_SetPreDefinedSettings( LONG Division )
{
 //  ன.
 if( Division == SET_ALL_SETTINGS )
  {
   bzero( &Painter.Settings.Exceptions, sizeof( PAINTER_EXCEPTIONS ) );
  }

 if( Division == SET_ALL_SETTINGS || Division == SET_DRAWING )
  {
   Painter.Settings.Draw_frames = 0;

   Painter.Settings.Accelerate_folders_closing = 1;
   Painter.Settings.Rollup_VIO_windows = 0;
   Painter.Settings.Keep_frame_colors = 1;

   Painter.Settings.Theme = PAINTER_THEME_ECOMSTATION; Painter_SetDrawingRules();

   GetCurrentPath( Painter.Settings.TitleBar_pattern_name );
   strcat( Painter.Settings.TitleBar_pattern_name, "\\Bitmap\\Themes\\Clouds.bmp" );
  }

 //  梥   .
 if( Division == SET_ALL_SETTINGS || Division == SET_ROOMS || Division == SET_DRAWING )
  {
   INT LLL = 255; INT LL = 204; INT L = 160; INT NNN = 128; INT DDD = 96; INT DD = 64; INT D = 32;

   //   ⥪ -   .
   Painter.Settings.AT_Text_color          = MAKERGB( LLL, LLL, LLL );
   Painter.Settings.Northern_AT_Text_color = MAKERGB( LLL, LLL, LLL );
   Painter.Settings.Southern_AT_Text_color = MAKERGB( LLL, LLL, LLL );
   Painter.Settings.Western_AT_Text_color  = MAKERGB( LLL, LLL, LLL );
   Painter.Settings.Eastern_AT_Text_color  = MAKERGB( LLL, LLL, LLL );

   Painter.Settings.IT_Text_color          = MAKERGB(   0,   0,   0 );
   Painter.Settings.Northern_IT_Text_color = MAKERGB(   0,   0,   0 );
   Painter.Settings.Southern_IT_Text_color = MAKERGB(   0,   0,   0 );
   Painter.Settings.Western_IT_Text_color  = MAKERGB(   0,   0,   0 );
   Painter.Settings.Eastern_IT_Text_color  = MAKERGB(   0,   0,   0 );

   //     -   ⥬-.
   Painter.Settings.AT_Background_color          = MAKERGB( NNN, NNN, NNN );
   Painter.Settings.Northern_AT_Background_color = MAKERGB( NNN, NNN, NNN );
   Painter.Settings.Southern_AT_Background_color = MAKERGB( NNN, NNN, NNN );
   Painter.Settings.Western_AT_Background_color  = MAKERGB( NNN, NNN, NNN );
   Painter.Settings.Eastern_AT_Background_color  = MAKERGB( NNN, NNN, NNN );

   Painter.Settings.IT_Background_color          = MAKERGB(  LL,  LL,  LL );
   Painter.Settings.Northern_IT_Background_color = MAKERGB(  LL,  LL,  LL );
   Painter.Settings.Southern_IT_Background_color = MAKERGB(  LL,  LL,  LL );
   Painter.Settings.Western_IT_Background_color  = MAKERGB(  LL,  LL,  LL );
   Painter.Settings.Eastern_IT_Background_color  = MAKERGB(  LL,  LL,  LL );

   //      - .
   Painter.Settings.AT_Color_1          = MAKERGB(  D,  D,  D );
   Painter.Settings.AT_Color_3          = MAKERGB(  D,  D,  D );
   Painter.Settings.Northern_AT_Color_1 = MAKERGB(  D,  D,  D );
   Painter.Settings.Northern_AT_Color_3 = MAKERGB(  D,  D,  D );
   Painter.Settings.Southern_AT_Color_1 = MAKERGB(  D,  D,  D );
   Painter.Settings.Southern_AT_Color_3 = MAKERGB(  D,  D,  D );
   Painter.Settings.Western_AT_Color_1  = MAKERGB(  D,  D,  D );
   Painter.Settings.Western_AT_Color_3  = MAKERGB(  D,  D,  D );
   Painter.Settings.Eastern_AT_Color_1  = MAKERGB(  D,  D,  D );
   Painter.Settings.Eastern_AT_Color_3  = MAKERGB(  D,  D,  D );

   Painter.Settings.IT_Color_1          = MAKERGB( LL, LL, LL );
   Painter.Settings.IT_Color_3          = MAKERGB( LL, LL, LL );
   Painter.Settings.Northern_IT_Color_1 = MAKERGB( LL, LL, LL );
   Painter.Settings.Northern_IT_Color_3 = MAKERGB( LL, LL, LL );
   Painter.Settings.Southern_IT_Color_1 = MAKERGB( LL, LL, LL );
   Painter.Settings.Southern_IT_Color_3 = MAKERGB( LL, LL, LL );
   Painter.Settings.Western_IT_Color_1  = MAKERGB( LL, LL, LL );
   Painter.Settings.Western_IT_Color_3  = MAKERGB( LL, LL, LL );
   Painter.Settings.Eastern_IT_Color_1  = MAKERGB( LL, LL, LL );
   Painter.Settings.Eastern_IT_Color_3  = MAKERGB( LL, LL, LL );

   //      ᢮ 梥.
   {
    INT III = 242; INT II = 224; INT I = 192;

    Painter.Settings.AT_Color_2          = MAKERGB(   0,  LL,  LL );
    Painter.Settings.IT_Color_2          = MAKERGB(  LL, LLL, LLL );

    Painter.Settings.Northern_AT_Color_2 = MAKERGB(   0,   L,  LL );
    Painter.Settings.Northern_IT_Color_2 = MAKERGB(  LL, III, LLL );

    Painter.Settings.Eastern_AT_Color_2  = MAKERGB(   0,  LL,   L );
    Painter.Settings.Eastern_IT_Color_2  = MAKERGB(  LL, LLL, III );

    Painter.Settings.Southern_AT_Color_2 = MAKERGB( LLL,   L,   D );
    Painter.Settings.Southern_IT_Color_2 = MAKERGB( III,  II,   I );

    Painter.Settings.Western_AT_Color_2  = MAKERGB(   0,   L,  DD );
    Painter.Settings.Western_IT_Color_2  = MAKERGB(   I, III,   I );
   }
  }

 // .
 return;
}

//  ⠥ ன 

// Ini_file - 䠩 ஥.
VOID Painter_ReadSettings( HINI Ini_file )
{
 // ⠥ ன.
 ULONG Byte = 0; ULONG Int = 0; ULONG Long = 0; ULONG Name = 0; ULONG Path = 0; ULONG Byte_data = 0; ULONG Int_data = 0; ULONG Long_data = 0;

 Byte = sizeof( BYTE ); if( PrfQueryProfileData( Ini_file, "Settings", "Draw frames", &Byte_data, &Byte ) ) Painter.Settings.Draw_frames = Byte_data;
 Int  = sizeof( INT );  if( PrfQueryProfileData( Ini_file, "Settings", "Theme", &Int_data, &Int ) ) Painter.Settings.Theme = Int_data;
 Byte = sizeof( BYTE ); if( PrfQueryProfileData( Ini_file, "Settings", "Accelerate folders closing", &Byte_data, &Byte ) ) Painter.Settings.Accelerate_folders_closing = Byte_data;
 Byte = sizeof( BYTE ); if( PrfQueryProfileData( Ini_file, "Settings", "Rollup VIO windows", &Byte_data, &Byte ) ) Painter.Settings.Rollup_VIO_windows = Byte_data;
 Byte = sizeof( BYTE ); if( PrfQueryProfileData( Ini_file, "Settings", "Keep frame colors", &Byte_data, &Byte ) ) Painter.Settings.Keep_frame_colors = Byte_data;

 {
  CHAR Item[ SIZE_OF_PATH ] = "";

  Path = SIZE_OF_PATH; PrfQueryProfileData( Ini_file, "Settings", "TitleBar pattern name", Item, &Path );
  if( Item[ 0 ] != 0 ) { strcpy( Painter.Settings.TitleBar_pattern_name, Item ); Item[ 0 ] = 0; }
 }

 // ⠥ 梥.
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "AT Text color", &Long_data, &Long ) ) Painter.Settings.AT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "AT Background color", &Long_data, &Long ) ) Painter.Settings.AT_Background_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "IT Text color", &Long_data, &Long ) ) Painter.Settings.IT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "IT Background color", &Long_data, &Long ) ) Painter.Settings.IT_Background_color = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern AT Text color", &Long_data, &Long ) ) Painter.Settings.Northern_AT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern IT Text color", &Long_data, &Long ) ) Painter.Settings.Northern_IT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern AT Background color", &Long_data, &Long ) ) Painter.Settings.Northern_AT_Background_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern IT Background color", &Long_data, &Long ) ) Painter.Settings.Northern_IT_Background_color = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern AT Text color", &Long_data, &Long ) ) Painter.Settings.Southern_AT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern IT Text color", &Long_data, &Long ) ) Painter.Settings.Southern_IT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern AT Background color", &Long_data, &Long ) ) Painter.Settings.Southern_AT_Background_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern IT Background color", &Long_data, &Long ) ) Painter.Settings.Southern_IT_Background_color = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western AT Text color", &Long_data, &Long ) ) Painter.Settings.Western_AT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western IT Text color", &Long_data, &Long ) ) Painter.Settings.Western_IT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western AT Background color", &Long_data, &Long ) ) Painter.Settings.Western_AT_Background_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western IT Background color", &Long_data, &Long ) ) Painter.Settings.Western_IT_Background_color = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern AT Text color", &Long_data, &Long ) ) Painter.Settings.Eastern_AT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern IT Text color", &Long_data, &Long ) ) Painter.Settings.Eastern_IT_Text_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern AT Background color", &Long_data, &Long ) ) Painter.Settings.Eastern_AT_Background_color = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern IT Background color", &Long_data, &Long ) ) Painter.Settings.Eastern_IT_Background_color = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "AT Color 1", &Long_data, &Long ) ) Painter.Settings.AT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "AT Color 2", &Long_data, &Long ) ) Painter.Settings.AT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "AT Color 3", &Long_data, &Long ) ) Painter.Settings.AT_Color_3 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "IT Color 1", &Long_data, &Long ) ) Painter.Settings.IT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "IT Color 2", &Long_data, &Long ) ) Painter.Settings.IT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "IT Color 3", &Long_data, &Long ) ) Painter.Settings.IT_Color_3 = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern AT Color 1", &Long_data, &Long ) ) Painter.Settings.Northern_AT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern AT Color 2", &Long_data, &Long ) ) Painter.Settings.Northern_AT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern AT Color 3", &Long_data, &Long ) ) Painter.Settings.Northern_AT_Color_3 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern IT Color 1", &Long_data, &Long ) ) Painter.Settings.Northern_IT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern IT Color 2", &Long_data, &Long ) ) Painter.Settings.Northern_IT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Northern IT Color 3", &Long_data, &Long ) ) Painter.Settings.Northern_IT_Color_3 = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern AT Color 1", &Long_data, &Long ) ) Painter.Settings.Southern_AT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern AT Color 2", &Long_data, &Long ) ) Painter.Settings.Southern_AT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern AT Color 3", &Long_data, &Long ) ) Painter.Settings.Southern_AT_Color_3 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern IT Color 1", &Long_data, &Long ) ) Painter.Settings.Southern_IT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern IT Color 2", &Long_data, &Long ) ) Painter.Settings.Southern_IT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Southern IT Color 3", &Long_data, &Long ) ) Painter.Settings.Southern_IT_Color_3 = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western AT Color 1", &Long_data, &Long ) ) Painter.Settings.Western_AT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western AT Color 2", &Long_data, &Long ) ) Painter.Settings.Western_AT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western AT Color 3", &Long_data, &Long ) ) Painter.Settings.Western_AT_Color_3 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western IT Color 1", &Long_data, &Long ) ) Painter.Settings.Western_IT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western IT Color 2", &Long_data, &Long ) ) Painter.Settings.Western_IT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Western IT Color 3", &Long_data, &Long ) ) Painter.Settings.Western_IT_Color_3 = Long_data;

 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern AT Color 1", &Long_data, &Long ) ) Painter.Settings.Eastern_AT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern AT Color 2", &Long_data, &Long ) ) Painter.Settings.Eastern_AT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern AT Color 3", &Long_data, &Long ) ) Painter.Settings.Eastern_AT_Color_3 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern IT Color 1", &Long_data, &Long ) ) Painter.Settings.Eastern_IT_Color_1 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern IT Color 2", &Long_data, &Long ) ) Painter.Settings.Eastern_IT_Color_2 = Long_data;
 Long = sizeof( LONG ); if( PrfQueryProfileData( Ini_file, "Colors", "Eastern IT Color 3", &Long_data, &Long ) ) Painter.Settings.Eastern_IT_Color_3 = Long_data;

 // ⠥ ᯨ᮪ ᪫祭.
 {
  CHAR Item[ SIZE_OF_NAME ] = "";

  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 1", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_1, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 2", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_2, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 3", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_3, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 4", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_4, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 5", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_5, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 6", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_6, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 7", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_7, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Drawing 8", Item, &Name ); strcpy( Painter.Settings.Exceptions.Drawing_8, Item ); Item[ 0 ] = 0;

  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 1", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_1, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 2", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_2, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 3", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_3, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 4", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_4, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 5", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_5, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 6", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_6, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 7", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_7, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "BorderDrawing 8", Item, &Name ); strcpy( Painter.Settings.Exceptions.BorderDrawing_8, Item ); Item[ 0 ] = 0;

  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 1", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_1, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 2", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_2, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 3", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_3, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 4", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_4, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 5", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_5, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 6", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_6, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 7", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_7, Item ); Item[ 0 ] = 0;
  Name = SIZE_OF_NAME; PrfQueryProfileData( Ini_file, "ExceptionList", "Rolling 8", Item, &Name ); strcpy( Painter.Settings.Exceptions.Rolling_8, Item ); Item[ 0 ] = 0;
 }

 // .
 return;
}

//  ⠥ ன  ⮣, ⮡ 뢠    롮 梥 "" 

// Ini_file - 䠩 ஥.
VOID Painter_ReadSettingsForRooms( HINI Ini_file )
{
 // 뢠  ६.
 bzero( &Painter, sizeof( Painter ) );

 //  梥  㬮砭  ⠥ ன.
 Painter_SetPreDefinedSettings( SET_ROOMS );
 Painter_ReadSettings( Ini_file );

 // .
 return;
}