
//   箪  

// Frame_window -  ࠬ.
HPOINTER Painter_QueryWindowIcon( HWND Frame_window )
{
 //     窨  㬮砭,  ⠭  .
 if( WindowIsCreatedBy( APP_EPM, Frame_window ) ) return Resources.Default_icons[ ICON_VIEWDOC ];

 //    窨  㬮砭  ⠭ ࠧ  ᥣ.
 HPOINTER Icon = NULLHANDLE;

 if( IsWinListWindow( Frame_window ) ) Icon = Resources.Default_icons[ ICON_WINLIST ];

 if( Icon == NULLHANDLE )
  {
   if( WindowIsCreatedBy( APP_VIEWDOC, Frame_window ) ) Icon = Resources.Default_icons[ ICON_VIEWDOC ];
  }

 if( Icon == NULLHANDLE )
  {
   if( WindowIsCreatedBy( APP_PMFORMAT, Frame_window ) ||
       WindowIsCreatedBy( APP_PMCHKDSK, Frame_window ) )
    {
     HWND Shell_window = GetDetectedShellWindow();

     if( Shell_window != NULLHANDLE )
      {
       Icon = (HPOINTER) WinSendMsg( Shell_window, WM_QUERYICON, 0, 0 );
      }
    }
  }

 if( Icon == NULLHANDLE )
  {
   if( WindowIsCreatedBy( APP_APPLETVIEWER, Frame_window ) )
    {
     HWND Related_window = FindRelatedFrameWindow( Frame_window, &IsHotJavaBrowserWindow );

     if( Related_window != NULLHANDLE )
      {
       Icon = (HPOINTER) WinSendMsg( Related_window, WM_QUERYICON, 0, 0 );
      }
    }
  }

 if( Icon == NULLHANDLE )
  {
   if( WindowIsCreatedBy( APP_HTTPD, Frame_window ) ) Icon = Resources.Default_icons[ ICON_SERVER ];
   if( WindowIsCreatedBy( APP_WEB2, Frame_window ) ) Icon = Resources.Default_icons[ ICON_SERVER ];
   if( WindowIsCreatedBy( APP_SSHD, Frame_window ) ) Icon = Resources.Default_icons[ ICON_SERVER ];
   if( WindowIsCreatedBy( APP_NFTPPM, Frame_window ) ) Icon = Resources.Default_icons[ ICON_NFTPPM ];
  }

 // ᫨ 箪  ⠭ - 頥 .
 if( Icon != NULLHANDLE )
  {
   if( Painter.Settings.Draw_system_menus ) WinPostQueueMsg( Enhancer.Modules.Changer->Message_queue, SM_CHANGE_ICON, (MPARAM) Frame_window, (MPARAM) Icon );
   return Icon;
  }

 //  箪 .
 Icon = (HPOINTER) WinSendMsg( Frame_window, WM_QUERYICON, 0, 0 );

 // ᫨  ⮩ 箪 - ⠢ 箪  ࠦ 誠.
 HWND Desktop = QueryDesktopWindow();

 if( Icon == WinQuerySysPointer( Desktop, SPTR_APPICON, 0 ) )
  {
   Icon = WinQuerySysPointer( Desktop, SPTR_PROGRAM, 0 );

   if( Painter.Settings.Draw_system_menus ) WinPostQueueMsg( Enhancer.Modules.Changer->Message_queue, SM_CHANGE_ICON, (MPARAM) Frame_window, (MPARAM) Icon );
   return Icon;
  }

 // ᫨  ⥭ - 頥 箪 ,  ,  箪  㬮砭.
 //  箪     -   ﭭ ᮢ, ஥ 룫廊  "" ࠬ.
 if( Icon == NULLHANDLE )
  {
   //   ࠡ祣 ⮫.
   HWND Desktop = QueryDesktopWindow();

   // ᬠਢ  楢.
   HWND Owner_window = WinQueryWindow( Frame_window, QW_FRAMEOWNER );

   while( Owner_window != Desktop && Owner_window != NULLHANDLE )
    {
     // ᫨  -  ࠬ:
     if( IsFrameWindow( Owner_window ) )
      {
       //   箪.
       Icon = (HPOINTER) WinSendMsg( Owner_window, WM_QUERYICON, 0, 0 );

       // ᫨   - 頥 .
       if( Icon != NULLHANDLE ) return Icon;
      }

     //  ᫥饣 .
     Owner_window = WinQueryWindow( Owner_window, QW_FRAMEOWNER );
    }

   //    ਫ.
   HWND Main_window = QueryMainWindow( Frame_window );

   // ᫨  㣮 :
   if( Main_window != Frame_window )
    {
     //   箪.
     Icon = (HPOINTER) WinSendMsg( Main_window, WM_QUERYICON, 0, 0 );

     // ᫨   - 頥 .
     if( Icon != NULLHANDLE ) return Icon;
    }

   //  । ᮮ饭 .
   HMQ Message_queue = WinQueryWindowULong( Frame_window, QWL_HMQ );

   //   窨.
   HWND Shell_window = GetDetectedShellWindow();

   if( Shell_window != NULLHANDLE )
    {
     //  । ᮮ饭   窨.
     HMQ Shell_queue = WinQueryWindowULong( Shell_window, QWL_HMQ );

     // ᫨ । ᮢ - 頥  箪.
     if( Shell_queue == Message_queue ) return (HPOINTER) WinSendMsg( Shell_window, WM_QUERYICON, 0, 0 );

     // ᫨  -  ⠭,   ᮧ 窮 - 頥 箪  窨.
     if( IsWorkplaceShellWindow( Frame_window ) ) return (HPOINTER) WinSendMsg( Shell_window, WM_QUERYICON, 0, 0 );
    }

   // ॡࠥ    ࠡ祣 ⮫.
   HENUM Enumeration = WinBeginEnumWindows( Desktop ); HWND Window = NULLHANDLE;
   while( ( Window = WinGetNextWindow( Enumeration ) ) != NULLHANDLE )
    {
     // ᫨    ᠬ  - த ॡ .
     if( Window == Frame_window ) continue;

     //  ᯮ    ﭨ.
     SWP Window_state = { 0, 0, 0, 0, 0, NULLHANDLE, NULLHANDLE, 0, 0 };
     WinQueryWindowPos( Window, &Window_state );

     // ᫨      㬥襭  箪:
     if( !( Window_state.fl & SWP_HIDE ) ) if( !( Window_state.fl & SWP_MINIMIZE ) )
      {
       // ᫨     ४ - த ॡ .
       if( !PermissionForSwitching( Window ) ) continue;
      }

     //  । ᮮ饭 .
     HMQ Window_queue = WinQueryWindowULong( Window, QWL_HMQ );

     // ᫨ । ᮢ - 㧭  箪.
     if( Window_queue == Message_queue )
      {
       //  箪 .
       Icon = (HPOINTER) WinSendMsg( Window, WM_QUERYICON, 0, 0 );

       // ᫨   - 頥 .
       if( Icon != NULLHANDLE )
        {
         // 蠥 ॡ .
         WinEndEnumWindows( Enumeration );

         // 頥 箪.
         return Icon;
        }
      }
    }
   WinEndEnumWindows( Enumeration );

   //    ਫ, ᮧ襬 .
   CHAR Path[ SIZE_OF_PATH ] = ""; GetDetectedExePath( Frame_window, Path );

   // ᫨  㤠 ।:
   if( Path[ 0 ] != 0 )
    {
     //   ਫ, ᮧ襣 .
     CHAR Name[ SIZE_OF_PATH ] = ""; GetDetectedExeName( Frame_window, Name );

     // ⠢塞  .
     strcat( Path, "\\" ); strcat( Path, Name );

     // 㦠 箪  䠩 ਫ.
     Icon = WinLoadFileIcon( Path, 0 );

     // 㧪  , ⮬  ⮬ 砥   箪 . 
     // ୮ 㧪  窠 , ⠪   ᤥ  ,
     //  뫠 ᮮ饭  ⮪ Changer.
     WinSendMsg( Frame_window, WM_SETICON, (MPARAM) Icon, 0 );

     // ,  箪  㦥  ᪠.
     BYTE Icon_was_loaded = 1; SetProperty( Frame_window, PRP_ICON_WAS_LOADED, &Icon_was_loaded );

     // 頥 箪.
     return Icon;
    }

   //   ﭭ ࠧ 롨ࠥ ⮩ 箪.
   if( WindowIsDialog( Frame_window ) )
    {
     return Resources.Default_icons[ ICON_LEAF ];
    }
   //  ⠫  -    ⮣,   ४  .
   else
    {
     HSWITCH Switch_handle = WinQuerySwitchHandle( Frame_window, NULLHANDLE );

     if( Switch_handle != NULLHANDLE ) return Resources.Default_icons[ ICON_LEAVES ];
     else return Resources.Default_icons[ ICON_LEAF ];
    }

   //  , 箪     ᢮⢠ ࠭.
   FindProperty( Frame_window, PRP_ICON, &Icon );
  }

 // .
 return Icon;
}

//  ।,    ᮢ  砥, ᫨  ப  㯭 

// Frame_window -  ࠬ.
LONG Painter_PossibleAllowedActions( HWND Frame_window )
{
 //     㦭 ᥣ.
 if( IsRZApiWindow( Frame_window ) ) return ALL_ACTIONS;

 // .
 return NO_ACTION;
}

//  ।,   ᮢ    㬥襭 

// Frame_window -  ࠬ.
BYTE Painter_MinimizeActionIsAllowed( HWND Frame_window )
{
 //    ⪫   WPS.
 if( Painter.Settings.Accelerate_folders_closing )
  {
   // ᫨     WPS  MDesk -  ᮢ  , .
   if( IsFolderWindow( Frame_window ) ) return 0;
   if( IsJobCnrWindow( Frame_window ) ) return 0;
   if( IsMDeskWindow( Frame_window ) ) return 0;
  }

 // .
 return 1;
}

//  ।,   ᮢ   ⮫쪮   

// Frame_window -  ࠬ.
LONG Painter_OneActionIsAllowed( HWND Frame_window )
{
 //   WPS:
 if( Painter.Settings.Accelerate_folders_closing )
  {
   if( IsWinListWindow( Frame_window ) ) return HIDE_ACTION;
   if( IsPaletteWindow( Frame_window ) ) return CLOSE_ACTION;
  }

 //   Java:
 if( IsJavaWindow( WinWindowFromID( Frame_window, FID_CLIENT ) ) &&
     WindowIsCreatedBy( APP_APPLETVIEWER, Frame_window ) ) return CLOSE_ACTION;

 // .
 return NO_ACTION;
}

//   ﭨ   ࠢ 孥 㣫  

// Frame_window -  ࠬ, Target -    ஢, Consider_all_settings - 뢠  ன  .
LONG Painter_QueryButtonsState( HWND Frame_window, ULONG Target, BYTE Consider_all_settings )
{
 //     ࠢ쭮.
 if( Target & RESTORE_ACTION || Target & ROLLUP_ACTION )
  {
   Target &= ~RESTORE_ACTION;
   Target &= ~ROLLUP_ACTION;

   Target |= MAXIMIZE_ACTION;
  }

 //   ⨭   孥 㣫 .
 HWND SysMenu_window = WinWindowFromID( Frame_window, FID_SYSMENU );

 //    .
 HWND MinMax_window = WinWindowFromID( Frame_window, FID_MINMAX );

 // ᫨  ⨭      - ᮢ    . ਫ 
 //  ᥡ  㣮, ਬ, Regedit ਭ ⨥     ⨥ "".
 if( SysMenu_window == NULLHANDLE ) if( MinMax_window == NULLHANDLE ) return NO_ACTION;

 // ᫨   ⨭ - 㧭 ﭨ , ஥   ⨨  .
 // ᫨  ⨭ ,      - 㧭  ﭨ.
 BYTE Ask_SysMenu = 0; if( SysMenu_window != NULLHANDLE ) Ask_SysMenu = 1;
 BYTE Ask_MinMax = 0; if( SysMenu_window == NULLHANDLE ) if( MinMax_window != NULLHANDLE ) Ask_MinMax = 1;

 // ᫨  ᮢ  - .
 if( !Painter_PermissionForButtonsDrawing( Frame_window ) ) return NO_ACTION;

 //  ﭨ .
 LONG Draw_maximize_button = 0; LONG Draw_minimize_button = 0; LONG Draw_close_button = 0;
 LONG Draw_rollup_button = 0; LONG Draw_restore_button = 0; LONG Draw_hide_button = 0;

 // ᫨ 訢 ﭨ  - ஢塞,   ⨭  .
 if( Ask_SysMenu )
  {
   // ᫨  ⨭   - ᮢ   , .
   if( !WindowIsPresent( SysMenu_window ) ) return NO_ACTION;

   //   .
   HWND TitleBar_window = WinWindowFromID( Frame_window, FID_TITLEBAR );

   // ᫨     - ᮢ   , .
   if( !WindowIsPresent( TitleBar_window ) ) return NO_ACTION;
  }

 // ᫨ 訢 ﭨ  - ஢塞,   .
 if( Ask_MinMax )
  {
   //   .
   HWND TitleBar_window = WinWindowFromID( Frame_window, FID_TITLEBAR );

   // ᫨     - ᮢ   , .
   if( !WindowIsPresent( TitleBar_window ) ) return NO_ACTION;
  }

 //     ᮢ ⮫쪮  .
 if( Consider_all_settings )
  {
   // , ⠪  .
   LONG Action = Painter_OneActionIsAllowed( Frame_window );
   if( Action != NO_ACTION ) return Action;
  }

 //  ⥪饥 ﭨ .
 LONG Current_state = NO_ACTION; FindProperty( Frame_window, PRP_BUTTONS, &Current_state );

 // ᫨  ⭮    ᮢ -  㧭 ﭨ ப   .
 if( Current_state == NO_ACTION )
  if( Painter.Settings.Draw_frames ) if( Painter.Settings.Draw_buttons )
   Target = ALL_ACTIONS;

 if( Target & MAXIMIZE_ACTION )
  {
   if( Ask_SysMenu ) Draw_maximize_button = (LONG) WinSendMsg( SysMenu_window, MM_ISITEMVALID, MPFROM2SHORT( SM_MAXIMIZE, INCLUDE_SUBMENUS ), 0 );
   if( Ask_MinMax ) Draw_maximize_button = (LONG) WinSendMsg( MinMax_window, MM_ISITEMVALID, MPFROM2SHORT( SM_MAXIMIZE, 0 ), 0 );
  }
 else
  {
   Draw_maximize_button = Current_state & MAXIMIZE_ACTION;
   Draw_rollup_button = Current_state & ROLLUP_ACTION;
  }

 if( Target & MINIMIZE_ACTION )
  {
   if( Ask_SysMenu ) Draw_minimize_button = (LONG) WinSendMsg( SysMenu_window, MM_ISITEMVALID, MPFROM2SHORT( SM_MINIMIZE, INCLUDE_SUBMENUS ), 0 );
   if( Ask_MinMax ) Draw_minimize_button = (LONG) WinSendMsg( MinMax_window, MM_ISITEMVALID, MPFROM2SHORT( SM_MINIMIZE, 0 ), 0 );
  }
 else
  {
   Draw_minimize_button = Current_state & MINIMIZE_ACTION;
  }

 if( Target & CLOSE_ACTION )
  {
   if( Ask_SysMenu ) Draw_close_button = (LONG) WinSendMsg( SysMenu_window, MM_ISITEMVALID, MPFROM2SHORT( SM_CLOSE, INCLUDE_SUBMENUS ), 0 );
   if( Ask_MinMax ) Draw_close_button = (LONG) WinSendMsg( MinMax_window, MM_ISITEMVALID, MPFROM2SHORT( SM_CLOSE, 0 ), 0 );
  }
 else
  {
   Draw_close_button = Current_state & CLOSE_ACTION;
  }

 //   㬥襭    ᮪.
 if( !Draw_minimize_button )
  {
   if( Target & MINIMIZE_ACTION )
    {
     if( Ask_SysMenu ) Draw_hide_button = (LONG) WinSendMsg( SysMenu_window, MM_ISITEMVALID, MPFROM2SHORT( SM_HIDE, INCLUDE_SUBMENUS ), 0 );
     if( Ask_MinMax ) Draw_hide_button = (LONG) WinSendMsg( MinMax_window, MM_ISITEMVALID, MPFROM2SHORT( SM_HIDE, 0 ), 0 );
    }
   else
    {
     Draw_hide_button = Current_state & HIDE_ACTION;
    }
  }

 //      ᮢ  .
 if( Consider_all_settings ) if( Draw_minimize_button || Draw_hide_button )
  if( !Painter_MinimizeActionIsAllowed( Frame_window ) )
   Draw_minimize_button = Draw_hide_button = 0;

 // ᫨  㢥祭 -  ᮢ  "⠭"  " ".
 // ᫨  㢥祭  -    㣨 .
 if( !Draw_maximize_button )
  {
   //  ᯮ    ﭨ.
   SWP Window_placement = { 0, 0, 0, 0, 0, NULLHANDLE, NULLHANDLE, 0, 0 };
   WinQueryWindowPos( Frame_window, &Window_placement );

   // ᫨  㢥祭 -  ᮢ  "⠭"  " ".
   if( Window_placement.fl & SWP_MAXIMIZE )
    {
     Draw_rollup_button = 1;
     Draw_restore_button = 1;
    }
  }

 //    ᮢ  " "  .
 if( Consider_all_settings ) if( Draw_rollup_button )
  Draw_rollup_button = Painter_PermissionForRolling( Frame_window );

 //   ﭭ ࠧ   ᮢ  㢥祭.
 if( Draw_maximize_button || Draw_restore_button )
  if( FrameType( Frame_window ) == FT_CONST )
   Draw_maximize_button = Draw_restore_button = Draw_rollup_button = 0;

 // ᫨ 訢 ﭨ     ப 㯭 -  ᮢ   㬮砭.
 if( Ask_SysMenu )
  if( !Draw_maximize_button && !Draw_minimize_button && !Draw_rollup_button && !Draw_close_button )
   return Painter_PossibleAllowedActions( Frame_window );

 //  ﭨ .
 LONG Buttons_state = NO_ACTION;
 if( Draw_maximize_button ) Buttons_state |= MAXIMIZE_ACTION;
 if( Draw_minimize_button ) Buttons_state |= MINIMIZE_ACTION;
 if( Draw_hide_button ) Buttons_state |= HIDE_ACTION;
 if( Draw_restore_button ) Buttons_state |= RESTORE_ACTION;
 if( Draw_rollup_button ) Buttons_state |= ROLLUP_ACTION;
 if( Draw_close_button ) Buttons_state |= CLOSE_ACTION;

 // .
 return Buttons_state;
}
