/* Rexx */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'; Call SysLoadFuncs

/*  뢮  */
'@Echo off'

/* * */

/* ࠥ ࠬ */
Parse Arg Parameters
If Pos( '--action=', Parameters ) = 0 then Exit

Language = 'En'; If Pos( '--language=russian', Parameters ) \= 0 then Language = 'Ru'
Uninstall = 0;   If Pos( '--action=uninstall', Parameters ) \= 0 then Uninstall = 1

/*  ⥪騩 ⠫ */
Parse Source OS2 Type Path

Last_slash = Lastpos( '\', Path ); Path = Substr( Path, 1, Last_slash - 1 )
Last_slash = Lastpos( '\', Path ); Path = Substr( Path, 1, Last_slash - 1 )

/* * */

/* ⠭ ⥫: */
If Uninstall = 0 then
 Do
  Call CreateWPSIcons
  Call StopEnhancer
  Call StartInspector

  Call ModifyConfigSys
 End
/* 塞 ⥫: */
Else
 Do
  Call DeleteWPSIcons
  Call StopEnhancer
  Call UnlockFiles
 End

/* 室 */
Exit

/* * */

/*  窨  ࠡ祬 ⮫ */
CreateWPSIcons: procedure expose Language Path

 /*    ⠢騬 ⥫ */
 Path_to_Enhancer = Path || '\Enhancer'

 /* / */

 /*   ࠡ祬 ⮫   窮 */
 Background = Stream( Path || '\Install\Notes.bmp', 'C', 'Query Exists' )
 If Background \= '' then Background = 'Background=' || Background

 Icon_name = 'Nice-OS/2^for eComStation'
 Icon = Stream( Path || '\Install\Nice-os2.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPFolder', Icon_name, '<WP_DESKTOP>', 'ObjectID=<WP_NICE>;' || Icon || ';' || Background, 'Replace'

 /* / */

 /*  窨 */
 If Language = 'Ru' then Icon_name = 'Nice-OS/2^()'
 Else Icon_name = 'Nice-OS/2^(daemon)'
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || Path || '\Install\StrtNice.exe', 'Replace'

 If Language = 'Ru' then Icon_name = '⠭^'
 Else Icon_name = 'Shutdown^daemon'
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || Path || '\Install\StopNice.exe', 'Replace'

 If Language = 'Ru' then Icon_name = 'ன'
 Else Icon_name = 'Control Center'
 Icon = Stream( Path || '\Install\Nice-os2.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_NICE_OS2>;' || Icon || ';' || Background, 'Replace'

 If Language = 'Ru' then
  Do
   Icon_name = '㪮⢮'
   Help_name = Path_to_Enhancer || '\Nice-os2.inf ᯮ짮'
  End
 Else
  Do
   Icon_name = 'About Nice-OS/2'
   Help_name = Path_to_Enhancer || '\Nice-os2.inf Using'
  End
 Icon = Stream( Path || '\Install\Text.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || 'View.exe;Parameters=' || Help_name || ';' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Rooms'
 Icon = Stream( Path || '\Install\Rooms.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_ROOMS_FOLDER>;' || Icon || ';' || Background, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Utilites'
 Icon = Stream( Path || '\Install\Utilites.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_ENHANCER_UTILITES>;' || Icon || ';' || Background, 'Replace'

 If Language = 'Ru' then Icon_name = ' 䠩'
 Else Icon_name = 'File names'
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ENHANCER_UTILITES>', 'ObjectID=<WP_NAMES>;ExeName=' || Path || '\Utilites\Names\Names.exe', 'Replace'

 If Language = 'Ru' then
  Do
   Icon_name = ' ^⥪⮢ ०'
   Help_name = Path || '\Utilites\VIOFont\VIOFont.inf '
   Icon = Stream( Path || '\Install\Font.ico', 'C', 'Query Exists' )
   If Icon \= '' then Icon = 'IconFile=' || Icon
   Call SysCreateObject 'WPProgram', Icon_name, '<WP_ENHANCER_UTILITES>', 'ExeName=' || 'View.exe;Parameters=' || Help_name || ';' || Icon, 'Replace'
  End

 /* / */

 /*  窨   "ன  ६ ࠡ" */
 If Language = 'Ru' then Icon_name = '।^ࠦ'
 Else Icon_name = 'Advanced scrolling'
 Icon = Stream( Path || '\Install\Scr_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Scrolling;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '譨  '
 Else Icon_name = 'Window frames'
 Icon = Stream( Path || '\Install\Drw_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Drawing;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Rooms'
 Icon = Stream( Path || '\Install\Rms_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Rooms;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '⮢ '
 Else Icon_name = 'VIO windows'
 Icon = Stream( Path || '\Install\Vio_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_VIO;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Keyboard'
 Icon = Stream( Path || '\Install\Kbd_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Keyboard;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Mouse'
 Icon = Stream( Path || '\Install\Mse_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Mouse;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = 'ᯮ^'
 Else Icon_name = 'Window placement'
 Icon = Stream( Path || '\Install\Wnd_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_WindowPlacement;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = ''
 Else Icon_name = 'Dialog boxes'
 Icon = Stream( Path || '\Install\Dlg_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_DialogBoxes;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '  '
 Else Icon_name = 'Drive on demand'
 Icon = Stream( Path || '\Install\Itm_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_FileWindows;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = 'ਮ'
 Else Icon_name = 'Priority'
 Icon = Stream( Path || '\Install\Pty_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_Priority;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '᮪ '
 Else Icon_name = 'Window list'
 Icon = Stream( Path || '\Install\Lst_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_WinList;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '⪨'
 Else Icon_name = 'System patches'
 Icon = Stream( Path || '\Install\Dsk_page.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-ecs.exe;Parameters=ControlCenter_SysPatches;' || Icon, 'Replace'

 /* / */

 /*  窨   "" */
 If Language = 'Ru' then Icon_name = '1.  '
 Else Icon_name = '1. Western room'
 Icon = Stream( Path || '\Install\Western.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_WESTERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Western;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '2. ୠ '
 Else Icon_name = '2. Northern room'
 Icon = Stream( Path || '\Install\Northern.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_NORTHERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Northern;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '3. 稩 ⮫'
 Else Icon_name = '3. Desktop'
 Icon = Stream( Path || '\Install\Desktop.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_DESKTOP_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Desktop;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '4.  '
 Else Icon_name = '4. Southern room'
 Icon = Stream( Path || '\Install\Southern.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_SOUTHERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Southern;' || Icon, 'Replace'

 If Language = 'Ru' then Icon_name = '5. 筠 '
 Else Icon_name = '5. Eastern room'
 Icon = Stream( Path || '\Install\Eastern.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_EASTERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Eastern;' || Icon, 'Replace'

 /* / */

 /*  ⥭   "OS/2 System" */
 Call SysCreateShadow '<WP_NICE>', '<WP_OS2SYS>'

/*  */
Return

/* * */

/*  窨  ࠡ祬 ⮫ */
DeleteWPSIcons: procedure

 /* 塞 窨 */
 Call SysDestroyObject '<WP_NICE>'

/*  */
Return

/* * */

/* ᪠  ਫ */
StartInspector: procedure expose Path

 /* ᪠  ਫ */
 '' || Path || '\Enhancer\Inspectr\Inspectr.exe'

/*  */
Return

/* * */

/* ⠭ ⥫ */
StopEnhancer: procedure expose Path

 /* ⠭ ⥫, ᫨   饭 */
 '' || Path || '\Install\StopNice.exe'

 /*  ஥ ६ */
 Call SysSleep 1

/*  */
Return

/* * */

/* ᢮ 䠩 */
UnlockFiles: procedure expose Path

 /* ᢮ 䠩 */
 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-os2.exe"'
 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-os2.dll"'
 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-ecs.exe"'

/*  */
Return

/* * */

/*  ப  䠩 "Config.sys" */
ModifyConfigSys: procedure expose Path Language

 /*  ६ */
 Line_break = X2C( '0D' ) || X2C( '0A' )

 Path_to_Enhancer = Path || '\Enhancer'
 Drive = Left( Value( 'Comspec', , 'OS2Environment' ), 1 )

 /* / */

 /* ⠥ 䠩 Config.sys */
 ConfigSys_file = Drive || ':\Config.sys'
 Content = CharIn( ConfigSys_file, , Chars( ConfigSys_file ) )
 Call Stream ConfigSys_file, 'C', 'Close'

 Do 1000
  Text = Content
  Content = Strip( Content, 'B', X2C( '0A' ) )
  Content = Strip( Content, 'B', X2C( '0D' ) )

  If Content = Text then Leave
 End

 If Content = '' then Exit

 /* ᫨  ६ 㤥 祭, 䠩 㤥  */
 Modify_Config_sys = 0;

 /* / */

 /* 室  ⥪ ப "LIBPATH", 室 "REM ..." */
 Libpath_string = Line_break || 'LIBPATH'
 Position = Pos( Libpath_string, Content )

 If Position \= 0 then
  Do
   /* 뤥塞  ப */
   First_part = Left( Content, Position + 1 )
   Second_part = Right( Content, Length( Content ) - Position )

   End_of_line = Pos( Line_break, Second_part ) - 1
   Libpath = Substr( Second_part, 1, End_of_line )
   Second_part = Substr( Second_part, End_of_line + 1 )

   Parse Var Libpath Setting_name '=' Libpath
   Libpath = Strip( Libpath )

   /* ᫨  ப  ᮤন 뫪  ⥪騩 ⠫ - 塞  */
   Save_settings = 0

   If Pos( '.;', Libpath ) = 0 then
    Do
     Libpath = '.;' || Libpath

     Save_settings = 1
    End

   /* ᫨  ப  ᮤন   Nice - 塞  */
   If Pos( Path_to_Enhancer, Libpath ) = 0 then
    Do
     /* ப  ᮤঠ ।騩  -      */
     Previous_path = ''

     Parse Var Libpath Before '\Enhancer' Behind

     If Before = Libpath then
      Parse Var Libpath Before '\ENHANCER' Behind

     If Before = Libpath then
      Parse Var Libpath Before '\enhancer' Behind

     If Before = Libpath then
      Before = ''

     If Before \= '' | Behind \= '' then
      Do
       /* 頥 ப */
       Count = Length( Before )

       Do While Count > 0
        Previous_path = Right( Before, 1 ) || Previous_path
        Before = Left( Before, Length( Before ) - 1 )

        If Right( Before, 1 ) = ';' then Leave
        Count = Count - 1
       End

       /* 塞 ப */
       If Left( Behind, 1 ) = ';' then Behind = Substr( Behind, 2, Length( Behind ) - 1 )
       Libpath = Before || Behind
      End

     /* 塞  ப   ⥫ */
     Path_for_ConfigSys = Path_to_Enhancer

     If Right( Libpath, 1 ) \= ';' then Path_for_ConfigSys = ';' || Path_for_ConfigSys
     Libpath = Libpath || Path_for_ConfigSys

     Save_settings = 1
    End

   /* ன  㤥 ࠭ */
   If Save_settings then
    Do
     /* ⠢ ன */
     Content = First_part || 'LIBPATH=' || Libpath || Second_part

     If Right( Content, 2 ) = Line_break then
      Content = Substr( Content, 1, Length( Content ) - 2 )

     /* ,     ᠭ */
     Modify_Config_sys = 1
    End
  End

 /* / */

 /* 塞 ப ᪠ MMKbd  MPTSINI */
 Do Patch_step = 1 to 2
  Patch_name_MC = 'MMKbd.exe'; If Patch_step = 2 then Patch_name_MC = 'MPTSINI.exe';
  Patch_name_UC = 'MMKBD.EXE'; If Patch_step = 2 then Patch_name_UC = 'MPTSINI.EXE';
  Patch_name_LC = 'mmkbd.exe'; If Patch_step = 2 then Patch_name_LC = 'mptsini.exe';

  Position_1 = Pos( Patch_name_MC, Content )
  Position_2 = Pos( Patch_name_UC, Content )
  Position_3 = Pos( Patch_name_LC, Content )

  If Position_1 = 0 & Position_2 = 0 & Position_3 = 0 then
   Do
    /* 塞 ப */
    String = 'RUN=' || Path_to_Enhancer || '\SysPatch\' || Patch_name_MC
    Parse Upper Var String String

    Content = Content || Line_break
    Content = Content || String

    /* ,  ன   ᠭ */
    Modify_Config_sys = 1
   End
 End

 /* / */

 /* 뢠 ன */
 If Modify_Config_sys then
  Do
   /* २뢠 䠩 Config.sys */
   'Del /F ' Drive || ':\Config.nic' || ' >NUL 2>NUL'
   'Attrib -R -H -S ' || ConfigSys_file || ' >NUL 2>NUL'
   'Ren ' || ConfigSys_file || ' Config.nic' || ' >NUL 2>NUL'

   /* ࠭塞 ன */
   Call LineOut ConfigSys_file, Content, 1
   Call Stream ConfigSys_file, 'C', 'Close'

   /* 뢠 짮⥫ ᮮ饭 */
   Call SayAboutConfigSys
  End

/*  */
Return

/* * */

/* 頥 짮⥫  짥 १㧪 */
SayAboutConfigSys: procedure expose Language

 If Language = 'Ru' then
  Do
   Call RxMessageBox '⠭ 襭.  믮 १㧪 ', 'Nice-OS/2 Enhancer', 'OK', 'Information'
   Call RxMessageBox '१㧪 㦭  ⮣, ⮡ ਬ ன  "Config.sys"', 'Nice-OS/2 Enhancer', 'OK', 'Warning'
  End
 Else
  Do
   Call RxMessageBox 'Installation complete. Now reboot your computer', 'Nice-OS/2 Enhancer', 'OK', 'Information'
   Call RxMessageBox 'Reboot is necessary to apply new settings in "Config.sys"', 'Nice-OS/2 Enhancer', 'OK', 'Warning'
  End

/*  */
Return
