/*
	Traffic Visor III NDIS driver 
	Install/remove script

					Vasilkin Andrey, 2006
*/

fname_driver = 'TV3CAP.SYS'
free_drv_num = '12345678'

say 'TrafficVisor III NDIS driver'
say

parse upper arg '/'op '/D:'drv

if (op\='I' & op\='U') | (drv\='' & (drv<'A' | drv>'Z')) then
do
  say 'Usage: INSTALL.CMD {/I|/U} [/D:<drive>]'
  say '  /I	Install/update driver'
  say '  /U	Remove driver'
  say '  /D:d	Disk drive where MPTN is installed'
  exit
end

boot_drive = GetOS2BootDrive()
if drv = '' then
do
  mptn_drive = boot_drive
  optionD = 0
end
else do
  mptn_drive = drv':'
  optionD = 1
end

fname_config_sys   = boot_drive'\CONFIG.SYS'
fname_protocol_ini = mptn_drive'\IBMCOM\PROTOCOL.INI'

rc = readFile(fname_config_sys, 'config_sys')
call failRC rc,"can't read "fname_config_sys
rc = readFile(fname_protocol_ini, 'protocol_ini')
call failRC rc,"can't read "fname_protocol_ini". Option /D: must be specified."
call getTV3MACs

if op = 'I' then
  call Install
else
  call UnInstall

EXIT

/************************************************************/
/*                                                          */
/*                   U n i n s t a l l                      */
/*                                                          */
/************************************************************/

UnInstall:
  say 'Uninstall...'
  call getTV3PROTs

  /* ⠭  ᥪ権  ࠬ Bindings */
  do i = 1 to protocol_ini.0
    parse var protocol_ini.i param '=' val
    if translate(strip(param))='BINDINGS' then
    do
      val = translate(val,' ',',');
      bindings = ''
      do j = 1 to words(val)
        item = word(val,j)
        do k = 1 to TV3MAC_sections.0
          if translate(item)=translate(TV3MAC_sections.k) & symbol('TV3MAC_sections.'k'.proto_bindings')='VAR' then
          do
            item = value(TV3MAC_sections.k.'proto_bindings')
            leave
          end
        end
        if bindings \= '' then bindings = bindings', '
        bindings = bindings || item
      end
      protocol_ini.i = param'= 'bindings
    end
  end

  /*  protocol.ini */
  if TV3MAC_sections.0 > 0 then
  do
    save_fname = getProtocolIniSaveFN()
    say 'Save 'fname_protocol_ini' to 'fname_protocol
    '@ren 'fname_protocol_ini' 'save_fname

    remove_lines = 0
    do i=1 to protocol_ini.0
      if remove_lines & left(strip(protocol_ini.i),1)='[' then
        remove_lines = 0

      if \remove_lines then
        do j = 1 to TV3MAC_sections.0
          remove_lines = (i = value('TV3MAC_sections.'j'.line')) | (i = value('TV3MAC_sections.'j'.proto_line'))
          if remove_lines then leave
        end

      if \remove_lines then
        call lineout fname_protocol_ini,protocol_ini.i
    end
    call stream fname_protocol_ini,'c','close'
    say 'PROTOCOL.INI is changed'
  end
  else
    say 'PROTOCOL.INI - tv3 NDIS driver not found'

  /*  config.sys */
  call WriteConfigSys 0
return

/************************************************************/
/*                                                          */
/*                     I n s t a l l                        */
/*                                                          */
/************************************************************/

Install:
  say 'Install...'
  if stream(fname_driver,'c','query exists') = '' then
    call fail "can't find file "fname_driver
  say 'Copy 'fname_driver' to 'mptn_drive'\IBMCOM\MACS'
  '@copy 'fname_driver' 'mptn_drive'\IBMCOM\MACS >nul'

  rc = getMACs('MAC_sections')
  call failRC rc,"can't find MAC for binding"
  /* TV3MAC_sections. - 㦥 騥 ᥪ樨 TV3		*/
  /* MAC_sections. - 㤠  ⪭				*/
  /* InsertLine - 㤠  ᠭ  ᥪ樨		*/
  /* free_drv_num - ᯨ᮪ ᢮ ஢   ࠩ	*/

  rc = changeMACs('TV3MAC_sections')

  /*  protocol.ini */
  if NEW_TV3MAC_sections.0 > 0 then
  do
    save_fname = getProtocolIniSaveFN()
    say 'Save 'fname_protocol_ini' to 'fname_protocol
    '@ren 'fname_protocol_ini' 'save_fname

    do i=1 to protocol_ini.0
      if ( i = InsertLine ) then
        call appendNewSections
      call lineout fname_protocol_ini,protocol_ini.i
    end
    if ( i = InsertLine ) then
      call appendNewSections
    call stream fname_protocol_ini,'c','close'
    say 'PROTOCOL.INI is changed'
  end
  else
    say 'PROTOCOL.INI - tv3 NDIS driver already installed'

  /*  config.sys */
  call WriteConfigSys NEW_TV3MAC_sections.0+TV3MAC_sections.0
return

/************************************************************/

WriteConfigSys:
  drv_count = arg(1)
  drv_val = '\IBMCOM\MACS\'fname_driver
  drv_val_len = length(drv_val)

  j = 0
  do i=1 to config_sys.0
    parse upper var config_sys.i key '=' val
    if strip(key)='DEVICE' & right(strip(val),drv_val_len) = drv_val then
      j = j+1
  end
  if j = drv_count then return 0

  i = lastpos('.',fname_config_sys)
  fname_config_save = substr(fname_config_sys,1,i) || 'tv'
  say 'Save 'fname_config_sys' to 'fname_config_save
  if stream(fname_config_save,'c','query exists') \= '' then
    '@del 'fname_config_save
  '@ren 'fname_config_sys' *.tv'

  do i=1 to config_sys.0
    parse upper var config_sys.i key '=' val
    if \(strip(key)='DEVICE' & right(strip(val),drv_val_len) = drv_val) then
      call lineout fname_config_sys, config_sys.i
  end
  do i=1 to drv_count
    call lineout fname_config_sys, 'device='mptn_drive || drv_val
  end
  call stream fname_config_sys,'c','close'
  say 'CONFIG.SYS is changed'
return 1

appendNewSections:
  do j=1 to NEW_TV3MAC_sections.0
    call lineout fname_protocol_ini,''
    call lineout fname_protocol_ini,'[' || NEW_TV3MAC_sections.j || ']'
    call lineout fname_protocol_ini,''
    drv_num = substr(free_drv_num,j,1)
    call lineout fname_protocol_ini,'   DriverName = TV3' || drv_num || 'CAP$'
    call lineout fname_protocol_ini,''
    call lineout fname_protocol_ini,'[' || NEW_TV3PROT_sections.j || ']'
    call lineout fname_protocol_ini,''
    call lineout fname_protocol_ini,'   DriverName = TV3' || drv_num || 'PR$'
    call lineout fname_protocol_ini,'   Bindings = ' || MAC_sections.j
  end
return

changeMACs:
  /*    ᥪ権 */
  j = 1
  do i = 1 to MAC_sections.0
    k = 1
    do until k > TV3MAC_sections.0
      if 'TV3'j'CAP_NIF' = translate(TV3MAC_sections.k) then
      do
        k = 1
        j = j+1
      end
      else k = k+1
    end
    NEW_TV3MAC_sections.i = 'TV3'j'CAP_nif'
    NEW_TV3PROT_sections.i = 'TV3'j'PR_nif'
    j = j+1
  end
  NEW_TV3MAC_sections.0 = MAC_sections.0
  NEW_TV3PROT_sections.0 = MAC_sections.0

  /* ⠭   ᥪ権  ࠬ Bindings */
  do i = 1 to protocol_ini.0
    parse var protocol_ini.i param '=' val
    if translate(strip(param))='BINDINGS' then
    do
      val = translate(val,' ',',');
      bindings = ''
      do j = 1 to words(val)
        item = word(val,j)
        do k = 1 to MAC_sections.0
          if translate(item) = translate(MAC_sections.k) then
          do
            item = NEW_TV3MAC_sections.k
            leave
          end
        end
        if bindings \= '' then bindings = bindings', '
        bindings = bindings || item
      end
      protocol_ini.i = param'= 'bindings
    end
  end
return 0

getMACs:
  found = 0
  do i = 1 to protocol_ini.0
    if translate(strip(protocol_ini.i))='[TCPIP_NIF]' then
    do
      found = 1
      leave
    end
  end
  if \found then return 0

  found = 0
  do i = i+1 to protocol_ini.0
    parse var protocol_ini.i param '=' val
    if translate(strip(param))='BINDINGS' then
    do
      found = 1
      leave
    end
  end
  if \found then return 0
  do i = i+1 while i < protocol_ini.0-1 & strip(protocol_ini.i)\=''
  end
  InsertLine = i

  output = arg(1)
  val = translate(val,' ',',');
  k = 0
  do i = 1 while i <= words(val)
    item = word(val,i)
    do j = 1 to TV3MAC_sections.0
      if translate(TV3MAC_sections.j) = translate(item) then
      do
        item = ''
        leave
      end
    end
    if item \= '' then
    do
      k = k+1
      call value output'.'k, item
    end
  end
  call value output'.0', k
return i

getTV3MACs:
  j = 0
  do i = 1 to protocol_ini.0
    if left(strip(protocol_ini.i,'L'),1) = '[' then
    do
      parse var protocol_ini.i '[' section ']'
      section_line = i
    end
    else do
      parse upper var protocol_ini.i param '=' val
      val = strip(val)
      if strip(param)='DRIVERNAME' & length(val)=8 & left(val,3)='TV3' & right(val,4)='CAP$' then
      do
        k = substr(val,4,1)
        if datatype(k)='NUM' & k>0 then
        do
          free_drv_num = translate(free_drv_num,' ',k)
          j = j+1
          call value 'TV3MAC_sections.'j, section
          call value 'TV3MAC_sections.'j'.drvnum', k
          call value 'TV3MAC_sections.'j'.line', section_line
        end
      end
    end
  end
  call value 'TV3MAC_sections.0', j
  free_drv_num = space(free_drv_num,0)
return j

getTV3PROTs:
  do i = 1 to protocol_ini.0
    if left(strip(protocol_ini.i,'L'),1) = '[' then
    do
      parse var protocol_ini.i '[' section ']'
      section_line = i
    end
    else do
      parse upper var protocol_ini.i param '=' val
      val = strip(val)
      if strip(param)='DRIVERNAME' & length(val)=7 & left(val,3)='TV3' & right(val,3)='PR$' then
      do
        k = substr(val,4,1)
        do j = 1 to TV3MAC_sections.0
          if value('TV3MAC_sections.'j'.drvnum') = k then
          do
            call value 'TV3MAC_sections.'j'.proto_section', section
            call value 'TV3MAC_sections.'j'.proto_line', section_line
            leave
          end
        end
      end
    end
  end

  do i = 1 to TV3MAC_sections.0
    if symbol('TV3MAC_sections.'i'.proto_line') = 'VAR' then
      do j = value('TV3MAC_sections.'i'.proto_line') + 1 to protocol_ini.0
        if left(strip(protocol_ini.j,'L'),1) = '[' then leave
        parse var protocol_ini.j param '=' val
        if translate(strip(param)) = 'BINDINGS' then
        do
          call value 'TV3MAC_sections.'i'.proto_bindings', strip(val)
          leave
        end
      end
  end
return

readFile:
  fname = arg(1)
  output = arg(2)
  i = 0
  do while lines(fname)
    i = i+1
    call value output'.'i, linein(fname)
  end
  call value output'.0', i
  call stream fname,'c','close'
return i

GetOS2BootDrive: PROCEDURE expose (exposeList)

                    /* load the REXXUTIL functions                    */
  call rxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
  call SysLoadFuncs

                    /* install a local error handler                  */
  signal on Syntax name GetOS2BootDrive1

  boot_drive = ''
  boot_drive = SysBootDrive()

GetOS2BootDrive1:
                    /* if SysBootDrive() failed, boot_drive is still  */
                    /* empty                                          */
                    /* SysBootDrive() is only in the newer versions   */
                    /* of REXXUTIL!                                   */
  if boot_drive = '' then
  do
                    /* You should do further tests to ensure that     */
                    /* the result of this method is correct!          */
    parse upper value VALUE( "PATH",, prog.__env ) with "\OS2\SYSTEM" -2,
                        boot_drive +2
  end /* if boot_drive = '' then */

return boot_drive

getProtocolIniSaveFN:
  i = lastpos('.',fname_protocol_ini)
  fname_protocol = substr(fname_protocol_ini,1,i)
  save_fname = fname_protocol || 'tv'
  do j=0 while stream(fname_protocol || 'tv' || j, 'c', 'query exists')\=''
  end
  fname_protocol = fname_protocol || 'tv' || j
return '*.tv' || j

failRC:
  if arg(1) > 0 then return
  call fail arg(2)
fail:
  say 'Error: 'arg(1)
  exit