<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8" indent="yes"/>

<xsl:template match="/">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body style="padding-left: 2em;">
  Traffic Visor III ver. <xsl:value-of select="status/version" /><br />
  <xsl:choose>
    <xsl:when test="status/reg/@key='off'">
      <font color="red">UNREGISTERED</font>
    </xsl:when>
    <xsl:otherwise>
      Registered: <xsl:value-of select="status/reg" />
    </xsl:otherwise>
  </xsl:choose>

  <h2>Packets</h2>
  <blockquote>
  <xsl:apply-templates select="status/collector" />
  </blockquote>

  <h2>Interfaces</h2>
  <xsl:apply-templates select="status/interfaces" />
</body>
</xsl:template>

<xsl:template match="status/collector">
  Total Packets: <b><xsl:value-of select="PacketsProcessed"/></b><br />
  Cache Hits: <b><xsl:value-of select="PacketsCacheHits"/></b><br />
  <xsl:if test="memavl">
    Memory Available: <b><xsl:value-of select="memavl"/></b>
  </xsl:if>
</xsl:template>

<xsl:template match="status/interfaces">
  <ul>
  <xsl:for-each select="interface">
    <li style="margin-top: 1em; margin-bottom: 0.5em;">
    <h3><xsl:value-of select="./@type"/> "<xsl:value-of select="name"/>"</h3>
    packets: <xsl:value-of select="pktCount"/><br />
    lost packets: <xsl:value-of select="lostPktCount"/>
    </li>
  </xsl:for-each>
  </ul>
</xsl:template>

</xsl:stylesheet>
