<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8" indent="yes"/>

<xsl:template match="/">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <script language="javascript">
    var runned = true;
    function refresh() { if (runned) document.location.reload(); }
    function click() {
      if (runned) {
        runned = false;
        document.f.b.value = "Run";
      }
      else document.location.reload();
    }
  </script>
  <style>
     tr.sent    { background-color: #F0F0FF; }
     tr.recv    { background-color: #FFF0F0; }
     tr.both    { color: red; }
     td		{ text-align: center; font: normal 9pt sans-serif; }
     td.addr	{ text-align: left; }
     td.len	{ text-align: right; }
     th		{ font: bold 8pt sans-serif; }
     body	{ font: normal 8pt sans-serif; }
     input      { text-align: center; font: normal 8pt sans-serif; width: 5em; }
  </style>
  <body OnLoad="setTimeout('refresh()', 5000);">
    <xsl:apply-templates select="observer" />
  </body>
</head>
</xsl:template>

<xsl:template match="observer">
  <form name="f" action="/" OnSubmit="click(); return false;">
    <input type="submit" name="b" value="Pause" />
    &#xA0;#<xsl:value-of select="./@id"/>&#xA0;<xsl:value-of select="path"/>
  </form>
  <hr style="margin: 3px 0 2px 0;"/>
  <table width="100%">
    <tr>
      <th>Direction</th><th>Protocol</th><th>From</th><th>To</th><th>Length</th>
    </tr>
    <xsl:apply-templates select="packet" />
  </table>
</xsl:template>

<xsl:template match="packet">
  <tr>
    <xsl:attribute name="class"><xsl:value-of select="./@direction"/></xsl:attribute>
    <td>
      <xsl:value-of select="./@direction"/>
    </td>
    <td><xsl:value-of select="proto"/></td>
    <td class="addr"><xsl:value-of select="src"/></td>
    <td class="addr"><xsl:value-of select="dst"/></td>
    <td class="len"><xsl:value-of select="len"/></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
