<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8" indent="yes"/>

<xsl:template match="/">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

  <script language="javascript">
    var win;

    function Observer(id) {
      win = window.open("observer?id="+id+"&#x26;now=1","observer",
        "width=570,height=500,toolbar=no,location=no,directories=no,"+
        "status=no,menubar=no,scrollbars=yes,resizable=yes");
      win.focus();
      return false;
    }
  </script>

  <style type="text/css">
  <!--
  div {
    padding: 0;
    margin: 0;
    font-family: tahoma,helvetica,sans-serif; font-size: 7pt;
  }
  -->
  </style>
</head>
<body>
  <xsl:apply-templates select="filter/rule" />
</body>
</xsl:template>

<xsl:template match="rule">
  <div style="display: block;
              margin-top: 1ex; margin-left: 5ex; padding: 0;
              font-family: sans-serif,helvetica; font-size: 8pt;">
    <span style="background-color: #E7E0F0; padding-left: 0.5em;padding-right: 0.5em;">
      <a href="/">
      <xsl:attribute name="OnClick">return Observer(<xsl:value-of select="./@id"/>);</xsl:attribute>
        <img height="16" width="16" border="0" align="absmiddle">
          <xsl:attribute name="src">img/stop-<xsl:value-of select="@stop"/>.gif</xsl:attribute>
          <xsl:attribute name="alt">stop: <xsl:value-of select="@stop"/></xsl:attribute>
        </img>
        #<xsl:value-of select="./@id"/>&#xA0;<xsl:value-of select="path"/>
      </a>
    </span><br />

    FROM:
    <b>
      <xsl:if test="not(src)">any</xsl:if>
      <xsl:if test="src">
        <xsl:apply-templates select="src" />
      </xsl:if>
    </b><br />
    TO:
    <b>
      <xsl:if test="not(dst)">any</xsl:if>
      <xsl:if test="dst">
        <xsl:apply-templates select="dst" />
      </xsl:if>
    </b><br />
    <xsl:if test="proto">
      <xsl:apply-templates select="proto" /><br />
    </xsl:if>
    <u>sent</u>: <b><xsl:value-of select="sent"/></b> byte(s)
    <u>recv</u>: <b><xsl:value-of select="recv"/></b> byte(s)<br />
    <xsl:if test="lastReset">
      last reset: <xsl:value-of select="lastReset"/>
    </xsl:if>
    <xsl:apply-templates select="rule" />
  </div>
</xsl:template>

<xsl:template match="src">
  <xsl:value-of select="."/>&#xA0;
</xsl:template>

<xsl:template match="dst">
  <xsl:value-of select="."/>&#xA0;
</xsl:template>

<xsl:template match="proto">
  <xsl:value-of select="@name"/> ( <xsl:value-of select="."/> ) 
</xsl:template>

</xsl:stylesheet>
