/*
  Traffic Visor III Utilites  24.10.2006

  "-?" for help
*/

ReqPipeName = '\PIPE\TV3REQ'
Docs = 'reset statistic filter status'
Keys = 'br path sent recv compact'
LF = x2c('0A')

paramStr = strip(arg(1))
reqStr = Low(word(paramStr,1))
docId = wordpos(reqStr,Docs)
if docId = 0 then signal Usage
if docId = 1 then
do
  reqStr = word(Docs,2)
  reqStr = 'DELETE /'reqStr
end
else
  reqStr = 'GET /'reqStr
paramStr = strip(subword(paramStr,2))

if paramStr\='' then
do
  reqStr = reqStr || '?'

  do forever
    key = Low(word(paramStr,1))
    if left(key,1)\='/' then signal Usage
    key = substr(key,2)
    keyId = wordpos(key,Keys)
    if k.keyId = keyId then signal Usage
    k.keyId = keyId
    paramStr = subword(paramStr,2)
    if paramStr = '' then signal Usage

    if keyId > 0 then
      do
        ch = left(paramStr,1)
        if ch = '"' | ch = "'" then
        do
          p = pos(ch,paramStr,2)
          if p = 0 then signal Usage
          valT = strip( substr(paramStr,2,p-2) )
          if valT = '' then signal Usage
          val = ''
          do i = 1 to length(valT)
            ch = substr(valT,i,1)
            if ch = ' ' then ch = '%20'
            else if ch = '"' then ch = '%22'
            else if ch = '&' then ch = '%26'
            else if ch = '?' then ch = '%3F'
            else if ch = '%' then ch = '%%'
            val = val || ch
          end
          paramStr = substr(paramStr,p+1)
        end
        else do
          val = word(paramStr,1)
          paramStr = strip(subword(paramStr,2))
        end

        if keyId = 1 then
          key = 'branch_res'
      end
    else
      signal Usage

    reqStr = reqStr || key || '=' || val
    if paramStr = '' then leave
    reqStr = reqStr || '&'
  end
end

result = SendRequest(reqStr)

do forever
  rpos = pos(LF,result)
  if rpos=0 then
  do
    say result
    leave
  end
  else do
    say left(result,rpos-1)
    result = substr(result,rpos+1) 
  end
end

EXIT


SendRequest: procedure expose ReqPipeName
  rc = stream(ReqPipeName,'C','OPEN')
  Parse value rc with PipeState ':' OS2RC
  if OS2RC\='' then
  do
    say 'Cannot open a pipe'
    exit
  end
  rc = lineout(ReqPipeName,arg(1))
  rc = lineout(ReqPipeName,"")
  result = ''
  do forever
    line = charin(ReqPipeName,,1024)
    if line = '' then leave 
    result = result || line
   end
  rc = stream(ReqPipeName,'C','CLOSE')
return result

Low:
  return translate(arg(1),XRANGE('a','z'),XRANGE('A','Z'))

Usage:
  say "USAGE:"
  say "  read.cmd <filter|status|statistic [CONDITIONS] [/compact Y|N]"
  say "            |reset [CONDITIONS]>"
  say
  say "  filter: read filter"
  say "  status: read state of TrafficVisor III"
  say "  statistic: plain list of rules with paths and sent/recv. statistics,"
  say "    /compact Y - short form of statistics"
  say "  reset: set the statistics fields to 0"
  say
  say "  CONDITIONS: [/br Y|N] [/path ""PATH""] [/sent VALUE] [/recv VALUE]"
  say "    /br Y - include children of successfuly examined with conditions rules"
  say "  PATH: path pattern (you can use ""*"" and ""?"" wildcards)"
  say "  VALUE: [gt|lt]bytes"
  say
  say "EXAMPLE USAGE:";
  say "  read.cmd filter";
  say "  read.cmd status";
  say "  read.cmd statistic /path ""Local net/*"" /sent gt1000000 /recv lt5123520"
  say "  read.cmd statistic /compact Y /br Y /path ""Local net/server N?"""
  say "  read.cmd reset /path Service/IRC/* /recv lt1048576"
  exit
