/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TV3GraphLoad
extends JPanel
implements MouseMotionListener {
    private JLabel info;
    private statItem item;
    private int maxRatio;
    private int[] axisTime;
    private int[] axisRatioSent;
    private int[] axisRatioRecv;
    private int axisTimeScale;
    private int axisTimePointsCnt;
    private int axisRatioSentPointsCnt;
    private int axisRatioRecvPointsCnt;
    private int axisRatioScale;
    private boolean update;
    private Point mousePos;
    private int graphX;
    private int graphY;
    private int graphW;
    private int graphH;

    public TV3GraphLoad(JLabel jLabel) {
        this.info = jLabel;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.black));
        this.mousePos = new Point(-1, -1);
        this.addMouseMotionListener(this);
    }

    public void setStatItem(statItem statItem2) {
        statItem statItem3;
        statItem statItem4 = statItem3 = statItem2.IsRule() ? statItem2 : null;
        if (statItem3 == this.item) {
            return;
        }
        this.item = statItem3;
        this.axisTime = new int[Statistic.graphTimeAxisLen + 2];
        this.axisRatioSent = new int[Statistic.graphTimeAxisLen];
        this.axisRatioRecv = new int[Statistic.graphTimeAxisLen + 2];
        this.statUpdate();
    }

    public void statUpdate() {
        this.maxRatio = this.item == null ? 0 : this.item.getGraphRatio();
        this.update = true;
        this.repaint(0, 0, this.getWidth(), this.getHeight());
        this.mousePointInfo();
    }

    public void paint(Graphics graphics) {
        String string;
        int n;
        int n2;
        super.paint(graphics);
        if (this.item == null) {
            return;
        }
        int n3 = this.getWidth() - 4;
        int n4 = n3;
        if (3 * n4 > 8 * (n2 = (n = this.getHeight() - 8))) {
            n4 = 8 * n2 / 3;
        }
        int n5 = 2 + (n3 - n4) / 2;
        int n6 = 4 + (n - n2) / 2;
        this.graphX = n5;
        this.graphY = n6;
        this.graphW = n4;
        this.graphH = n2;
        graphics.translate(n5, n6);
        if (this.maxRatio != 0) {
            if (this.axisTimeScale != n4 || this.update) {
                this.axisTimeScale = n4;
                this.axisTimePointsCnt = Statistic.calcGraphAxisTime(this.axisTime, n4);
            }
            if (this.axisTimePointsCnt > 0) {
                if (this.axisRatioScale != n2 || this.update) {
                    this.axisRatioScale = n2;
                    this.axisRatioSentPointsCnt = this.item.calcGraphAxisRatio(this.axisRatioSent, n2, this.axisTimePointsCnt, this.maxRatio, true);
                    this.axisRatioRecvPointsCnt = this.item.calcGraphAxisRatio(this.axisRatioRecv, n2, this.axisTimePointsCnt, this.maxRatio, false);
                }
                graphics.setClip(0, 0, n4, n2);
                graphics.setColor(Color.green);
                graphics.fillPolygon(this.axisTime, this.axisRatioRecv, this.axisRatioRecvPointsCnt);
                graphics.setColor(Color.red);
                graphics.drawPolyline(this.axisTime, this.axisRatioSent, this.axisRatioSentPointsCnt);
                graphics.setClip(null);
            }
            this.update = false;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = fontMetrics.getHeight();
        int n8 = fontMetrics.getAscent();
        graphics.setColor(Color.white);
        graphics.setXORMode(new Color(180, 180, 186));
        int n9 = n4 - n4 * Statistic.dataTime / Statistic.timeScale % n7;
        if (n9 > n4) {
            n9 -= n7;
        }
        while (n9 >= 0) {
            graphics.drawLine(n9, 0, n9, n2);
            n9 -= n7;
        }
        n9 = 0;
        while (n9 < n2) {
            graphics.drawLine(0, n9, n4, n9);
            n9 += n7;
        }
        graphics.drawLine(0, n2, n4, n2);
        graphics.setColor(Color.black);
        n9 = 0;
        while (n9 + n8 < n2) {
            string = this.RatioMark(this.maxRatio * (n2 - n9) / n2);
            n3 = fontMetrics.stringWidth(string);
            if (n3 > n5) {
                n3 = n5;
            }
            graphics.drawString(string, -n3, n9 + n8);
            n9 += n7;
        }
        string = this.TimeMark(Statistic.updated);
        n3 = fontMetrics.stringWidth(string);
        n3 = n3 > n5 ? (n3 -= n5) : 0;
        graphics.drawString(string, n4 - n3, n2);
    }

    private String TimeMark(long l) {
        Date date = new Date();
        date.setTime(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private String RatioMark(int n) {
        String string;
        if (n < 10240) {
            string = " b/s";
        } else if (n < 0xA00000) {
            n /= 1024;
            string = " Kb/s";
        } else {
            n /= 0x100000;
            string = " Mb/s";
        }
        return new Integer(n).toString() + string;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mousePos.setLocation(mouseEvent.getPoint());
        this.mousePointInfo();
        mouseEvent.consume();
    }

    private void mousePointInfo() {
        if (this.maxRatio != 0 && this.graphH != 0 && this.graphW != 0) {
            int n = this.graphW - (new Double(this.mousePos.getX()).intValue() - this.graphX);
            int n2 = this.graphH - (new Double(this.mousePos.getY()).intValue() - this.graphY);
            if (n < 0 || n2 < 0 || n > this.graphW || n2 > this.graphH) {
                this.clearInfo();
            } else {
                long l = 1000L * ((long)Statistic.timeScale * (long)n / (long)this.graphW);
                String string = this.TimeMark(Statistic.updated - l);
                this.info.setText(" " + string + "   " + this.RatioMark(this.maxRatio * n2 / this.graphH));
            }
        } else {
            this.clearInfo();
        }
    }

    private void clearInfo() {
        this.info.setText(" ");
    }
}

