/* REXX Script: creating WPS objects for JRescuer */

/* SET "LANG=EN_US" */

call rxFuncAdd "SysLoadFuncs" , "RexxUtil" , "SysLoadFuncs"
call SysLoadFuncs

lang = Value('LANG',,'OS2ENVIRONMENT')
parse var lang language '_' .
language = translate(language)
if pos(language,'EN ES RU DA FR SV DE')=0 then do
  language = 'EN'
  SAY "Your language is not supported. English will be install as default."
  end
/* say language */
lf = d2c(10)
docdir="Documentation" 

select
  when language = 'EN' then do
    foldername="JRescuer"
    homepage = "JRescuer homepage"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = "Registration"
    junereadme = "JUne readme"
    jrescuerreadme = "JRescuer readme"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = ''
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  when language = 'DE' then do
    foldername="JRescuer"
    homepage = "JRescuer homepage"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = "Registration"
    junereadme = "JUne readme"
    jrescuerreadme = "JRescuer readme"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = '\German'
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  when language = 'ES' then do
    foldername="JRescuer"
    homepage = "Pgina de JRescuer"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = "Registro"
    junereadme = "Lame de JUne"
    jrescuerreadme = "Lame de JRescuer"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = '\Spanish'
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  when language = 'RU' then do
    foldername="JRescuer"
    homepage = " ࠭ JRescuer"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = ""
    junereadme = "⠩  JUne"
    jrescuerreadme = "⠩  JRescuer"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = '\Russian'
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  when language = 'DA' then do
    foldername="JRescuer"
    homepage = "JRescuer"lf"hjemmeside"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "St"lf".LONGNAME EA"
    setln2name = "St .LONGNAME EA"lf"P alle JFS drev"
    regname = "Kb"lf"Programmet"lf
    junereadme = "JUne"lf"Info"
    jrescuerreadme = "JRescuer"lf"Info"
    faq = "Ofte Stillede"lf"Sprgsml"
    news = "Nyhedder"
    license = "License"
    InputParameters = "Indtast parametre (ingen for hjlp)"
    Input_for_setln = "Indtast drevbogstavr f.ex C:"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = '\Danish'
    completed = 'Dine ikoner for June og Jrescuer er nu oprettet p Desktoppen'
   end
  when language = 'FR' then do
    foldername="JRescuer"
    homepage = "JRescuer homepage"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = "Registration"
    junereadme = "JUne readme"
    jrescuerreadme = "JRescuer readme"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = '\French'
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  when language = 'SV' then do
    foldername="JRescuer"
    homepage = "JRescuer homepage"
    junename = "JUne"
    jrescuername = "JRescuer"
    setlnname = "Set"lf".LONGNAME EA"
    setln2name = "Set all drives"lf".LONGNAME EA"
    regname = "Registration"
    junereadme = "JUne readme"
    jrescuerreadme = "JRescuer readme"
    faq = "FAQ"
    news = "News"
    license = "License"
    InputParameters = "Enter parameters (none for help)"
    Input_for_setln = "Enter driveletter ex C: (none for help)"
    Input_for_setln2 = "Enter driveletter ex C: (none for help)"
    lang_3 = ''
    completed = 'Your icons for JUne and Jrescuer have now been created on the Desktop'
   end
  otherwise nop
 end

Parse arg dir

if dir="" then dir = directory()
rc=directory(dir)

PRGOPTION="OBJECTID=<JRESCUERFOLDER>;OPEN=Default;ICONVIEWPOS=20 45 60 26;ICONFILE="||dir||"\JRescuer.ico;"
rc=SysCreateObject("WPFolder",foldername,"<WP_DESKTOP>",PRGOPTION,"R" )

PRGOPTION="EXENAME="||dir||"\June.exe;OBJECTID=<JUNE_EXE>;STARTUPDIR="||dir||";"
rc=SysCreateObject("WPProgram",junename,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

PRGOPTION="EXENAME="||dir||"\JRescuer.exe;OBJECTID=<JRESCUER_EXE>;STARTUPDIR="||dir||";PARAMETERS=["InputParameters"];NOAUTOCLOSE=YES;"
rc=SysCreateObject("WPProgram",jrescuername,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

rc=SysCreateObject("WPUrl",homepage,"<JRESCUERFOLDER>",,
                   "OBJECTID=<JRESCUERHOMEPAGE>;URL=http://ecomstation.ru/jrescuer;","REPLACE" )

IF stream(dir||'\'||docdir||lang_3||'\jrescuer.txt','c','query exists') == "" 
  Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\jrescuer.txt;OBJECTID=<JRESCUERREADME>;"
  Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\jrescuer.txt;OBJECTID=<JRESCUERREADME>;"
rc=SysCreateObject("WPProgram",JRescuerreadme,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

IF stream(dir||'\'||docdir||lang_3||'\june.txt','c','query exists') == "" 
 Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\june.txt;OBJECTID=<JUNEREADME>"
 Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\june.txt;OBJECTID=<JUNEREADME>"
rc=SysCreateObject("WPProgram",junereadme,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

IF stream(dir||'\'||docdir||lang_3||'\faq.txt','c','query exists') == "" 
 Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\faq.txt;OBJECTID=<JRESCUERFAQ>"
 Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\faq.txt;OBJECTID=<JRESCUERFAQ>"
rc=SysCreateObject("WPProgram",faq,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

IF stream(dir||'\'||docdir||lang_3||'\registration.txt','c','query exists') == "" 
 Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\registration.txt;OBJECTID=<JRESCUERREGISTRATION>"
 Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\registration.txt;OBJECTID=<JRESCUERREGISTRATION>"
rc=SysCreateObject("WPProgram",regname,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

IF stream(dir||'\'||docdir||lang_3||'\whatsnew.txt','c','query exists') == "" 
 Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\whatsnew;OBJECTID=<JRESCUERNEWS>"
 Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\whatsnew;OBJECTID=<JRESCUERNEWS>"
rc=SysCreateObject("WPProgram",news,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

IF stream(dir||'\'||docdir||lang_3||'\license.txt','c','query exists') == "" 
 Then PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||"\license;OBJECTID=<JRESCUERLICENSE>"
 Else PRGOPTION="EXENAME=E.EXE;PARAMETERS="||dir||"\"||docdir||lang_3||"\license;OBJECTID=<JRESCUERLICENSE>"
rc=SysCreateObject("WPProgram",license,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")
/*
PRGOPTION="EXENAME="||dir||"\setln.cmd;OBJECTID=<SETLN_CMD>;STARTUPDIR="||dir||";PARAMETERS=["Input_for_setln"];NOAUTOCLOSE=YES;ICONFILE="||dir||"\SET.ICO;"
rc=SysCreateObject("WPProgram",setlnname,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

PRGOPTION="EXENAME="||dir||"\setalh.cmd;OBJECTID=<SETLN2_CMD>;STARTUPDIR="||dir||";PARAMETERS=["Input_for_setln2"];NOAUTOCLOSE=YES;ICONFILE="||dir||"\set.ico;"
rc=SysCreateObject("WPProgram",setln2name,"<JRESCUERFOLDER>",PRGOPTION,"REPLACE")

PRGOPTION="EXENAME="||dir||"\Isj.exe;OBJECTID=<ISJ_EXE>;STARTUPDIR="||dir||";PARAMETERS=["InputParameters"]/H;NOAUTOCLOSE=YES;"
rc=SysCreateObject("WPProgram","ISJ","<JRESCUERFOLDER>",PRGOPTION,"REPLACE")
*/

/* Open JRescuer folder */
objectID = "<JRESCUERFOLDER>"
objectOpen = SysSetObjectData( objectID, "OPEN=DEFAULT;" )
if objectOpen = 1 then
    objectOpen = objectOpen + ,
                 SysSetObjectData( objectID, "OPEN=DEFAULT;" )


Say completed
