#define  INCL_DOS
#define  INCL_ERRORS
#include <os2.h>
#include <uconv.h>

#pragma data_seg( "SHAREDDATA", "SHDATA" )
static  int mutex = 0;

extern  int xchg( int* p, int x );
#pragma aux xchg = "xchg [esi],eax" parm [ESI][EAX] value [EAX];

void request( void )
{
  while( xchg( &mutex, 1 ) != 0 ) {
    DosSleep( 1 );
  }
}

void release( void )
{
  xchg( &mutex, 0 );
}

int CALLCONV U32CreateUconvObject( UniChar* code_set,  UconvObject* uobj );
int CALLCONV U32FreeUconvObject  ( UconvObject uobj );

int CALLCONV 
UniCreateUconvObject( UniChar* code_set, UconvObject* uobj )
{
  int rc;

  request();
  rc = U32CreateUconvObject( code_set, uobj );
  release();
  return rc;
}

int CALLCONV
UniFreeUconvObject( UconvObject uobj )
{
  int rc;

  request();
  rc = U32FreeUconvObject( uobj );
  release();
  return rc;
}
