#ifndef INCL_EXIF_H
#define INCL_EXIF_H


/* $Id: exif.h,v 1.3 1999-09-05 17:00:22-04 rl Exp $ */


/*************************************************************************
 *                                                                       *
 * exif.h                                                                *
 * Header file for EXIF specific code or RenamePics                      *
 *                                                                       *
 *************************************************************************/


/* TIFF specifics */

#define ENTRY_LENGTH                       101
#define TOTAL_LENGTH                       10001


/* Data types */

typedef unsigned char Tbyte;
typedef unsigned short Tshort;
typedef unsigned long Tlong;

typedef struct _Texif
  {
  Tshort byteOrder;
  Tshort numIfd;
  Tlong ifdOffset[10];
  Tlong subIfdOffset;
  Tlong makerNoteOffset;
  Tlong makerNoteLength;
  Tlong interoperabilityOffset;
  Tlong jpegOffset;
  Tlong jpegLength;
  Tlong tiffOffset;
  char version [ENTRY_LENGTH+1];
  } Texif;


typedef struct _Tphoto
  {
  char colorSpace [ENTRY_LENGTH+1];                 
  char dateTime [ENTRY_LENGTH+1];
  char dateTimeDigitized [ENTRY_LENGTH+1];
  char dateTimeOriginal [ENTRY_LENGTH+1];
  char exifImageHeight [ENTRY_LENGTH+1];
  char exifImageWidth [ENTRY_LENGTH+1];
  char exposureBiasValue [ENTRY_LENGTH+1];
  char exposureTime [ENTRY_LENGTH+1];
  char exifVersion [ENTRY_LENGTH+1];
  char fNumber [ENTRY_LENGTH+1];
  char flash [ENTRY_LENGTH+1];
  char flashPixVersion [ENTRY_LENGTH+1];
  char focalLength [ENTRY_LENGTH+1];
  char imageDescription [ENTRY_LENGTH+1];
  char isoSpeedRatings [ENTRY_LENGTH+1];
  char lightSource [ENTRY_LENGTH+1];
  char make [ENTRY_LENGTH+1];
  char maxApertureValue [ENTRY_LENGTH+1];
  char meteringMode [ENTRY_LENGTH+1];
  char model [ENTRY_LENGTH+1];
  char resolutionUnit [ENTRY_LENGTH+1];
  char software [ENTRY_LENGTH+1];
  char type [ENTRY_LENGTH+1];
  char xResolution [ENTRY_LENGTH+1];
  char yResolution [ENTRY_LENGTH+1];
  } Tphoto;


/* Tiff internal data types */

typedef unsigned char  TtiffByte;
typedef char           TtiffAscii;
typedef unsigned short TtiffShort;
typedef unsigned int   TtiffLong;
typedef signed char    TtiffSByte;
typedef char           TtiffUndefined;
typedef signed short   TtiffSShort;
typedef signed int     TtiffSLong;
typedef float          TtiffFloat;
typedef double         TtiffDouble;

typedef struct _TtiffRational
  {
  TtiffLong numerator;
  TtiffLong denominator;
  } TtiffRational;

typedef struct _TtiffSRational
  {
  TtiffSLong numerator;
  TtiffSLong denominator;
  } TtiffSRational;

typedef struct _Tapp1
  {
  TtiffShort size;
  } Tapp1;

typedef struct _Tifd
  {
  TtiffShort numEntries;
  } Tifd;

typedef struct _Tentry
  {
  TtiffShort tag;
  TtiffShort type;
  TtiffLong count;
  TtiffLong offset;
  } Tentry;


/* EXIF specifics */

#define EXIF_IdOffset                      6                  /* Offset of 'Exif\0\0' */
#define EXIF_TiffOffset                    12                 /* Start of TIFF within EXIF file */
#define EXIF_NumIfd                        2                  /* EXIF file has IFD 1 and 2 */

#define EXIF_EndOfImage                    ((Tshort)0xffd9)
#define EXIF_StartOfImage                  ((Tshort)0xffd8)
#define EXIF_StartOfStream                 ((Tshort)0xffda)


/* TIFF file specifics */

#define LONG_SIZE                          sizeof(Tlong)       
#define SHORT_SIZE                         sizeof(Tshort)       
#define IFD_ENTRY_SIZE                     ((2 * SHORT_SIZE) + (2 * LONG_SIZE))


/* TIFF specifics */

#define TIFF_LONG_SIZE                     sizeof(TtiffLong)
#define TIFF_SHORT_SIZE                    sizeof(TtiffShort)
#define TIFF_SLONG_SIZE                    sizeof(TtiffSLong)  
#define TIFF_SSHORT_SIZE                   sizeof(TtiffSShort)

#define TIFF_UnkownByteOrder               0
#define TIFF_Intel                         1
#define TIFF_Motorola                      2

#define TIFF_Byte                          ((Tshort)1)
#define TIFF_Ascii                         ((Tshort)2)
#define TIFF_Short                         ((Tshort)3)
#define TIFF_Long                          ((Tshort)4)
#define TIFF_Rational                      ((Tshort)5)
#define TIFF_SByte                         ((Tshort)6)
#define TIFF_Undefined                     ((Tshort)7)
#define TIFF_SShort                        ((Tshort)8)
#define TIFF_SLong                         ((Tshort)9)
#define TIFF_SRational                     ((Tshort)10)
#define TIFF_Float                         ((Tshort)11)
#define TIFF_Double                        ((Tshort)12)

#define TIFF_UNDEFINED                     ((Tshort)0x0)      /* Not any tag, type, or other TIFF structure */

#define TIFF_42                            ((Tshort)0x002a)   /* TIFF file identifier */
#define TIFF_II                            ((Tshort)0x4949)   /* Intel byte order: 76543210 stored as 10325476 */
#define TIFF_MM                            ((Tshort)0x4d4d)   /* Motorola byte order: 76543210 stored as 76543210 */

#define TIFF_App0                          ((Tshort)0xffe0)
#define TIFF_App1                          ((Tshort)0xffe1)
#define TIFF_App2                          ((Tshort)0xffe2)
#define TIFF_App3                          ((Tshort)0xffe3)
#define TIFF_App4                          ((Tshort)0xffe4)
#define TIFF_App5                          ((Tshort)0xffe5)
#define TIFF_App6                          ((Tshort)0xffe6)
#define TIFF_App7                          ((Tshort)0xffe7)
#define TIFF_App8                          ((Tshort)0xffe8)
#define TIFF_App9                          ((Tshort)0xffe9)
#define TIFF_App10                         ((Tshort)0xffea)
#define TIFF_App11                         ((Tshort)0xffeb)
#define TIFF_App12                         ((Tshort)0xffec)
#define TIFF_App13                         ((Tshort)0xffed)
#define TIFF_App14                         ((Tshort)0xffee)
#define TIFF_App15                         ((Tshort)0xffef)

#define TIFF_InteroperabilityTag1          ((Tshort)0x1)
#define TIFF_InteroperabilityTag2          ((Tshort)0x2)
#define TIFF_NewSubfileType                ((Tshort)0xfe)
#define TIFF_SubfileType                   ((Tshort)0xff)
#define TIFF_ImageWidth                    ((Tshort)0x100)
#define TIFF_ImageLength                   ((Tshort)0x101)
#define TIFF_BitsPerSample                 ((Tshort)0x102)
#define TIFF_Compression                   ((Tshort)0x103)
#define TIFF_PhotometricInterpretation     ((Tshort)0x106)
#define TIFF_Thresholding                  ((Tshort)0x107)
#define TIFF_CellWidth                     ((Tshort)0x108)
#define TIFF_CellLength                    ((Tshort)0x109)
#define TIFF_FillOrder                     ((Tshort)0x10a)
#define TIFF_DocumentName                  ((Tshort)0x10d)
#define TIFF_ImageDescription              ((Tshort)0x10e)
#define TIFF_Make                          ((Tshort)0x10f)
#define TIFF_Model                         ((Tshort)0x110)
#define TIFF_StripOffset                   ((Tshort)0x111)
#define TIFF_Orientation                   ((Tshort)0x112)
#define TIFF_SamplesPerPixel               ((Tshort)0x115)
#define TIFF_RowsPerStrip                  ((Tshort)0x116)
#define TIFF_StripByteCounts               ((Tshort)0x117)
#define TIFF_MinSampleValue                ((Tshort)0x118)
#define TIFF_MaxSampleValue                ((Tshort)0x119)
#define TIFF_XResolution                   ((Tshort)0x11a)
#define TIFF_YResolution                   ((Tshort)0x11b)
#define TIFF_PlanarConfiguration           ((Tshort)0x11c)
#define TIFF_PageName                      ((Tshort)0x11d)
#define TIFF_XPosition                     ((Tshort)0x11e)
#define TIFF_YPosition                     ((Tshort)0x11f)
#define TIFF_FreeOffsets                   ((Tshort)0x120)
#define TIFF_FreeByteCounts                ((Tshort)0x121)
#define TIFF_GrayResponseUnit              ((Tshort)0x122)
#define TIFF_GrayResponseCurve             ((Tshort)0x123)
#define TIFF_T4Options                     ((Tshort)0x124)
#define TIFF_T6Options                     ((Tshort)0x125)
#define TIFF_ResolutionUnit                ((Tshort)0x128)
#define TIFF_PageNumber                    ((Tshort)0x129)
#define TIFF_TransferFunction              ((Tshort)0x12d)
#define TIFF_Software                      ((Tshort)0x131)
#define TIFF_DateTime                      ((Tshort)0x132)
#define TIFF_Artist                        ((Tshort)0x13b)
#define TIFF_HostComputer                  ((Tshort)0x13c)
#define TIFF_Predictor                     ((Tshort)0x13d)
#define TIFF_WhitePoint                    ((Tshort)0x13e)
#define TIFF_PrimaryChromaticities         ((Tshort)0x13f)
#define TIFF_ColorMap                      ((Tshort)0x140)
#define TIFF_HalftoneHints                 ((Tshort)0x141)
#define TIFF_TileWidth                     ((Tshort)0x142)
#define TIFF_TileLength                    ((Tshort)0x143)
#define TIFF_TileOffsets                   ((Tshort)0x144)
#define TIFF_TileByteCounts                ((Tshort)0x145)
#define TIFF_InkSet                        ((Tshort)0x14c)
#define TIFF_InkNames                      ((Tshort)0x14d)
#define TIFF_NumberOfInks                  ((Tshort)0x14e)
#define TIFF_DotRange                      ((Tshort)0x150)
#define TIFF_TargetPrinter                 ((Tshort)0x151)
#define TIFF_ExtraSamples                  ((Tshort)0x152)
#define TIFF_SampleFormat                  ((Tshort)0x153)
#define TIFF_SMinSampleValue               ((Tshort)0x154)
#define TIFF_SMaxSampleValue               ((Tshort)0x155)
#define TIFF_TransferRange                 ((Tshort)0x156)
#define TIFF_JpegTables                    ((Tshort)0x15b)
#define TIFF_JpegProc                      ((Tshort)0x200)
#define TIFF_JpegInterchangeFormat         ((Tshort)0x201)
#define TIFF_JpegInterchangeFormatLength   ((Tshort)0x202)
#define TIFF_JpegRestartInterval           ((Tshort)0x203)
#define TIFF_JpegLosslessPredictors        ((Tshort)0x205)
#define TIFF_JpegPointTransforms           ((Tshort)0x206)
#define TIFF_JpegQTables                   ((Tshort)0x207)
#define TIFF_JpegDcTables                  ((Tshort)0x208)
#define TIFF_JpegAcTables                  ((Tshort)0x209)
#define TIFF_YCbCrCoefficients             ((Tshort)0x211)
#define TIFF_YCbCrSubSampling              ((Tshort)0x212)
#define TIFF_YCbCrPositioning              ((Tshort)0x213)
#define TIFF_ReferenceBlackWhite           ((Tshort)0x214)
#define TIFF_CfaRepeatPatternDim           ((Tshort)0x828d)
#define TIFF_CfaPattern                    ((Tshort)0x828e)
#define TIFF_BatteryLevel                  ((Tshort)0x828f)
#define TIFF_Copyright                     ((Tshort)0x8298)
#define TIFF_ExposureTime                  ((Tshort)0x829a)
#define TIFF_FNumber                       ((Tshort)0x829d)
#define TIFF_IptcNaa                       ((Tshort)0x83bb)
#define TIFF_ExifSubIfdOffset              ((Tshort)0x8769)   /* Offset to EXIF SubIFD */
#define TIFF_InterColorProfile             ((Tshort)0x8773)
#define TIFF_ExposureProgram               ((Tshort)0x8822)
#define TIFF_SpectralSensitivity           ((Tshort)0x8824)
#define TIFF_GpsInfo                       ((Tshort)0x8825)
#define TIFF_IsoSpeedRatings               ((Tshort)0x8827)
#define TIFF_Oecf                          ((Tshort)0x8828)
#define TIFF_Interlace                     ((Tshort)0x8829)
#define TIFF_TimeZoneOffset                ((Tshort)0x882a)
#define TIFF_SelfTimerMode                 ((Tshort)0x882b)
#define TIFF_ExifVersion                   ((Tshort)0x9000)
#define TIFF_DateTimeOriginal              ((Tshort)0x9003)
#define TIFF_DateTimeDigitized             ((Tshort)0x9004)
#define TIFF_ComponentConfiguration        ((Tshort)0x9101)
#define TIFF_CompressedBitsPerLevel        ((Tshort)0x9102)   /* CompressedBitsPerPixel */
#define TIFF_ShutterSpeedValue             ((Tshort)0x9201)
#define TIFF_ApertureValue                 ((Tshort)0x9202)
#define TIFF_BrightnessValue               ((Tshort)0x9203)
#define TIFF_ExposureBiasValue             ((Tshort)0x9204)
#define TIFF_MaxApertureValue              ((Tshort)0x9205)
#define TIFF_SubjectDistance               ((Tshort)0x9206)
#define TIFF_MeteringMode                  ((Tshort)0x9207)
#define TIFF_LightSource                   ((Tshort)0x9208)
#define TIFF_Flash                         ((Tshort)0x9209)
#define TIFF_FocalLength                   ((Tshort)0x920a)
#define TIFF_FlashEnergy                   ((Tshort)0x920b)
#define TIFF_SpatialFrequencyResponse      ((Tshort)0x920c)
#define TIFF_Noise                         ((Tshort)0x920d)
#define TIFF_ImageNumber                   ((Tshort)0x9211)
#define TIFF_SecurityClassification        ((Tshort)0x9212)
#define TIFF_ImageHistory                  ((Tshort)0x9213)
#define TIFF_SubjectLocation               ((Tshort)0x9214)
#define TIFF_ExposureIndex                 ((Tshort)0x9215)
#define TIFF_TiffEpStandardId              ((Tshort)0x9216)
#define TIFF_MakerNote                     ((Tshort)0x927c)
#define TIFF_UserComment                   ((Tshort)0x9286)
#define TIFF_SubSecTime                    ((Tshort)0x9290)
#define TIFF_SubSecTimeOriginal            ((Tshort)0x9291)
#define TIFF_SubSecTimeDigitized           ((Tshort)0x9292)
#define TIFF_FlashPixVersion               ((Tshort)0xa000)
#define TIFF_ColorSpace                    ((Tshort)0xa001)
#define TIFF_ExifImageWidth                ((Tshort)0xa002)
#define TIFF_ExifImageHeight               ((Tshort)0xa003)
#define TIFF_RelatedSoundFile              ((Tshort)0xa004)
#define TIFF_ExifInteroperabilityOffset    ((Tshort)0xa005)
/*
#define TIFF_FlashEnergy                   ((Tshort)0xa20b)
#define TIFF_SpatialFrequencyResponse      ((Tshort)0xa20c)
*/
#define TIFF_FocalPlaneXResolution         ((Tshort)0xa20e)
#define TIFF_FocalPlaneYResolution         ((Tshort)0xa20f)
#define TIFF_FocalPlaneResolutionUnit      ((Tshort)0xa210)
/*
#define TIFF_SubjectLocation               ((Tshort)0xa214)
#define TIFF_ExposureIndex                 ((Tshort)0xa215)
*/
#define TIFF_SensingMethod                 ((Tshort)0xa217)
#define TIFF_FileSource                    ((Tshort)0xa300)
#define TIFF_SceneType                     ((Tshort)0xa301)
/*
#define TIFF_CfaPattern                    ((Tshort)0xa302)
*/


/* Functions */

void dumpEntries ( Tbyte* start, Tbyte* firstentry, Tlong entries, Texif* exif );
int getOrder ( Tbyte* start );
int isExif ( Tbyte* start );

int dumpExif ( char* oldName, Tbyte* start, Tbyte* end );
int exifPhoto ( FILE* file, char* oldName, Tbyte* start, Tbyte* end );

char*       getTiffAscii         ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* string );
TtiffLong*  getTiffLong          ( int byteOrder, Tbyte* tiff, Tbyte* entry, Tlong* count, TtiffLong* val );
char*       getTiffRational      ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* string );
char*       getTiffRational2     ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* string );
TtiffShort* getTiffShort         ( int byteOrder, Tbyte* tiff, Tbyte* entry, Tlong* count, TtiffShort* val );
char*       getTiffSRational     ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* string );
char*       getTiffUndefined     ( int byteOrder, Tbyte* tiff, Tbyte* entry, Tlong* count, char* string );
char*       getTiffUnknownFormat ( int byteOrder, Tbyte* tiff, Tbyte* entry, Tlong* count, char* string );

Tlong       getLong    ( Tbyte* p, int byteOrder );
Tshort      getShort   ( Tbyte* p, int byteOrder );
TtiffLong   tifflong   ( Tbyte* p, int byteOrder );
TtiffShort  tiffShort  ( Tbyte* p, int byteOrder );
TtiffSLong  tiffSLong  ( Tbyte* p, int byteOrder );
TtiffSShort tiffSShort ( Tbyte* p, int byteOrder );

char* getApertureValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getArtist ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getBatteryLevel ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getBitsPerSample ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getBrightnessValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getCellLength ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getCellWidth ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getCfaPattern ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getCfaRepeatPatternDim ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getColorMap ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getColorSpace ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* color );
char* getComponentConfiguration ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* config );
char* getCompressedBitsPerLevel ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* compressed );
char* getCompression ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* compression );
char* getCopyright ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getDateTime ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* dateTime );
char* getDateTimeDigitized ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* dateTime );
char* getDateTimeOriginal ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* dateTime );
char* getDocumentName ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getDotRange ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getExifImageHeight ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* height );
char* getExifImageWidth ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* width );
char* getExifVersion ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* version );
char* getExposureBiasValue ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* bias );
char* getExposureIndex ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getExposureProgram ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* prog );
char* getExposureTime ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* time );
char* getExtraSamples ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getFNumber ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* fstop );
char* getFileSource ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* source );
char* getFillOrder ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getFlash ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* flash );
char* getFlashEnergy ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getFlashPixVersion ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* version );
char* getFocalLength ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* length );
char* getFocalPlaneResolutionUnit ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* unit );
char* getFocalPlaneXResolution ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* resolution );
char* getFocalPlaneYResolution ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* resolution );
char* getFreeByteCounts ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getFreeOffsets ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getGpsInfo ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getGrayResponseCurve ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getGrayResponseUnit ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getHalftoneHints ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getHostComputer ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getImageDescription ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* description );
char* getImageHistory ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getImageLength ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getImageNumber ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getImageWidth ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getInkNames ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getInkSet ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getInterColorProfile ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getInterlace ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getInteroperabilityTag1 ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* value );
char* getInteroperabilityTag2 ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* value );
char* getIptcNaa ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getIsoSpeedRatings ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* iso );
char* getJpegAcTables ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegDcTables ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegLosslessPredictors ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegPointTransforms ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegProc ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegQTables ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegRestartInterval ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getJpegTables ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getLightSource ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* balance );
char* getMake ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* make );
char* getMaxApertureValue ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* aperture );
char* getMaxSampleValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getMeteringMode ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* mode );
char* getMinSampleValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getModel ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* model );
char* getNewSubfileType ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getNoise ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getNumberOfInks ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getOecf ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getOrientation ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* orientation );
char* getPageName ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getPageNumber ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getPhotometricInterpretation ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getPlanarConfiguration ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getPredictor ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getPrimaryChromaticities ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getReferenceBlackWhite ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getRelatedSoundFile ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getResolutionUnit ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* unit );
char* getRowsPerStrip ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSMaxSampleValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSMinSampleValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSampleFormat ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSamplesPerPixel ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSceneType ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* type );
char* getSecurityClassification ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSelfTimerMode ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSensingMethod ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getShutterSpeedValue ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSoftware ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* software );
char* getSpatialFrequencyResponse ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSpectralSensitivity ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getStripByteCounts ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getStripOffset ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubSecTime ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubSecTimeDigitized ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubSecTimeOriginal ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubfileType ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubjectDistance ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getSubjectLocation ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getT4Options ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getT6Options ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTargetPrinter ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getThresholding ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTiffEpStandardId ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTileByteCounts ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTileLength ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTileOffsets ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTileWidth ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTimeZoneOffset ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTransferFunction ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getTransferRange ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getUserComment ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* comment );
char* getWhitePoint ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getXPosition ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getXResolution ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* resolution );
char* getYCbCrCoefficients ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getYCbCrPositioning ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* position );
char* getYCbCrSubSampling ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getYPosition ( int byteOrder, Tbyte* tiff, Tbyte* entry );
char* getYResolution ( int byteOrder, Tbyte* tiff, Tbyte* entry, char* resolution );


#endif

