/* ͻ */
/*     !!! DO NOT MODIFY THIS FILE UNDER ANY CIRCUMSTANCES !!!   */
/* ͼ */
/* Ŀ */
/*                 Adding WINOS2 Audio Support                   */
/* Ĵ */
/*                                                               */
/*  This REXX program installs the WIN-OS2 audio support         */
/*  for the following current OS/2-supported audio adapters:     */
/*                                                               */
/*         -   The IBM M-Audio Adapter                           */
/*         -   The Sound Blaster Non-Pro ISA or MCV Adapter      */
/*         -   The Sound Blaster Pro OPL2 Adapter                */
/*         -   The Sound Blaster Pro MCV or OPL3 Adapter         */
/*         -   The Sound Blaster 16 / PnP                        */
/*         -   The Pro Audio Spectrum 16                         */
/*         -   The Media Vision Jazz 16 Adapter                  */
/*         -   The Aztech Sound Galaxy NOVA 16 EXTRA             */
/*         -   The Aztech Sound Galaxy Wave 32 +                 */
/*         -   The ESS-688 Audio Adapter                         */
/*         -   The ESS-1688 Audio Adapter                        */
/*         -   The ESS-1788 Audio Adapter                        */
/*         -   The ESS-1868 Audio Adapter                        */
/*         -   The ESS-1888 Audio Adapter                        */
/*         -   The Sound Blaster AME 32 Adapter / PnP            */
/*         -   The Crystal Semi CS4231 Adapter                   */
/*         -   The Crystal Semi CS4232/4236 PnP Adapter          */
/*         -   The IBM Thinkpad Audio - Crystal Semi 4231        */
/*                                                               */
/*  Usage:                                                       */
/*         At an OS/2 prompt, type:                              */
/*                                                               */
/*             WINSTALL                                          */
/*                                                               */
/*                                                               */
/*  (C) Copyright International Business Machines Corp.  1996    */
/*  */

'@echo off'
trace 'o'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls
say
say '  ͻ'
say '                                                               '
say '      Updating WIN-OS2 system files now.  Please wait ...      '
say '                                                               '
say '  ͼ'


/*******************************************************************/
/*                                                                 */
/*   Get the BOOTDRIVE of OS/2 using environment variable PATH     */
/*   All files to be modified will be on this BOOTDRIVE            */
/*                                                                 */
/*******************************************************************/

BootDrvSpec = SysSearchPath('PATH', 'CMD.EXE')
OSDrvCheck  = SysSearchPath('PATH', 'OS2KRNL')
if (BootDrvSpec = '') then
        call NON_OS2_PARTITION_ERROR
if (OSDrvCheck = '') then
        call NON_OS2_PARTITION_ERROR

              /* if reached here, boot drive is an OS/2 partition */
BootDrv = left(OSDrvCheck, 2)

/*******************************************************************/
/*                                                                 */
/*   Check whether WINOS2 is installed; if yes, is SYSTEM.INI file */
/*   there?  This file is essential for WINOS2 audio to work       */
/*                                                                 */
/*******************************************************************/

WinOS2Check = SysSearchPath('PATH', 'SYSTEM.INI')
if (WinOS2Check = '') then
do
        call SysFileTree BootDrv||'\OS2\MDOS\WINOS2\SYSTEM.INI', ini_check, 'F'
        if ini_check.0 = 0 then
                call NO_WINOS2_INSTALLED_ERROR
end

/*******************************************************************/
/*                                                                 */
/*   "Auto-detect' the WinOS2 audio driver by looking in the       */
/*   \OS2\DRIVERS directory;                                       */
/*                                                                 */
/*       . if more than one driver found, we will install the      */
/*         default audio device currently set in MMPM2.INI;        */
/*       . if none found, exit with error message;                 */
/*       . if one found, go ahead install it;                      */
/*                                                                 */
/*******************************************************************/

DefaultFound = 0
WinDriverList = BootDrv||'\OS2\DRIVERS\*.'
call SysFileTree WinDriverList, WinDrivers, 'OD'

            /* if no Windows driver found, exit with error message */

if WinDrivers.0 = 0 then
        call NO_WIN_DRIVERS_ERROR

WinDriver = WinDrivers.1


            /* if more than one driver found, install the          */
            /* OS2-default audio device found in MMPM2.INI         */


if WinDrivers.0 > 1 then             /* more than one device found */
do
  do i=1 to WinDrivers.0
  arg WinDriverDir

/* Added to avoid non-drivers directories to prevent install */
	  /* is the .ctl file there? */
	  parse value WinDriverDir with '\OS2\DRIVERS\' WinDriver
	  call SysFileTree WinDriverDir||'\'||WinDriver||'.CTL', control_file, 'FS'
	  if  control_file.0 = 0  then 
		do
			i=i+1
			if 1>WinDrivers.0 then i=i-1
		end

        call IsDefault WinDrivers.i
        if result = 1 then
          do
                WinDriver = WinDrivers.i
                i = WinDrivers.0 + 1    /* done do loop */
                DefaultFound = 1
          end
  end


  if (DefaultFound <> 1) then           /* no OS2 audio installed           */
    do                                  /* but WINOS2 audio will still work */
                                        /* list the choices to user         */
        say
        say '     Ŀ'
        say '                                                                  '
        say '         No corresponding OS/2 audio driver detected on your      '
        say '         system; you can however still install WINOS2 driver.     '
        say '                                                                  '
        say '         Please select one audio device from the following list:  '
        say '                                                                  '
        say '     '
        say
        do k = 1 to WinDrivers.0
                parse value WinDrivers.k with '\OS2\DRIVERS\' WinDriver_o
                say '            Device ' k '= ' WinDriver_o
        end
        say
        say '           Select a device by typing in the number:'
        pull n
        do while ((n > WinDrivers.0) | (n < 1))
                say '          Select a valid number listed:'
                pull n
        end
        WinDriver = WinDrivers.n
    end
end /* if WinDrivers.0 */


/*******************************************************************/
/*                                                                 */
/*    If only one audio device found, fall through here ...        */
/*    At this point, we got WinDriver, which is also the name of   */
/*    the .ctl file; for example, WinDriver = es1688dd, then we    */
/*    expect a file es1688dd.ctl in the \OS2\DRIVERS\ES1688DD dir  */
/*                                                                 */
/*    We also know:                                                */
/*                                                                 */
/*      .  the .ctl file exists;                                   */
/*      .  it is a valid file for this audio device;               */
/*      .  source directory where to copy the WIN-OS2 drivers from */
/*      .  Boot drive: BootDrv                                     */
/*                                                                 */
/*    Start parsing the .ctl file here; error handling done here   */
/*                                                                 */
/*******************************************************************/

                                   /* Get all the global variables */


parse value WinDriver with '\OS2\DRIVERS\' win_driver

/* Create adequate SBWIN.INI file */
if right(WinDriver, 7) = 'SBAWED2' then
	do
	arg temp
	arg rc
	temp = WinDriver'\SBWIN.INI'
	rc = lineout(temp,'',1) 
	rc = lineout(temp,'[awe32]') 
	rc = lineout(temp,'gm='WinDriver'\synthgm.sbk')
	rc = lineout(temp,'gs='WinDriver'\synthgs.sbk')
	rc = lineout(temp,'mt='WinDriver'\synthmt.sbk')
	rc = lineout(temp,'')
	rc = lineout(temp)
	end

control_file = WinDriver||'\'||win_driver||'.ctl'
call SysFileTree control_file, ctl_check, 'F'
if ctl_check.0 = 0 then
        call FILE_NOT_EXISTENT_OUTPUT control_file

/* say 'copying control file ' control_file */
copy control_file WinDriver||'\'||win_driver||'.JUK'
control_file2 = WinDriver||'\'||win_driver||'.JUK'      /* for a subroutine                 */
TargetDir     = BootDrv||'\OS2\MDOS\WINOS2\SYSTEM\'     /* official place to put the driver */
IniFileDir    = BootDrv||'\OS2\MDOS\WINOS2\'            /* where system.ini is              */
copy IniFileDir||'system.ini' IniFileDir||'system.org > NUL' /* back up system.ini          */
copy IniFileDir||'system.ini' IniFileDir||'system.bak > NUL' /* back up system.ini          */
copy IniFileDir||'system.ini' IniFileDir||'system.juk > NUL' /* temp system.ini for source  */

/*******************************************************************/
/*                                                                 */
/*   From the .ctl file, get the names of driver files to be       */
/*   copied and copy them from the source directory to the target  */
/*   directory; exit if any of those files do not exist; WINOS2    */
/*   audio will not work if these files are missing                */
/*                                                                 */
/*******************************************************************/

                    /* Get [COPIED_FILES] section in the .ctl file */

call SysFileSearch '[COPIED_FILES]', control_file, 'DrvFiles.', 'N'
if DrvFiles.0 = 0 then
        call CONTROL_FILE_ERROR_OUTPUT control_file
else
        parse value DrvFiles.1 with startline ' '

do startline
        line = linein(control_file)     /* brings to the first line  */
                                        /* of [COPIED_FILES] section */
end
line = linein(control_file)
parse value line with '"' NumFiles '"'  /* parse out number of files */

do i = 1 to NumFiles                    /* parse out the files and   */
        line = linein(control_file)     /* copy them; check errors   */
        parse value line with '"' DriverFile '"' '"' CopyToDir '"'
        call SysFileTree WinDriver||'\'||DriverFile, 'check', 'FSO'     /* 'FSO' works best  */
        if (check.0 = 0) then                                           /* with copy command */
                call FILE_NOT_EXISTENT_OUTPUT DriverFile
        copy check.1 BootDrv||CopyToDir' > NUL'
end


/*******************************************************************/
/*                                                                 */
/*   Get [MODIFY] section and start modifying the .INI file(s)     */
/*   under the \OS2\MDOS\WINOS2 directory                          */
/*                                                                 */
/*******************************************************************/

call lineout(control_file)         /* close it to reset all values */
call SysFileSearch '[MODIFY]', control_file, 'Modify.', 'N'
if Modify.0 = 0 then
        call CONTROL_FILE_ERROR_OUTPUT control_file
else
        parse value Modify.1 with startline ' '

do startline
        line = linein(control_file)     /* brings to the first line  */
                                        /* of that section           */
end
line = linein(control_file)
parse value line with '"' num_files_modify '"'


/*******************************************************************/
/*                                                                 */
/*    The following section contains nested loops.  The basic      */
/*    structure is as follows:                                     */
/*                                                                 */
/*    Number of FILES to be modified                               */
/*      Number of SECTIONS in each FILE to be modified/created     */
/*        Number of LINES in each SECTION to be added              */
/*        end                                                      */
/*      end                                                        */
/*    end                                                          */
/*                                                                 */
/*******************************************************************/

do nth =1 to num_files_modify

     /* need to go to the line describing how to modify 'nth' file */
  cur_file = 0
  call lineout(control_file)        /* close it if opened to reset */
  do while cur_file <> nth
        line = linein(control_file)
        parse value line with '"' NumSections '"' '"' file_path '"' '"' file_name '"' '"<FILE' cur_file '>"'

  end
  /*
        say 'File #' cur_file 'Numsections = ' NumSections
        say 'File #' cur_file 'Filepath    = ' BootDrv||file_path
        say 'File #' cur_file 'FileName    = ' file_name
  */
                               /* make a backup of this file first */
  say
  say ' Backing up file: ' file_name ' ...'
  parse value file_name with prefix '.' junk
  copy BootDrv||file_path||'\'||file_name BootDrv||file_path||'\'||prefix||'.org > NUL'
  copy BootDrv||file_path||'\'||file_name BootDrv||file_path||'\'||prefix||'.juk > NUL'


  /******************************************************/
  /*   Modify the sections now in file gotten above     */
  /******************************************************/

  original_file = BootDrv||file_path||'\'||prefix||'.juk'
  modified_file = BootDrv||file_path||'\'||file_name

  do i = 1 to NumSections                    /* parse out the lines which  */
        Current = 0                          /* to put in the system.ini   */
        current_file = 0
        call lineout modified_file,,1        /* open; set at 1             */
        do while (Current <> i & current_file <> nth)     /* Skip non-related lines */
                line = linein(control_file)
                parse value line with '"' Current '"' '"[' SectionName ']"' '"<FILE' current_file '>"'
        end
        line = linein(control_file)
        parse value line with '"' NumLines '"'
        call SysFileSearch '['SectionName']', original_file, 'iniSection.', 'N'
        if iniSection.0 = 0 then
          do
                call lineout(modified_file)
                insertThis = ' '
                call lineout modified_file, insertThis
                insertThis = '['SectionName']'
                call lineout modified_file, insertThis
                do while (lines(original_file) <> 0)
                   junk = linein(original_file)
                end          /* force to be at the end of ini file */
                             /* New section will be added at end   */
          end
        else
          do
                parse value iniSection.1 with startline ' '
                do startline                            /* write from beginning to */
                    iniLine = Linein(original_file)     /* insertion point         */
                    call lineout modified_file, iniLine
                end
          end
        do j = 1 to NumLines            /* ready to insert additional lines */
                line = linein(control_file)
                parse value line with '"' insertThis '"'

                /* check if this line needs value parsed from config.sys */
                /* The .ctl file tells which parameter to parse          */

                parse value insertThis with junk '=' test_param
                if (left(test_param, 1) = '*') then     /* need setting from config.sys */
                  do
                        /* get default value now */
                        parse value line with '"' replace_line '"' '"' default_val '"'
                        parse value replace_line with left_part '=*' param_name '*'
                        new_value = default_val
                        call GetOS2ParamValue control_file2||'=='||param_name        /* result will have the value */
                        if (result = -1) then   /* nothing found in config.sys */
                                nop             /* do nothing, so use default  */
                        else
                                new_value = result
                        insertThis = left_part||'='||new_value
                  end
                call lineout modified_file, insertThis
        end

        do while (lines(original_file) <> 0)       /* finish writing the rest section */
                iniLine = linein(original_file)
                call lineout modified_file, iniLine
        end

        call lineout(modified_file)    /* closes files so sys calls */
        call lineout(original_file)    /* can re-new values         */
        copy modified_file BootDrv||file_path||'\'||prefix||'.juk > NUL' /* back up file modified so far */
  end

  /* cleaning up .juk files */
  call SysFileDelete original_file
  backed_up = BootDrv||file_path||'\'||prefix||'.org'
  say
/*  say '  File 'original_file' is updated successfully.' */
  say '  File 'file_name' is updated successfully.'
  say '  Original version is backed up to 'backed_up'.'
  say

end /* of do loop for number of files */

/*******************************************************************/
/*                                                                 */
/*   Get [WINOS2_SETTINGS] section and start modifying WINOS2      */
/*   settings.                                                     */
/*                                                                 */
/*******************************************************************/

call lineout(control_file)         /* close it to reset all values */
call SysFileSearch '[WINOS2_SETTINGS]', control_file, 'winos2.', 'N'
if winos2.0 = 0 then
        call CONTROL_FILE_ERROR_OUTPUT control_file
else
        parse value winos2.1 with startline ' '

do startline
        line = linein(control_file)     /* brings to the first line  */
                                        /* of that section           */
end
line = linein(control_file)
parse value line with '"' num_settings_modify '"'
do j=1 to num_settings_modify
        line = linein(control_file)     /* get one setting each time */
        parse value line with '"' current_setting '"'
        call UPDATE_WIN_OS2_SETTINGS current_setting
end



/*******************************************************************/
/*                                                                 */
/*   Get [SPECIAL_SETTINGS] section and start modifying WINOS2 or  */
/*   DOS_DEVICE settings in which values may need to be parsed from*/
/*   OS/2's config.sys file.                                       */
/*                                                                 */
/*******************************************************************/

call lineout(control_file)         /* close it to reset all values */
call SysFileSearch '[SPECIAL_SETTINGS]', control_file, 'special.', 'N'
if special.0 = 0 then
        nop             /* if this section does not exist, do nothing */
else
  do
        parse value special.1 with startline ' '

        do startline
            line = linein(control_file)     /* brings to the first line  */
                                            /* of that section           */
        end
        line = linein(control_file)
        parse value line with '"' num_special_modify '"'
        do j=1 to num_special_modify
          line = linein(control_file)     /* get one setting each time */

          /* start reconstructing a new line with parsed values */
          parse value line with '"' num_parsed '"' '"' String '"'
          leftover = String
          new_string = ''
          do i=1 to num_parsed
            parse value leftover with prefix '*' var_name '*' '<' default '>' leftover
            /* get default value now */
            var_value = default
            if compare(var_name, 'BOOTDRV') = 0 then    /* special case */
                var_value = BootDrv
            else
              do
                call GetOS2ParamValue control_file2||'=='||var_name        /* result will have the value */
                if (result = -1) then   /* nothing found in config.sys */
                        nop             /* do nothing, so use default  */
                else
                        var_value = result
              end /* else */

            /* keep appending finished values -- reconstructing String */
            new_string = new_string||prefix||var_value
          end /* do i=1 */
          new_string = new_string||leftover     /* get trailing stuff */
          call UPDATE_WIN_OS2_SETTINGS new_string
        end /* num_special_modify */
  end /* else */


/*******************************************************************/
/*                                                                 */
/*   Cleaning up ...                                               */
/*                                                                 */
/*******************************************************************/

call SysFileDelete control_file2
say
say '  ͻ'
say '                                                               '
say '      WINOS2 Audio is updated successfully.                    '
say '      To get WINOS2 sound, switch to a WIN-OS2 Session now.    '
say '                                                               '
say '  ͼ'
say
exit



/*******************************************************************/
/*                                                                 */
/*   Procedures called by the main program above                   */
/*                                                                 */
/*******************************************************************/

CONTROL_FILE_ERROR_OUTPUT: PROCEDURE
do
        arg control_file
        say
        say 'Error: file 'control_file' contains invalid formats;'
        say '       Install cannot proceed without a valid control file.'
        exit
end

FILE_NOT_EXISTENT_OUTPUT: procedure
do
        arg FileName
        say
        say 'Error: file 'FileName' does not exist on your system;'
        say '       In order to install WIN-OS2 audio, you must have'
        say '       this file.'
        say
        say 'Suggestion: Use Selective Install to install the corresponding'
        say '            OS/2 driver for your audio device.'
        say
        exit
end

UPDATE_WIN_OS2_SETTINGS: PROCEDURE
do
        arg new_setting
        /* say '::UPDATE_WIN_OS2..., param passed in is ' new_setting */
        call SysSetObjectData '<WP_WINFS>',   new_setting
        call SysSetObjectData '<WP_WIN2WIN>', new_setting
        return
end

NON_OS2_PARTITION_ERROR: PROCEDURE
do
        say
        say 'ERROR: Either OS/2 is not running, or this program is not running'
        say 'from an OS/2 Window.  Please run this command from an OS/2 window.'
        say
        exit
end

NO_WINOS2_INSTALLED_ERROR: PROCEDURE
do
        say
        say 'ERROR: WIN-OS2 is not installed in your system.'
        say 'If you have WARP Full Pack, use Selective Install to'
        say 'install WIN-OS2.  Then, try this program.'
        say
        exit
end

NO_WIN_DRIVERS_ERROR: PROCEDURE
do
        say
        say 'Error: No valid drivers found under \OS2\DRIVERS directory;'
        say '       In order to install WIN-OS2 audio, you must have'
        say '       driver files which reside under a particular diectory.'
        say
        say 'Suggestion: Use Selective Install to install the corresponding'
        say '            OS/2 driver for your audio device.'
        say
        exit
end


/*******************************************************************/
/*                                                                 */
/*   PROCEDURE: IsDefault                                          */
/*                                                                 */
/*              Check to see if driver name passed in is a default */
/*              OS/2 device; we need the settings such as port     */
/*              address, interrupt level, etc. from the OS/2 driver*/
/*              if it is default, then return 1 (true); if not,    */
/*              return 0 (false).                                  */
/*                                                                 */
/*   Input    : Driver name.  For example, ES1688DD.SYS            */
/*   Output   : 1 if yes; 0 if no                                  */
/*                                                                 */
/*******************************************************************/

IsDefault: PROCEDURE
do
        arg DriverPathName
        call CheckControlFile DriverPathName     /* if exists, return; otherwise, exit */
        BootDrv = left(DriverPathName, 2)
        parse value DriverPathName with '\OS2\DRIVERS\' control_file
        control_file = DriverPathName||'\'||control_file||'.CTL'

        call SysFileTree control_file, ctl_check, 'F'
        if ctl_check.0 = 0 then
                call FILE_NOT_EXISTENT_OUTPUT

        call SysFileSearch '[PDD_INFO]', control_file, 'params.', 'N'
        if DrvFiles.0 = 0 then
                call CONTROL_FILE_ERROR_OUTPUT
        else
                parse value params.1 with startline ' '

        /* say '::IsDefault, startline for [PDD_INFO] = ' startline */
        do startline
                line = linein(control_file)     /* brings to the first line  */
                                                /* of [PDD_INFO] section */
        end
        line = linein(control_file)
        parse upper value line with '"' pdd_name '"'
        /* say '::IsDefault, line starts with OS/2 audio driver:' pdd_name */
        line = linein(control_file)            /* get number of params */
        parse upper value line with '"' vdd_name '"'
        line = linein(control_file)
        parse value line with '"' num_params '"'

        /* with pdd_name and vdd_name, it is sufficient to find out default  */
        /* OS/2 audio device; search for [defaultnames] section in MMPM2.INI */


/*?*/
        call lineout(BootDrv||'\MMOS2\MMPM2.INI')    /* close mmpm2.ini for later search */



        call SysFileSearch '[defaultnames]', BootDrv||'\MMOS2\MMPM2.INI', 'd_names.', 'N'
        if d_names.0 = 0 then
        do
                call lineout(control_file)     /* close file if opened       */
                return 1                       /* none or 1 device installed */
        end
        parse value d_names.1 with startline ' ' junk
        do startline
                line = linein(BootDrv||'\MMOS2\MMPM2.INI')
        end

        w_word = ' '
        count = 0
        do while (compare('WAVEAUDIO', w_word, ' ') & count < 10)
                line = linein(BootDrv||'\MMOS2\MMPM2.INI')
                parse upper value line with w_word '=' wave_device
                w_word = right(w_word, 9)       /* forget blanks */
                count = count + 1               /* if mmpm2.ini is corrupted */
                                                /* this will stop infinite loop */
        end

        call lineout(BootDrv||'\MMOS2\MMPM2.INI')    /* close mmpm2.ini for later search */
                                                     /* VERY IMPORTANT!!                  */
        call SysFileSearch '['||wave_device||']', BootDrv||'\MMOS2\MMPM2.INI', 'waveaudio.', 'N'
        if ( waveaudio.0 = 0) then
                call MMPM2_CORRUPTED_ERROR
        /* say 'waveaudio section found = ' waveaudio.1 */
        parse value waveaudio.1 with startline ' '
        do startline
                line = linein(BootDrv||'\MMOS2\MMPM2.INI')
        end

        pdd_word = ''
        count = 0
        do while (compare(pdd_word, 'PDDNAME') & count < 50)
                line = linein(BootDrv||'\MMOS2\MMPM2.INI')
                parse upper value line with pdd_word '=' pdd_name_ini
                pdd_word = right(pdd_word, 7)   /* need just PDDNAME */
                count = count + 1               /* if mmpm2.ini is corrupted, stop at 50 lines */
        end
        if (compare(pdd_name_ini, vdd_name) <> 0) then
          do
                call lineout(control_file)      /* close file before return */
                return 0
          end
        else
          do
                call lineout(control_file)      /* close file before return */
                return 1
          end

end /* IsDefault */


/*******************************************************************/
/*                                                                 */
/*   Procedure : CheckControlFile                                  */
/*                                                                 */
/*               Check the existence of the WIN-OS2 driver passed  */
/*               in by checking the corresponding directories      */
/*               under \OS2\DRIVERS\. The directory name is the    */
/*               name of the control file with extension .ctl.     */
/*               For example, for ES1688DD, the control file is    */
/*               es1688dd.ctl.                                     */
/*                                                                 */
/*   Input     : Directory name for the WIN-OS2 audio driver       */
/*   Output    : just return if found; exit if not there           */
/*                                                                 */
/*******************************************************************/

CheckControlFile: PROCEDURE
do

  arg WinDriverDir

  /* is the .ctl file there? */

  parse value WinDriverDir with '\OS2\DRIVERS\' WinDriver
  call SysFileTree WinDriverDir||'\'||WinDriver||'.CTL', control_file, 'FS'

  if  control_file.0 = 0  then
    do
        say
        say 'Error: 'WinDriver'.CTL does not exist.'
        say 'This file is essential for installing this WIN-OS2 driver.'
        say
        say 'Suggestion: Selective Install the corresponding OS/2 driver.'
        say
        exit
    end
  else /* .ctl file found */
        return
end /* of CheckControlFile */


MMPM2_CORRUPTED_ERROR: PROCEDURE
do
        say
        say 'ERROR: MMPM2.INI file may be corrupted;'
        say '       Please re-install Multimedia.'
        say
        exit
end


/*******************************************************************/
/*                                                                 */
/*   Procedure : GetOS2ParamValue                                  */
/*                                                                 */
/*               Use parameter name, such as /A:, to search the    */
/*               config.sys file to find out its setting, such as  */
/*               240.  If no lettered parameter passed, it is      */
/*               positional, meaning 1 for 1st parameter that      */
/*               follow the DEVICE line.                           */
/*                                                                 */
/*   Input     : Packed information: control file location and     */
/*               the name of the parameter.                        */
/*                                                                 */
/*   Output    : -1 if no valid value found; the value if valid.   */
/*                                                                 */
/*******************************************************************/

GetOS2ParamValue: PROCEDURE
do
        arg packed_info
        parse value packed_info with control_file '==' param_name
        /* say '::GetOS2ParamValue, control_file is = ' control_file */
        BootDrv = left(control_file, 2)
        config_sys = BootDrv||'\'||CONFIG.SYS
        call SysFileSearch param_name, control_file, 'file.'
        if (file.0 = 0) then
          do
                say
                say 'Error in the control file.'
                say 'Please check the [PDD_INFO] section and [MODIFY] section'
                sya 'in 'control_file'.'
                call lineout(control_file)      /* close file before return */
                return -1                       /* junk value, will be checked upon return */
          end
        parse value file.1 with '"' param_letter '"' '"' junk '"'

        /* get PDD name from the .ctl file */
        /* it is used to search in config.sys */

        call SysFileSearch '[PDD_INFO]', control_file, 'pdd_info.', 'N'
        if (pdd_info.0 = 0) then
                call CONTROL_FILE_ERROR_OUTPUT
        else
                parse value pdd_info.1 with startline ' '

        do startline
                line = linein(control_file)     /* brings to the first line  */
        end                                   /* of [PDD_INFO] section     */
        line = linein(control_file)
        parse value line with '"' pdd_sys '"'

        call SysFileSearch pdd_sys, config_sys, 'sys_line.', 'N'
        if (sys_line.0 = 0) then      /* no DEVICE line found for pdd_sys */
          do
                call lineout(control_file)
                return -1
          end

        /* add REM line checking here if desired */


        /* is parameter without a letter-indicator? */
        /* if yes, it is positional.                */

        if (verify(param_letter, '1234567890') = 0) then   /* no param letter */
        do                                                 /* only ith param  */
          parse value sys_line.1 with getrid1 ':' getrid2 ' ' left_over
          do while (left(left_over, 1) = ' ')
            parse value left_over with getrid ' ' left_over
          end
          do n=1 to param_letter-1
            parse value left_over with getrid ' ' left_over
            do while (left(left_over, 1) = ' ') /* get rid of leading blanks */
              parse value left_over with ' ' left_over
            end
          end /* do n=1 to param_letter */
          parse value left_over with param_value ' ' throw_away
          call lineout(control_file)    /* close before return */
          return param_value
        end /* if (verify...) */

        /* otherwise, search for the letter parameter indicator */

        parse value sys_line.1 with junk1 ':' junk2 ' ' rest_line
        do while (left(rest_line, 1) = ' ')     /* get rid of leading blanks */
          parse value rest_line with ' ' rest_line
        end
        do while (left(rest_line, length(param_letter)) <> param_letter)
          parse value rest_line with junk ' ' rest_line
          do while (left(rest_line, 1) = ' ')     /* get rid of leading blanks */
            parse value rest_line with ' ' rest_line
          end
        end /* do while (left(rest_line... */

        /* found the parameter that we want */
        rest_line = right(rest_line, length(rest_line) - length(param_letter))
        parse value rest_line with param_value ' ' throw_away
        call lineout(control_file)
        return param_value
end
'exit'
/* last modified 29 Nov 1999 */

