/* MMImagePak Installation Procedure */

/* 㦠 SysUtils */
rc=RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
rc=SysLoadFuncs()

call say_log 'MMImagePak installation started at '||date()||' '||time()

/* ।塞 ⥬ ⠫  ᪨ */
temp=lib_temp_directory()
bootdrive=lib_boot_drive()
osdir=lib_os_directory()
backdir=lib_backup_directory('MMImagePak')
OS=lib_os_name()
mmbase=lib_mm_directory()

c = SUBSTR(osdir, 1, 1)

call log 'Temporary directory='||temp
call log 'Boot drive='||bootdrive
call log 'OS directory='||osdir
call log 'Backup directory='||backdir
call log 'OS type='||OS
call log 'Multimedia base directory='||mmbase

/* ᯠ뢠 娢 */

returndir=directory()
'@md '||temp||'\dinst'
'@unzip -o -qq package -d '||temp||'\dinst'
call lib_safechdir temp||'\dinst'



/*  ᯨ᮪ 䠩,  㤥 ⠭ */
tmp=temp||'\deluxe.tmp'
tmp2=temp||'\deluxe2.cmd'
'@dir /b *.dll  > '||tmp

/* 塞,   ࠥ */
do while lines(tmp)>0
  s=linein(tmp)
  mmdir=mmbase||'\DLL\'
  rc=lineout(tmp2,'@if exist "'||mmdir||s||'" copy "'||mmdir||s||'" "'||backdir||'\'||s||'" > nul')
end

rc=lineout(tmp2,'@copy "'||mmbase||'\MMPMMMIO.INI" "'||backdir||'\MMPMMMIO.INI" > nul')
rc=stream(tmp2,'c','close')
rc=stream(tmp,'c','close')

/*  १ࢭ  */
'@call '||tmp2
'@if exist '||tmp2||' del '||tmp2
'@if exist '||tmp||' del '||tmp

'@unlock '||mmbase||'\dll\*io.dll >nul'
'@unlock '||mmbase||'\dll\zcodec.dll >nul'

/* ।塞,   MINSTALL    ⥬ */
rep=temp||'\rep.tmp'

'@bldlevel '||mmbase||'\minstall.exe > '||rep
do while lines(rep)>0
  s=linein(rep)
  parse value s with Key ':' Value
  If strip(key)='Vendor' then leave
end

rc=stream(rep,'c','close')
'@if exist '||rep||' del '||rep

z=directory();
curdir=''
do p=1 to length(z)
  l=substr(z, p, 1)
  if l='\' then
    curdir=curdir||'\\'
  else
    curdir=curdir||l
end

mmdir=''
if substr(mmbase, length(mmbase))='\' then mmbase=substr(mmbase, 1, length(mmbase)-1)
do p=1 to length(mmbase)
  l=substr(mmbase, p, 1)
  if l='\' then
    mmdir=mmdir||'\\'
  else
    mmdir=mmdir||l
end



/* ।塞 ᫮ 㯯  䠩 ⢥⮢ */

groupcount=0
do while lines('ioproc.lst')>0
  s=linein('ioproc.lst')
  groupcount=groupcount+lines('ioproc.lst')
end
rc=stream('ioproc.lst','c','close')
groupcount=groupcount+3

/* 㥬 䠩 ⢥⮢ */

/* ந⥫ - KIEWITZ*/
if strip(value)='KIEWITZ' then
do
  call say_log 'MINSTALL by KIEWITZ'
  rc=lineout(rep, 'MMINSTALL = ( ')
  rc=lineout(rep, '   SOURCE = "'||curdir||'"')
  rc=lineout(rep, '   TARGET = "'||mmdir||'"')
  rc=lineout(rep, '   TARGETBOOT = ""')
  rc=lineout(rep, '   GROUPS['||groupcount||'] = (')
  do i=1 to groupcount
    rc=lineout(rep, '      ( GROUPID    = '||i)
    rc=lineout(rep, '        CUSTOMDATA = ""')
    rc=lineout(rep, '      )')
  end
  rc=lineout(rep, '    )')
  rc=lineout(rep, ' )')
end
else
/* ந⥫ - IBM */
if strip(value)='IBM' then
do
  call say_log 'MINSTALL by IBM'
  rc=lineout(rep, 'MMINSTSOURCE = "'||curdir||'"')
  rc=lineout(rep, 'MMINSTTARGET = "'||c||':"')
  rc=lineout(rep, 'CHANGECONFIG = "Y"')
  rc=lineout(rep, '')
  rc=lineout(rep, 'MMINSTGROUPS =')
  rc=lineout(rep, '   (')
  do i=1 to groupcount
    rc=lineout(rep, '   GROUP.'||i||' = " "')
  end
  rc=lineout(rep, '   )')
end
else
  call say_log 'Error! Unknown MINSTALL version'

rc=stream(rep,'c','close')

z=substr(osdir, 3);
odir=''
do p=1 to length(z)
  l=substr(z, p, 1)
  if l='\' then
    odir=odir||'\\'
  else
    odir=odir||l
end

rc=lineout('files.lst', groupcount*2+2);

'@if exist control.scr @del control.scr>nul'
rc=lineout('control.scr', 'package="MMIMAGE"');
rc=lineout('control.scr', 'codepage=850');
rc=lineout('control.scr', 'filelist="FILES.LST"');
rc=lineout('control.scr', 'groupcount='||groupcount);
rc=lineout('control.scr', 'munitcount=1');
rc=lineout('control.scr', 'medianame="MMImage Pak"');
rc=lineout('control.scr', '');
rc=lineout('control.scr', 'destindir = "\\MMOS2\\INSTALL\\"          = 0');
rc=lineout('control.scr', 'destindir = "\\MMOS2\\DLL\\"              = 1');
rc=lineout('control.scr', 'destindir = "'||odir||'\\DLL\\"           = 2');
rc=lineout('control.scr', '');
count=0
do while lines('ioproc.lst')>0
  s=linein('ioproc.lst')
  count=count+1
  parse value s with Name '|' FOURCC '|' DLL '|' Entry '|' Extension
  rc=lineout('control.scr', '');
  rc=lineout('control.scr', 'ssgroup='||count);
  rc=lineout('control.scr', 'ssname="'||Name||'"');
  rc=lineout('control.scr', 'sssize=70');
  rc=lineout('control.scr', 'ssversion="1.0.0"');
  rc=lineout('control.scr', 'ssselect="YES"');
  rc=lineout('control.scr', 'ssinich="'||count||'.SCR"');

  rc=lineout('files.lst', '/* '||Name||' */');
  rc=lineout('files.lst', '     0        '||count||'        1         0      "'||DLL||'"');
  rc=lineout('files.lst', '     0        '||count||'        0         0      "'||count||'.SCR"');

  rc=lineout(count||'.scr', 'mmioInstall =');
  rc=lineout(count||'.scr', '(');
  rc=lineout(count||'.scr', '  mmioFourCC        = "'||FOURCC||'"');
  rc=lineout(count||'.scr', '  mmioDllName       = "$(DEST)'||DLL||'"');
  rc=lineout(count||'.scr', '  mmioDllEntryPoint = "'||Entry||'"');
  rc=lineout(count||'.scr', '  mmioFlags         = 0x00000000L');
  rc=lineout(count||'.scr', '  mmioExtendLen     = 0x00000010L');
  rc=lineout(count||'.scr', '  mmioMediaType     = 0x00000001L');
  rc=lineout(count||'.scr', '  mmioIOProcType    = 0x00000002L');
  rc=lineout(count||'.scr', '  mmioDefExt        = "'||Extension||'"');
  rc=lineout(count||'.scr', ')');
  rc=stream(count||'.scr','c','close')
end
rc=stream('ioproc.lst','c','close')

count=count+1
rc=lineout('files.lst', '     0        '||count||'        1         0      "ZCODEC.DLL"');
rc=lineout('files.lst', '     0        '||count||'        0         0      "ZCODEC.SCR"');

rc=lineout('control.scr', '');
rc=lineout('control.scr', 'ssgroup='||count);
rc=lineout('control.scr', 'ssname="Z (zlib) Codec"');
rc=lineout('control.scr', 'sssize=70');
rc=lineout('control.scr', 'ssversion="1.0.0"');
rc=lineout('control.scr', 'ssselect="YES"');
/* rc=lineout('control.scr', 'ssconfigch="MMIMAGE.SCR"'); */
rc=lineout('control.scr', 'ssinich="ZCODEC.SCR"');
rc=lineout('control.scr', '');

rc=stream('control.scr','c','close')
rc=stream('files.lst','c','close')

/* 뢠 楤 ⠭ */
'@minstall /R:'||rep||' /F:'||directory()||'\control.scr > nul'
r=rc
'@copy %LOGFILES%\dinst.log+'||mmbase||'\install\minstall.log %LOGFILES%\dinstall.log > nul'
'@del %LOGFILES%\dinst.log > nul'
if R<>-512 then
do
  call say_log 'Error during MINSTALL. RC='||R
  /*   MINSTALL  KIEWITZ:
    2048 -   response file
    8 -   䠩
  */
  errmsg='Error during MINSTALL work. RC='||R
  signal error
end

'@if exist '||rep||' @del '||rep||'>nul'
'@del control.scr>nul'
'@del files.lst>nul'
groupcount=0
do while lines('ioproc.lst')>0
  s=linein('ioproc.lst')
  groupcount=groupcount+1
  '@del '||groupcount||'.scr'
end
rc=stream('ioproc.lst','c','close')

call say_log 'I/O Procedures installed'

'@copy uninstall.cmd '||osdir||'\INSTALL\BACKUP\MMImagePak > nul'
'@copy unlock.exe '||osdir||'\INSTALL\BACKUP\MMImagePak > nul'
If SysCreateObject("WPProgram", "MMImagePak deinstallation", "<WP_ASDUNINSTFOLDER>","EXENAME="||osdir||"\INSTALL\BACKUP\MMImagePak\uninstall.cmd;OBJECTID=<MMIMAGEPAK_UNINST>","U") Then
call say_log 'Deinstallation procedure installed'

say 'Resort standard system images? (Y/N)'

pull action
if left(action, 1)='Y' then
do
  call say_log 'Resorting images...'
  f='resort.scr'
  do while lines(f)>0
    s=strip(linein(f))
    if s<>'' then if (substr(s, 1, 1)<>'#') then
    do
      parse value s with _from '|' _to
      '@if not exist '||mmbase||'\IMAGES\'||_to||'\* @md '||mmbase||'\IMAGES\'||_to||' 2>&1 >NUL'
      '@if exist '||bootdrive||_from||' @copy '||bootdrive||_from||' '||mmbase||'\IMAGES\'||_to||'\ 2>&1 >NUL'
      '@if exist '||bootdrive||_from||' @del '||bootdrive||_from||' 2>&1 >NUL'
    end
  end
  call say_log 'Image resorting finished.'
end
rc=stream(f,'c','close')


/* .  ⮢. */
call say_log ''
call say_log 'Installation finished. Please reboot.'

curdir=directory()
if translate(curdir)=translate(temp||'\DINST') then
do
  '@del * /N'
  call lib_safechdir temp
  '@rd dinst'
end
else
do
  errmsg='Can not delete files from temporary directory'
  signal error
end
call lib_safechdir returndir

signal stop


error:
  call say_log errmsg
  call say_log ''
  call say_log 'Please send bug report and logfile dinstall.log from your'
  call say_log 'logfiles directory to support@ecomstation.ru'
  call say_log ''
  call say_log 'Thank you for your support.'
  call say_log ''

  rc=stream(rep,'c','close')
  '@if exist '||rep||' del '||rep
  rc=stream(tmp2,'c','close')
  rc=stream(tmp,'c','close')
  '@if exist '||tmp2||' del '||tmp2
  '@if exist '||tmp||' del '||tmp

  signal stop
exit

stop:
  call say_log 'MMImagePak installation ended at '||date()||' '||time()
  /*   ⠭ */
  '@copy %LOGFILES%\dinstall.log + %LOGFILES%\dinst.log %LOGFILES%\d.log > nul'
  '@del %LOGFILES%\dinstall.log > nul'
  '@copy %LOGFILES%\d.log %LOGFILES%\dinstall.log > nul'
  '@del %LOGFILES%\dinst.log %LOGFILES%\d.log > nul'

exit


say_log: Procedure
Parse Arg msg
'@echo '||msg||'>>%LOGFILES%\dinst.log'
Say msg
Return

log: Procedure
Parse Arg msg
'@echo '||msg||'>>%LOGFILES%\dinst.log'
Return

/*********************************************/
/* 窠 㭪権 */
/*********************************************/

/* ६ ⠫ */

lib_temp_directory: Procedure

temp = STRIP(VALUE('TEMP',,'OS2ENVIRONMENT'))
if temp='' then
do
  call log 'TEMP environment variable not found. Trying TMP.'
  temp = STRIP(VALUE('TMP',,'OS2ENVIRONMENT'))
  if temp='' then
  do
    errmsg='Environment variable TEMP or TMP not set. Please set variable and rerun install script.'
    signal error
  end
end

Return temp

/* 㧮  */

lib_boot_drive: Procedure
If \Rxfuncquery('SysBootDrive') Then
do
  bootdrive = SysBootDrive()
end
else
do
  call log 'No SysBootDrive function. Trying find bootdrive via PATH.'
  parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2, bootdrive +2
  if bootdrive = '' then
  do
    errmsg='Can not detect boot drive. Please update REXXUTIL.DLL.'
    signal error
  end
end

return bootdrive

lib_os_name: procedure

osdir = STRIP(VALUE('OSDIR',,'OS2ENVIRONMENT'))
if osdir='' then
do
  OS="OS2"
end
else
do
  OS="ECS"
end

return OS

/* ⠫  樮 */

lib_os_directory: procedure

osdir = STRIP(VALUE('OSDIR',,'OS2ENVIRONMENT'))
if osdir='' then
do
  osdir=lib_boot_drive()||'\OS2'
end

return osdir


/* ⠫  १   ⠭ */

lib_backup_directory: Procedure

Parse Arg ProductName

osdir=lib_os_directory()
backdir = osdir||'\INSTALL\BACKUP'
'@if not exist '||backdir||' md '||backdir
backdir = osdir||'\INSTALL\BACKUP\'||ProductName
'@if not exist '||backdir||' md '||backdir
backdir = osdir||'\INSTALL\BACKUP\'||ProductName||'\'||DATE('S')||TIME('S')
'@if not exist '||backdir||' md '||backdir

return backdir

/*  ᬥ ⠫.  ஢મ 䠪 室.  ᬥ ᪠. */
lib_safechdir: Procedure

Parse Arg dir

'@cd '||dir
'@'||substr(dir, 1, 2)
curdir=directory()
if translate(curdir)<>translate(dir) then
do
  errmsg 'Error change to directory '||dir
  signal error
end

return

/* 頥 ⠫  㬥 */
lib_mm_directory: Procedure

mmbase = STRIP(VALUE('MMBASE',,'OS2ENVIRONMENT'))
parse value mmbase with mmbase ';'

if mmbase='' then mmbase=lib_boot_drive()||'\MMOS2'

return mmbase
