/* This file is generated automatically by configure */
/* It is valid only for the system type i386-pc-os2-emx */

#ifndef __BYTEORDER_H
#define __BYTEORDER_H

/* extended byte swapping macros are already available */
#include <machine/endian.h>

/* Define generic byte swapping functions */
#define swap16(x) bswap16(x)
#define swap32(x) bswap32(x)
#define swap64(x) bswap64(x)

/* Define the C99 standard length-specific integer types */
#include <_stdint.h>

/* Here are some macros to create integers from a byte array */
/* These are used to get and put integers from/into a uint8_t array */
/* with a specific endianness.  This is the most portable way to generate */
/* and read messages to a network or serial device.  Each member of a */
/* packet structure must be handled separately. */

/* The i386 and compatibles can handle unaligned memory access, */
/* so use the optimized macros above to do this job */
#define be16atoh(x)     be16toh(*(uint16_t*)(x))
#define be32atoh(x)     be32toh(*(uint32_t*)(x))
#define be64atoh(x)     be64toh(*(uint64_t*)(x))
#define le16atoh(x)     le16toh(*(uint16_t*)(x))
#define le32atoh(x)     le32toh(*(uint32_t*)(x))
#define le64atoh(x)     le64toh(*(uint64_t*)(x))

#define htobe16a(a,x)   *(uint16_t*)(a) = htobe16(x)
#define htobe32a(a,x)   *(uint32_t*)(a) = htobe32(x)
#define htobe64a(a,x)   *(uint64_t*)(a) = htobe64(x)
#define htole16a(a,x)   *(uint16_t*)(a) = htole16(x)
#define htole32a(a,x)   *(uint32_t*)(a) = htole32(x)
#define htole64a(a,x)   *(uint64_t*)(a) = htole64(x)

#endif /*__BYTEORDER_H*/
