/* REXX */

/* filter script for printmon           */
/* needs:                               */
/*        GhostScript, FaxWorks,        */
/*        Printmon                      */
/* and    PSExtract and ReverseFaxBits  */
/*        by Jens Schiffler             */


/* Constants */

/* GhostScript settings */
gsDir='c:\gstools\gs5.10'
gsCommand='gsos2 -sPAPERSIZE=a4 -dNOPAUSE'
gsPrintCommand='gsos2 -sPAPERSIZE=a4 -sDEVICE=ljet2p -dNOPAUSE'

/* FaxWorks settings */
fwDir='c:\faxworks'
faxidfile=FWDir'\FAX.IDX'
faxlogfile=FWDir'\FAX.LOG'

/* PSExtract settings */
extractfile="c:\printmon\psfilter.txt"
psfile="c:\printmon\psfilter.ps"
extractCommand="c:\GhostFax\PSExtract.exe "psfile extractfile

/* ReverseFaxBits settings */
revbitscommand="c:\GhostFax\reversefaxbits.exe"



/* get date */
parse value DATE('N') with dd mmm yyyy
sendday=dd'-'mmm'-'substr(yyyy, 3, 2, '0')

if length(dd)=1 then
  sendday='0'sendday

/* get time */
parse value time('N') with hh':'mm':'ss
sendtime=hh':'mm

ToName=''
ToOrg=''
ToFax=''
ToPhone=''

FromName=''
FromOrg=''
FromFax=''
FromPhone=''

/* filter stdin until it's closed */

extractcommand

/* check for normal termination of filter program */
if rc <> 0 then exit

/* get fax pagecount */
parse value linein(extractfile,1) with "Pages:" PageCount .

/* check for FAX keyword */
FirstLine=linein(extractfile)

If WordPos(FirstLine,"FAX")>0 then do
        /* prepare faxfile for sending */
   say 'FAX:'

        /* read fax data from extracted textfile */
        ToFax=strip(linein(extractfile))
        ToName=strip(linein(extractfile))
        ToOrg=strip(linein(extractfile))
        ToPhone=strip(linein(extractfile))

        FromName=strip(linein(extractfile))
        FromOrg=strip(linein(extractfile))
        FromFax=strip(linein(extractfile))
        FromPhone=strip(linein(extractfile))

        say PageCount 'pages'
        say 'To:' ToName',' ToOrg 'FAX:' ToFax 'Phone:' ToPhone
   say 'From:' FromName',' FromOrg 'FAX ID:' FromFax 'Phone:' FromPhone
   say sendday sendtime

        /* read number from "fax.idx" */
   call stream faxidfile, 'c', 'open'
   parse value charin(faxidfile,1,6) with faxid
   call stream faxidfile, 'c', 'close'

        say 'FaxWorks file index: 'faxid'|'

        /* build .FAX file name*/
   extid=translate(format(faxid, 6),'0',' ')
   faxfile=FWDir'\Fx'extid'.FAX'

        /* do not overwrite existing fax file */

   if stream(faxfile, 'c', 'query exists') = '' then do

                /* increment number in "fax.idx" */
        call stream faxidfile, 'c', 'open'
      call charout faxidfile, substr(strip(FAXID)+1,1,6,' '), 1
                call stream faxidfile, 'c', 'close'

                /* generate fax file */
                l=setlocal()
                'cd 'gsDir
           gsCommand '-sDEVICE=tiffg3 -sOUTPUTFILE='faxfile psfile '-c quit'
                l=endlocal()

                /* patch fax file */
                revbitscommand faxfile

                /* add faxworks log entry for new file */
                /*<ID>,<DATE>,<TIME>,Spool ,<DURATION>,<COVER?>,1,0,,<TO NAME>,<TO ORG>,<TO FAX>,<FROM NAME>,<FROM ORG>,<FROM PHONE>,<FROM FAX>,<COMMENT>,,,<TO ID>,,<TO PHONE>*/
      say 'adding fax to FaxWorks log'
                call stream faxlogfile, 'c' 'open'
                call lineout faxlogfile, strip(FAXID)','sendday','sendtime','pagecount',Spool ,,0,1,10,,'ToName','ToOrg','ToFax','FromName','FromOrg','FromPhone','FromFax',,,,,,,'ToPhone
                call stream faxlogfile, 'c', 'close'
   end /* do */
   else do
      say 'ERROR: file' faxfile ' already exists'
   end /* do */

end /* do */
else do
  /* print */
   say 'no fax'
        l=setlocal()
        'cd 'gsdir
   gsPrintCommand psfile '-c quit'
        l=endlocal()

end /* do */

call stream extractfile,'c','close'

EXIT
