#define INCL_DOS
//#define INCL_NOPMAPI
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>

#define DEFAULTSIZE 256

UCHAR tmpfn[DEFAULTSIZE],*env; // = "$$$$$$$$.$$$";
struct LOG_ENTRY
	{
	ULONG fileno;
	UCHAR date[10],time[6];
	USHORT pages;
	UCHAR status[8],duration[6];
	UCHAR *coverpage;
	UCHAR *dstname,*dstcompany,*dstfaxno;
	UCHAR *srcname,*srccompany,*srcphoneno,*srcfaxno;
	UCHAR *comment;
	UCHAR *what,*dstTSI;
	struct LOG_ENTRY *next;
	};

typedef struct LOG_ENTRY LOGENTRY;



/************************************************************************/
UCHAR *get_field(UCHAR *src,UCHAR **dst)
{
UCHAR end,*s;
if (*src == '"') { end = '"'; src++; }
else end = ',';
s = strchr(src,end);
if (s)
	{
	*s = 0;
	*dst = calloc(1,strlen(src)+1);
	strcpy(*dst,src);
	if (end == ',') return(&s[1]);
	else return(&s[2]);
	}
*dst = NULL;
return(src);
}

ULONG check_logentry(UCHAR *l)
{
ULONG i;
UCHAR *s;
for (i = 0;i < 23;i++)
	{
	l = get_field(l,&s);
	if (s && strlen(s))
		{
		if (i == 4) // Status
			{
			if (strstr(s,"Send") || strstr(s,"Spool"))
				return(1);
			}
		}
	}
return(0);
}

/**********************************************************************/
int readlog(UCHAR *logfn)
{
int cnt = 0;
FILE *fp;
UCHAR *s,tmp[DEFAULTSIZE];
int fh;
fprintf(stderr,"\nRead %s",logfn);
fh = sopen(logfn, O_RDONLY, SH_DENYNO);
if (fh != -1)
	{
	fp = fdopen(fh,"rt");
	while (fgets(tmp,DEFAULTSIZE,fp) != NULL)
		{
		s = strchr(tmp,'\n');
		if (s) *s = 0;
		cnt += check_logentry(tmp);
		}
	fclose(fp);
	}
else
	{
	fprintf(stderr," ... open error");
	return(-1);
	}
if (cnt) fprintf(stderr," ... Send or Spool in progress");
else fprintf(stderr," ... no fax activity");
return(cnt);
}

PID getID(UCHAR *pname,ULONG cnt)
{
FILE *fp;
int fh;
PID pid;
ULONG ppid,sid;
UCHAR l[255],proc[255],*p;
fh = creattemp(tmpfn,0);
close(fh);
strupr(pname);
sprintf(l,"PSTAT /C > %s",tmpfn);
system(l);
fp = fopen(tmpfn,"r");
while (fgets(l,255,fp))
	{
	if (isdigit(l[1]))
		{
		sscanf(&l[1],"%x %x %x %s",&pid,&ppid,&sid,proc);
		p = strstr(proc,pname);
		if (p && --cnt == 0)
			{
			fprintf(stderr,"\n%s PID=%u",proc,pid);
			fclose(fp);
            unlink(tmpfn);
			return(pid);
			}
		}
	}
fclose(fp);
unlink(tmpfn);
return((PID) 0);
}

BOOL trytokill(void)
{
BOOL kill;
APIRET  rc;
PID ProcessID;
HWND  hwndNext;
HENUM  henum;
PID  pid;   // Process identity of the thread that created the window
TID  tid;   // Thread identity of the thread that created the window
ProcessID = getID("FAXWORKS.EXE",1);
kill = FALSE;
henum = WinBeginEnumWindows(HWND_DESKTOP);
while ((hwndNext = WinGetNextWindow(henum)) != NULLHANDLE)
	{
	if (WinQueryWindowProcess(hwndNext,&pid,&tid))
		{
		if (pid == ProcessID)
			{
			WinPostMsg(hwndNext,WM_QUIT,0,0);
			fprintf(stderr," ... WM_QUIT sent!");
			kill = TRUE;
			break;
			}
		}
	}
WinEndEnumWindows(henum);
DosSleep(5000); // wait 5 sec
ProcessID = getID("FAXWORKS.EXE",1);
if (ProcessID)
	{
	rc = DosKillProcess(DKP_PROCESS,ProcessID);
	if (rc != 0)
		{
		fprintf(stderr,"DosKillProcess error: return code = %ld", rc);
		return(FALSE);
		}
	else
		{
		kill = TRUE;
		fprintf(stderr," ... killed!");
		}
	}
return(kill);
}

int main(int argc,char **argv)
{
ULONG t = 60000;
int ret,cnt = 2;
if (argc < 2)
	{
	fprintf(stderr,"\n%s <path_to_fax.log> [<seconds_to_wait>]",argv[0]);
	return(1);
	}
if (argc > 2) t = atoi(argv[2]) * 1000;
strupr(argv[1]);
if (t) fprintf(stderr,"\nWaiting %u seconds till reading %s",t/1000,argv[1]);
env = getenv("TMP");
if (!env) env = getenv("TEMP");
if (env)
	{
	strcpy(tmpfn,env);
	if (tmpfn[strlen(tmpfn)-1] != '\\') strcat(tmpfn,"\\");
	}
else *tmpfn = 0;
while (1)
	{
	if (t)
		{
		DosSleep(t);
		if (!access(argv[1],0))
			{
			ret = readlog(argv[1]);
			switch(ret)
				{
				case 0:
					cnt--;
				case -1:
					t = 2000;
					break;
				default:
					cnt = 2;
					t = 10000;
					break;
				}
			}
		else
			{
			fprintf(stderr,"\n%s does not exist",argv[1]);
			return(2);
			}
		}
	else cnt = 0;
	if (cnt == 0)
		{
		trytokill();
		return(0);
		}
	}
}

