(*
TaskTimer routines that work with input of data into the program and output
of data to the display
*)
unit tt_IO;

interface

uses
  crt,
  tt_util;

const
  numcols:byte=80;
  numrows:byte=25;
  oldvideomode:byte=0;
  (* text styles/colors *)
  normal=lightgray;
  bold=white;
  italic=lightcyan;
  underline=yellow;
  flash=blink;
  dim=darkgray;
  screenmem:pointer=nil;

function ReadKey:Char;
function KeyPressed:Boolean;
procedure gotoxy(x,y:byte);
procedure WriteLoop(num:byte;c:char);
procedure WriteClrEOL(s:string);
procedure WriteCentered(s:string);
procedure clearscr;
procedure initvideo;
procedure closevideo;
Function CurrentSecond:byte;
procedure beep;
Procedure DrawLine;
procedure changecolor(color:byte);
Function TextWrap(s:string):string;

implementation

Function ReadKey:Char; Assembler;
Asm
  mov ah, 00h
  int 16h
end;

Function KeyPressed:Boolean; Assembler;
Asm
  mov ah, 01h
  int 16h
  mov ax, 00h
  jz @1
  inc ax
  @1:
end;

Procedure gotoxy(x,y:byte);assembler;
asm
  mov ah,2
  mov bh,0
  mov dh,y
  mov dl,x
  dec dh
  dec dl
  int 10h
end;

procedure WriteLoop(num:byte;c:char);
var
  foo:byte;
begin
  for foo:=0 to num do write(c);
  (* Yes, this actually takes up less codespace than "writeln('--------..." *)
end;

Procedure WriteClrEOL(s:string);
(* Writes a string to the screen padded with spaces until the last column *)
begin
  write(s); clreol; writeln;
end;

procedure WriteCentered(s:string);
var
  foo:byte;
  b:byte;
begin
  if length(s)<numcols then begin
    b:=(numcols div 2) - (length(s) div 2) - 1;
    for foo:=0 to b do s:=#32+s;
  end;
  WriteClrEOL(s);
end;

Procedure InitVideo;
begin
  oldvideomode:=lastmode;
  textmode(co40);
  directvideo:=True; (* Need IBM PC compatible machine, sorry -- maybe next version *)
  checksnow:=false; (* we're going to be in 40-col mode -- no snow in that mode! *)
  numcols:=40;
  numrows:=25;
  (* turn off the cursor *)
  asm
    mov ah,1
    mov cx,2000h
    int 10h
  end;
  screenmem:=ptr(segb800,0);
end;

Procedure CloseVideo;
begin
  textmode(oldvideomode);
  directvideo:=false;
end;

Function CurrentSecond:byte;assembler;
asm
  mov ah,$2c
  int $21
  mov al,dh
end;

Procedure Beep;
const
  freq=440;
  ms=33;
begin
  sound(freq shl 2);
  delay(ms);
  sound(freq shl 1);
  delay(ms);
  sound(freq);
  delay(ms);
  nosound;
end;

procedure DrawLine;
begin
  WriteLoop(numcols-1,#196);
end;

Procedure clearscr;assembler;
asm
  les di,screenmem
  mov cx,(40*25)
  xor ax,ax
  rep stosw
end;

procedure ChangeColor(color:byte);
begin
  textcolor(color);
end;

Function TextWrap(s:string):string;

const
  margin:byte=32;
  delim=#32;

var
  loop:word;
  curword,nexword:string;
  foos:string;
  where:byte;

begin
  foos:='';
  margin:=numcols;
  where:=1;
  for loop:=1 to maxsplitsperline do begin
    curword:=split(s,delim,loop);
    nexword:=split(s,delim,loop+1);
    (* Philosophy:  Print current word, then check next word to see if it
       will go over the margin.  If so, go to the next line. *)
    if (curword<>'#0') and (curword<>'')
      then begin
        foos:=foos+curword+delim;
        inc(where,length(curword)+length(delim));
      end;
    if (nexword<>'#0')
      then if (where+length(nexword)+1 > margin)
        then begin
          foos:=foos+#13#10;
          where:=1;
        end;
  end;
  TextWrap:=foos;
end;

end.
