(* utility functions that can be reused for all programs *)
unit tt_util;

interface

const
  maxsplitsperline=127;

function str2int(s:string):longint;
function int2str(l:longint):string;
Function upstring(s:string):string;
Function FileExists(FileName:string):boolean;
Function split(line:string;delimiter:char;position:byte):string;

implementation

function str2int(s:string):longint;
var
  l:longint;
  i:integer;
begin
  val(s,l,i);
  str2int:=l;
end;

function int2str(l:longint):string;
var
  s:string;
begin
  str(l,s);
  int2str:=s;
end;

Function upstring(s:string):string;
var
  foo:byte;
begin
  for foo:=1 to length(s) do
    s[foo]:=upcase(s[foo]);
  upstring:=s;
end;

Function FileExists(FileName:string):boolean;
var
  f:file;
begin
  {$I-}
  Assign(f,FileName);
  Reset(f);
  Close(f);
  {$I+}
  FileExists := (IOResult = 0) and (FileName <> '');
end;

Function split(line:string;delimiter:char;position:byte):string;
const
  maxoffset:byte=0;
var
  loop:byte;
  offsets:array[0..maxsplitsperline] of byte;
  tempstr:string;
begin
  maxoffset:=0;
  fillchar(offsets,0,sizeof(offsets));
  (* Get list of offsets first *)
  (* first entry is always 0 *)
  offsets[maxoffset]:=0;
  maxoffset:=1;
  for loop:=1 to length(line) do begin
    if line[loop]=delimiter
      then begin
        offsets[maxoffset]:=loop;
        inc(maxoffset);
      end;
  end;
  (* Last entry is always maximum end of string *)
  offsets[maxoffset]:=length(line)+1;
  (* Now that we have a list of offsets, use them *)
  if position<=maxoffset
  (* if the user is asking for a split part that will exist *)
    then begin
      tempstr:=copy(line,offsets[position-1]+1,offsets[position]-offsets[position-1]-1);
    end else begin
    (* else, supply bogus value as error *)
      tempstr:=#0;
    end;
  split:=tempstr;
end;

end.