Program TaskTimer;

(*
Initially written by trixter@oldskool.org, v1.01, May 7, 2001.
Updated 3/28/2005
Updated 6/14/2006

For complete information on what this program is for and how to use it,
including a list of known issues using the program, consult TASKTIMR.DOC.
See other documentation for revision history, etc.
*)

uses
  dos,
  cmdlin,
  tt_vars,
  tt_util,
  tt_IO;

Function Seconds(minutes:word):longint;
(* This seems dumb but is used for debugging -- if I want tasks to end
quickly, all I have to do is set NumSecondsInAMinute to 2 or something *)
begin
  Seconds:=minutes * NumSecondsInAMinute;
end;

Function NiceTimeString(NumSeconds:word):string;
var
  m,s,h:string;
  foo:word;
begin
  foo:=NumSeconds div NumSecondsInAnHour;  str(foo,h); if foo<10 then h:='0'+h;
  foo:=(NumSeconds div NumSecondsInAMinute) mod 60; str(foo,m); if foo<10 then m:='0'+m;
  foo:=NumSeconds mod NumSecondsInAMinute; str(foo,s); if foo<10 then s:='0'+s;
  NiceTimeString:=h+':'+m+':'+s;
end;

Procedure Pause;
begin
  WriteClrEOL('Hit a key to continue.');
  if keypressed then repeat readkey until not keypressed;
  readkey;
end;

Function TaskEnded(t:task):boolean;
begin
  if t.SecondsRemaining <= 0
    then TaskEnded:=true
    else TaskEnded:=false;
end;

Function TaskEndedAbsolute(t:task):boolean;
(* Is a task OVER?  Is it out of time, not able to be extended, or out
   of extendable minutes?  *)
begin
  with t do begin
    if (MinMinutes+ExtendedMinutes >= MaxMinutes)
    or ( (not extendable) and (SecondsRemaining <= 0) )
      then TaskEndedAbsolute:=true
      else TaskEndedAbsolute:=false;
  end;
end;

Function TaskExtendable(t:task):boolean;
begin
  with t do
    if (extendable)
    and (maxminutes-(minminutes+extendedminutes) > 0)
      then TaskExtendable:=true
      else TaskExtendable:=false;
end;

Procedure Fatal(s:string);
begin
  closevideo;
  writeln(s);
  halt;
end;

Procedure AppendTask;

var
  f:text;
  news:string;
  footask:task;
  b:byte;

  function yes:boolean;
  var
    ch:char;
  begin
    write('(Y/N) '); ch:=upcase(readkey); writeln(ch);
    if ch='Y'
      then yes:=true
      else yes:=false;
  end;

  procedure a(s:string);
  begin
    news:=news+s+delimiter;
  end;

  function DateFields(bitfield:bdays):string;
  var
    foo:byte;
    s:string;
  begin
    s:='';
    for foo:=0 to 6 do begin
      if boolean(bitfield AND (1 shl foo))
        then s:=s+WeekString[foo+1]
        else s:=s+'-';
    end;
    DateFields:=s;
  end;

  procedure PrintDates(bitf:bdays);
  begin
    writeln(DateFields(bitf),' ... ',bitf:3);
  end;

begin
  if non_flag_param(1) <> '' then TaskFileName:=non_flag_param(1);
  if not fileexists(taskfilename)
    then fatal('Task configuration file ("'+TaskFileName+'") not found!');
  assign(f,TaskFileName);
  append(f);

  with footask do begin
    write('What is the name of the new task? '#13#10);
    for b:=0 to TaskNameLength do write(#32);
    write(']'#13'[');
    readln(taskname); news:=taskname+delimiter;

    writeln('   Days ... BVal');
    writeln('   ~~~~     ~~~~');
    PrintDates(bSunday);
    PrintDates(bMonday);
    PrintDates(bTuesday);
    PrintDates(bWednesday);
    PrintDates(bThursday);
    PrintDates(bFriday);
    PrintDates(bSaturday);
    PrintDates(bSunday+bMonday+bTuesday+bWednesday+bThursday+bFriday+bSaturday);
    PrintDates(bSaturday+bSunday);
    PrintDates(bMonday+bTuesday+bWednesday+bThursday+bFriday);
    PrintDates(bMonday+bWednesday+bFriday);
    PrintDates(bTuesday+bThursday);
    write('On what days should this task should run?  (enter numeric bitfield value) ');
    readln(days); a(int2str(days));

    write('What''s the minimum number of minutes to spend on this task? ');
    readln(minminutes); a(int2str(minminutes));

    writeln('Is this task: ');
    write('  Pausable? '); if yes then pausable:=true else pausable:=false;
    write('  Skippable? '); if yes then skippable:=true else skippable:=false;
    write('  Deferrable? '); if yes then deferrable:=true else deferrable:=false;
    write('  Extendable? ');
    if yes then begin
      write('How many minutes can this task be extended to? ');
      readln(maxminutes);
    end else maxminutes:=minminutes;
    a(int2str(maxminutes));
    if pausable then a('y') else a('n');
    if skippable then a('y') else a('n');
    if deferrable then a('y') else a('n');
    writeln('Enter a comment for this task (127 chars maximum) or <ENTER> for none:');
    readln(TaskComment); news:=news+TaskComment;
  end; {with footask}
  Writeln('Adding this task to ',taskfilename,':');
  writeln(news);
  writeln(f,'# ',DateFields(footask.days));
  writeln(f,news);
  writeln(f,'');
  close(f);
  writeln('Done.');
  halt(2);
end;

Procedure PrintHelp;
begin
  writeln('TaskTimr Usage:   TASKTIMR <switches> <task file> <switches>');
  writeln('<task file> defaults to tasks.ini if omitted.  Switches are:');
  writeln('/?  Prints this help');
  writeln('/a  Appends a new task to <task file> (interactive)');
  writeln('/v  Verbose mode (small debug messages)');
  writeln('/c  Checks <task file> syntax');
  halt(1);
end;

Procedure InitTasks;
(* Inits the program *)
begin
  asm
    jmp @skippypoo
    db 'trixter@oldskool.org'
    @skippypoo:
  end;
  if is_param('?') then PrintHelp;
  if is_param('a') then AppendTask;
  if is_param('v') then Verbose:=true;
  if is_param('c') then begin
    CheckOnly:=true;
    Verbose:=true;
  end;
  if not CheckOnly
    then initvideo; (* if checking only, we don't need to touch the video mode *)
  fillchar(Tasks,sizeof(Tasks),#0); (* prepare var structs *)
end;

Procedure DisplayAllTasks(t:taskarray);
var
  b:byte;

begin
  changecolor(underline);
  writeln('There are currently ',numtasks,' tasks loaded:');
  for b:=0 to numtasks-1 do begin
    if b and 1=0
      then changecolor(bold)
      else changecolor(italic);
    with t[b] do begin
      if numtasks < (numrows div 3) then DrawLine;
      writeln(TaskName,': ',minminutes,'min-',maxminutes,'max.');
      if pausable or skippable or deferrable or extendable then begin
        write('Can ');
        if pausable then write('pause, ');
        if skippable then write('skip, ');
        if deferrable then write('defer, ');
        if extendable then write('extend, ');
        if pausable or skippable or deferrable or extendable
          then writeln(#08#08'.') (*backtrack over the comma-space*)
          else writeln(#13'    ');(*backtrack over the whole thing*)
      end;
    end;
  end;
  changecolor(normal);
end;

Procedure LoadTasks;
var
  f:text;
  foo:byte;
  s:string;
  counter:byte;
  ye,mo,da,dow:word;
begin
  counter:=0;
  getdate(ye,mo,da,dow);
  dow:=DaysOfWeek[dow];
  if non_flag_param(1) <> '' then TaskFileName:=non_flag_param(1);
  if not fileexists(taskfilename)
    then fatal('Task configuration file ("'+TaskFileName+'") not found!');
  assign(f,TaskFileName);
  reset(f);
  while not eof(f) do begin
    readln(f,s);
    inc(counter);
    if not verbose then write('Processing line #',counter,#13);
    (* if line isn't comment, isn't blank, and matches today, load it *)
    tasks[numtasks].Days:=str2int(split(s,delimiter,2));
    if Verbose and (s[1]<>'#') and (s<>'') then begin
      (*write(tasks[numtasks].days,'=');*)
      for foo:=0 to 6 do begin
        if boolean(tasks[numtasks].days AND (1 shl foo))
        then write(WeekString[foo+1])
        else write('-');
      end;
      writeln(' ',split(s,delimiter,1));
    end;
    if (s[1]<>'#')
    and (s<>'')
    and (boolean(tasks[numtasks].days and dow)) (* bitwise compare *)
    then begin
      with tasks[numtasks] do begin
        TaskName:=split(s,delimiter,1);
        MinMinutes:=str2int(split(s,delimiter,3));
        MaxMinutes:=str2int(split(s,delimiter,4));
        Pausable:=upstring(split(s,delimiter,5)) = 'Y';
        Skippable:=upstring(split(s,delimiter,6)) = 'Y';
        Deferrable:=upstring(split(s,delimiter,7)) = 'Y';
        TaskComment:=split(s,delimiter,8);
        if (TaskComment<>#0) and (TaskComment<>'')
          then TaskComment:=TextWrap(TaskComment)
          else TaskComment[0]:=char(TaskCommentLength);
        (* normally we'd be filling taskcomment with zeros or spaces right now
           but since I filled the entire array beforehand with zeros there's
           no need to *)
        ExtendedMinutes:=0;
        SecondsRemaining:=seconds(MinMinutes);
        SecondsSpent:=0;
        Completed:=false;
        (* now for some intelligence: *)
        if minminutes>maxminutes
          then minminutes:=maxminutes;
        if minminutes=maxminutes
          then extendable:=false
          else extendable:=true;
      end;
      inc(numtasks);
      {if Verbose and Checkonly then writeln(s);}
    end else begin
      if Checkonly then writeln(s);
    end;
  end;
  close(f);
  if not CheckOnly then begin
    DisplayAllTasks(tasks);
    DrawLine;
    pause;
  end;
end;

Procedure ActionsDisplay;
const
  Statline=23;
  actions='Actions:  ';
  ack='<SPACE> = Acknowledge';
  pause:string[9]='';
  skip='(S)kip';
  defer='(D)efer';
  extend='(E)xtend';
  s{eperator}=#179;
  fs:string[80]='';

begin
  gotoxy(1,statline);
  if not tasks[curtask].paused
    then pause:='  (P)ause'
    else pause:='un(P)ause';
  if not taskended(tasks[curtask])
    then begin
      writeln(actions);
      fs:='';
      with tasks[curtask] do begin
        if pausable then fs:=fs+pause+s;
        if skippable then fs:=fs+skip+s;
        if deferrable then fs:=fs+defer+s;
        if TaskExtendable(tasks[curtask]) then fs:=fs+extend+s;
      end;
      dec(fs[0],length(s));
      if tasks[curtask].paused then changecolor(normal+flash);
      WriteClrEOL(fs);
      changecolor(normal);
    end
    else if not taskendedAbsolute(tasks[curtask])
      then begin
        writeln(actions);
        WriteClrEOL(ack+s+extend)
      end
      else begin
        writeln(actions);
        WriteClrEOL(ack);
      end;
end;

Procedure StatDisplay;
const
  StatDisplayLine=14;
  msg1=' tasktime remaining: ';
var
  loop:byte;
  counter:longint;
begin
  gotoxy(1,StatDisplayLine);
  changecolor(underline); writeln('Statistics:');
  changecolor(normal);
  (* total time elapsed *)
  WriteClrEOL('Total time elapsed: '+NiceTimeString(totalseconds));
  (* time spent on tasks *)
  counter:=0;
  for loop:=0 to numtasks do inc(counter,tasks[loop].SecondsSpent);
  WriteClrEOL('Time spent on tasks: '+NiceTimeString(counter));
  (* time wasted (total minus spentontasks) *)
  WriteClrEOL('Time "wasted": '+NiceTimeString(totalseconds-counter));
  (* minimum task time remaining *)
  counter:=0;
  for loop:=0 to numtasks do
    if not tasks[loop].completed
      then inc(counter,seconds(tasks[loop].minminutes));

  changecolor(underline);
  writeln(#13#10'Approximations:');
  changecolor(normal);
  WriteClrEOL('Minimum'+msg1
              +NiceTimeString(counter));
  (* maximum task time remaining *)
  counter:=0;
  for loop:=0 to numtasks do
    if not tasks[loop].completed
      then inc(counter,seconds(tasks[loop].maxminutes));
  WriteClrEOL('Maximum'+msg1
              +NiceTimeString(counter));
end;

procedure TaskDisplay;
const
  TaskDisplayLine=1;
  commentDisplayLine=9;
  noextendmsg='This task cannot be extended';
var
  s:string;
  foomin:minute;
begin
  (* Task-specific info *)
  gotoxy(1,TaskDisplayLine);
  with tasks[curtask] do begin
    writecentered('The current task is:');
    writeln;
    changecolor(bold); writecentered(TaskName); changecolor(normal);
    writeln;
    writecentered('...which has '+nicetimestring(SecondsRemaining)+' remaining.');
    foomin:=maxminutes-(minminutes+extendedminutes);
    writecentered('You have worked '+nicetimestring(SecondsSpent)+' on this task.');
    if extendable
      then if foomin>0
        then begin
          s:='You can extend this for '+int2str(foomin)+' more minutes';
          if foomin=1 then dec(s[0]);
          writecentered(s);
        end
        else begin
          changecolor(italic);
          writecentered(noextendmsg+' further.');
          changecolor(normal);
        end
      else begin
        changecolor(italic);
        writecentered(noextendmsg+'.');
        changecolor(normal);
      end;
    if TaskComment<>'' then begin
      gotoxy(1,commentdisplayline);
      changecolor(dim);
      write(TaskComment);
      changecolor(normal);
    end;
  end;
end;

procedure UpdateVars;
(* Update the seconds passed counter and perform housekeeping *)
begin
  (* Update the totalseconds counter  *)
  if lastknownsecond<>currentsecond then begin
    lastknownsecond:=currentsecond;
    inc(totalseconds);
  (* Decrement the current task's time remaining counter  *)
    with tasks[curtask] do
      if (SecondsRemaining>0) and not Paused
        then begin
          dec(SecondsRemaining);
          inc(SecondsSpent);
        end else if not paused then beep;
  (* Update the mostly-static displays *)
    TaskDisplay;
    StatDisplay;
  end;
end;

function FirstUncompletedTask:integer;
var
  foo:integer;
  foundit:boolean;
begin
  foo:=0;
  foundit:=false;
  repeat
    if not tasks[foo].completed
      then foundit:=true
      else inc(foo);
  until foundit or (foo>=numtasks);
  if foo>=numtasks then foo:=-1;
  FirstUncompletedTask:=foo;
end;

function AllTasksCompleted:boolean;
var
  b:byte;
  completed:boolean;
begin
  (* assume all are completed and search for one that isn't *)
  completed:=true;
  for b:=0 to numtasks-1 do
    if not tasks[b].completed
      then completed:=false;
  AllTasksCompleted:=completed;
end;

Procedure ProcessUserAction(action:useractions);
var
  b:byte;
  tf:boolean;
begin
  case action of
    none:begin
    end;
    pausetask:begin
      (* Toggle paused flag *)
      if tasks[curtask].pausable
        then tasks[curtask].Paused:=not tasks[curtask].Paused;
    end;
    skiptask:begin
      if tasks[curtask].skippable
        then begin
          tasks[curtask].completed:=true;
          if not alltaskscompleted then curtask:=FirstUncompletedTask;
        end;
    end;
    defertask:begin
      if tasks[curtask].deferrable
        then begin
          (* move on... *)
          inc(curtask);
          (* handle the special case of being at the end of the tasklist *)
          if curtask>=numtasks then curtask:=0;
          (* ...and don't stop until you find one that hasn't completed yet *)
          while (tasks[curtask].completed)
            and (curtask<numtasks) do
              inc(curtask);
          if curtask>=numtasks
            then curtask:=FirstUncompletedTask;
        end;
    end;
    extendtask:begin
      (* Extend the current task by one minute *)
      if TaskExtendable(tasks[curtask])
      and not taskendedabsolute(tasks[curtask])
        then begin
          inc(tasks[curtask].secondsremaining,seconds(ExtendStep));
          inc(tasks[curtask].extendedminutes,extendstep);
        end;
    end;
    acknowledge:begin
      (* If we have more tasks, move on.  If not, end. *)
      (* But don't move if a task hasn't ended yet because we don't
         want the user to move past an unskippable task by acknowledging it *)
      if taskended(tasks[curtask])
        then begin
          tasks[curtask].completed:=true;
          if not alltaskscompleted then curtask:=FirstUncompletedTask;
        end
    end;
    quit:begin
      userexit:=true;
    end;
  end;
  if alltaskscompleted then userexit:=true;
end;

Function GetUserAction:useractions;
begin
  if keypressed
    then
      case upcase(readkey) of
        'P':GetUserAction:=PauseTask;
        'S':GetUserAction:=SkipTask;
        'D':GetUserAction:=DeferTask;
        'E':GetUserAction:=ExtendTask;
        #32:GetUserAction:=acknowledge; (* spacebar *)
        #27:GetUserAction:=quit; (* escape *)
      else
        GetUserAction:=none;
      end
    else
      GetUserAction:=none (* no keypressed, no action *)
end;

Procedure EndStatDisplay;
const
  tmsg1='ll tasks were completed!';
var
  loop:byte;
  counter:longint;
begin
  writeln('Statistics:');
  (* total time elapsed *)
  writeln('Total time elapsed: '+NiceTimeString(totalseconds));
  (* time spent on tasks *)
  counter:=0;
  for loop:=0 to numtasks do inc(counter,tasks[loop].SecondsSpent);
  writeln('Time spent on tasks: '+NiceTimeString(counter));
  (* time wasted (total minus spentontasks) *)
  writeln('Time "wasted": '+NiceTimeString(totalseconds-counter));
  if not alltaskscompleted
    then writeln('Not a',tmsg1)
    else writeln('A',tmsg1);
end;

Procedure CloseTasks;
begin
  gotoxy(1,numrows-1);
  pause;
  closevideo;
  EndStatDisplay;
end;

begin
  InitTasks;
  LoadTasks;
  if CheckOnly then exit;
  clearscr;
  repeat
    UpdateVars;
    ActionsDisplay;
    ProcessUserAction(GetUserAction);
  until UserExit;
  CloseTasks;
end.
