*  QCONFIG.WS    -- Configuration file for QEDIT2 to emulate WordStar
*
*  First Written: 29-Sep-89   Tim Farley    QEdit 2.08, QEdit OS/2 1.0
*  Last Revised:  07-Nov-89   Tim Farley    For WordStar 3.3.
*
*  ------------------------------------------------------------------------
*  NOTE:  WE RECOMMEND YOU PRINT THIS FILE OUT AND REFER TO IT AS YOU
*         RUN THE QCONFIG PROGRAM TO CONFIGURE YOUR COPY OF QEDIT.
*
*  This configuration also contains most of the Alt and Function keys
*  that QEdit uses by default (most of which are not functional in WordStar).
*
*  In addition to all original WordStar 3.3 commands, this file also
*  includes a few of Borland's "extensions" (from SideKick, Turbo environments)
*  to the WordStar command set.
*
*  NOTE:  with all the two-key WordStar commands that exist,
*         this QCONFIG file uses up all the available space in QEdit for
*         two-key commands.  If you need to define more two-keys, you will
*         have to undefine one existing one for each new one.
*
*  ------------------------------------------------------------------------
*  SEE DEFAULT QCONFIG.DAT FOR FURTHER INSTRUCTIONS ON MODIFYING THIS FILE.
*

*
* function key set
*

f1                 QuickHelp
*
* F2 & F3 are actually left margin commands in WordStar 3.3
*    These two definitions come from classic SideKick
*
f2                 SaveFile
f3                 EditFile
f4                 SetRmargin
*
* F5 & F6 are actually "underline" and "bold" in WordStar 3.3
*
f5                 MakeTopOfScreen
f6                 DelToEol
f7                 MarkBlockBegin
f8                 MarkBlockEnd
f9                 BegFile
f10                EndFile

* enhanced keyboard only
f11
f12

#f1                ToggleBoxDraw
#f2
#f3                Sort
#f4
#f5                MakeCtrOfScreen
#f6
#f7                ShiftLeft
#f8                ShiftRight
#f9                Shell
#f10

* enhanced keyboard only
#f11
#f12

^f1                ToggleEGA43
^f2
^f3
^f4
^f5
^f6
^f7
^f8
^f9
^f10

* enhanced keyboard only
^f11
^f12

@f1                ToggleBoxType
@f2                InsertLine
@f3                Match
@f4
@f5                ScreenLeft
@f6                ScreenRight
@f7
@f8
@f9                Dos
@f10               ShowEntryScreen

* enhanced keyboard only
@f11
@f12

*
* special keys
*

cursorup           CursorUp
cursordown         CursorDown
cursorleft         CursorLeft
cursorright        CursorRight
^cursorleft        WordLeft
^cursorright       WordRight
*
* You might prefer BegLine and EndLine for the next two
*
home               MacroBegin BegLine BegScreen
end                EndScreen
^home              BegScreen
^end               EndScreen
pgup               PageUp
pgdn               PageDown
^pgdn              EndFile
^pgup              BegFile

#tab               TabLt
tab                TabRt

ins                ToggleInsert

*
*  NOTE:  True *original* WordStar users will know that the following
*         three definitions are not the original ones.
*         These are the conventional "DOS" and QEdit definitions.
*
*         If you would prefer the WordStar originals, change the next
*         three definitions to the following:
*
*               del          Backspace
*               backspace    Cursorleft
*               ^backspace   Backspace
*
del                DelCh
backspace          Backspace
^backspace         DelLtWord

enter              Return
^enter             ExecuteScrap

escape             Escape

grey*              Paste
grey+              Copy
grey-              Cut
#del
#ins
`
~
/

^prtsc             PasteOver
^2
^6
^[
^\
*
* Macro to edit the file whose name is sitting at the cursor in the editor
*
^]                 MacroBegin AltWordSet MarkWord Copy DefaultWordSet EditFile Paste Return
^-                 Backspace

*
* alternate keys
*

@a                 DropAnchor
*
* These next three start with Control-B in the default.
* We make them Alt-B to free up Control-B for WrapPara.
*
@b_a               AppendScrBuff
@b_l               GetScrBuff
@b_s               StoreScrBuff
@c                 CopyBlock
@d                 DelLine
@e                 EditFile
@f                 MacroBegin MainMenu 'f'
@g                 DeleteBlock
@h                 QuickHelp
@i                 ToggleTabsOut
@j                 JoinLine
@k                 MarkColumn
@l                 MarkLine
@m                 MoveBlock
@n                 NextFile
@o                 ChangeFilename
@p                 MacroBegin MainMenu 'p'
@q                 MacroBegin MainMenu 'q'
@r                 ReadBlock
@s                 SplitLine
@t
@u                 UnmarkBlock
@v                 ToggleTabsExpand
@w                 WriteBlock
@x                 GExit
@y                 GSave
@z                 CopyOverBlock
@1                 Upper
@2                 Lower
@3                 Flip
@4
@5
@6
@7
@8
@9
@0
@-
@=                 MacroBegin MarkWord Copy Find Paste Return Return

*
* control keys
*


^a                 WordLeft
^b                 WrapPara
^c                 PageDown
^d                 CursorRight
^e                 CursorUp
^f                 WordRight
^g                 DelCh
*
* You might prefer "Backspace" for the following key:
*
^h                 CursorLeft
^i                 TabRt
^j                 QuickHelp
^k_b               MarkBlockBegin
^k_c               CopyBlock
^k_d               File
*
* ^KE lets you rename an arbitrary file in WordStar.  Here we let you
*    rename THIS file.
*
^k_e               ChangeFilename
*
* Can't display directory while editing, so we put EditFile here.
*    You can get a directory display from it.
*
^k_f               EditFile
^k_h               UnmarkBlock
*
* This is a Borland environment definition
*
^k_i               ShiftRight
*
* NOTE:  This kills the *current* file on disk in QEdit, while in WordStar
*        it prompts you for what file to kill.
*
^k_j               KillFile
^k_k               MarkBlockEnd
*
* ^KL (changed logged disk) has no equivalent in QEdit
*
^k_l
*
* ^KN should be "toggle column block", but QEdit doesn't do that
*
^k_n               NextFile
*
* ^KO (copy a file) could be done with a macro in QEdit
*
^k_o
*
* ^KP is close to PrintAll in original WordStar, but PrintBlock is safer
*
^k_p               PrintBlock
^k_q               PQuit
^k_r               ReadBlock
^k_s               SaveFile
^k_t               MarkWord
*
* This is a Borland environment definition
*
^k_u               ShiftLeft
^k_v               MoveBlock
^k_w               WriteBlock
^k_x               GFile
^k_y               DeleteBlock
^k_z               KillFile
^l                 RepeatFind
*
* Ctrl-M should be synonymous with Return, but we'll bow to QEdit's convention
*
^m                 MacroRecord
^n                 SplitLine
*
* ^OC is "center line" in WordStar
*
^o_c               CloseWindow
*
* ^OD is "display print codes" which QEdit doesn't have
*
^o_d
*
* ^OE is "toggle soft hyphen" which QEdit doesn't have
*
^o_e
*
* ^OF is "ruler from line".  We just let you set right margin.
*    The Borland environment definition would be "ToggleTabsOut"
*
^o_f               SetRMargin
*
* ^OH is "toggle hyphen help" which QEdit doesn't have
*
^o_h
*
* ^OG is "paragraph indent" which QEdit doesn't have
*
^o_g
^o_h               HorizontalWindow
^o_i               SetCtabWidth
*
* ^OJ is "toggle justification" which QEdit doesn't have
*
^o_j
^o_l               SetPrintLeftMargin
*
* ^ON is "clear tabs" in WordStar.  QEdit doesn't have that
*
^o_n               NextWindow
^o_o               OneWindow
*
* ^OP is "toggle page break" in WordStar
*
^o_p               PrevWindow
^o_g               GrowWindow
^o_r               SetRMargin
*
* ^OS is "set line spacing" in WordStar
*
^o_s               ShrinkWindow
*
* ^OT is "toggle ruler line" which QEdit doesn't have
*     ToggleSmartTabs is Borland's definition for this key.
*
^o_t               ToggleSmartTabs
*
* ^OV is "toggle variable tabs".  We make that SmartTabs, which is close.
*
^o_v               ToggleSmartTabs
^o_w               ToggleWordWrap
*
* ^OX is "release margins" which QEdit doesn't have
*
^o_x
^o_z               ZoomWindow
^p                 Literal
^q_a               FindReplace
^q_b               GotoBlockBeg
^q_c               EndFile
^q_d               EndLine
^q_e               BegScreen
^q_f               Find
^q_i               ToggleIndent
^q_k               GotoBlockEnd
^q_l               UndoCursorline
*
* ^QO is a SideKick extension.  This definition is not quite
*    exactly what SideKick does, but close.
*
^q_o               InsertDate
^q_p               PrevPosition
*
* ^QQ (repeat following command) has no equivalent in QEdit
*
^q_q
^q_r               BegFile
^q_s               BegLine
*
* ^QT is a SideKick extension.  This definition are not quite
*    exactly what SideKick does, but close.
*
^q_t               InsertTime
*
* ^QV does "Last Find" in WordStar.  This is pretty close.
*
^q_v               PrevPosition
*
* ^QW (continuous scroll down) has no equivalent in QEdit
*
^q_w
^q_x               EndScreen
^q_y               DelToEol
*
* ^QZ (continuous scroll up) has no equivalent in QEdit
*
^q_z
*
* The following two are actually "delete to begin of line", but this is
* close as we can come, since we can't do macros on two-keys.
*
^q_del             DelLtWord
^q_^-              DelLtWord
*
* The following two are from Borland's environments
*
^q_^[              Match
^q_^]              Match

^r                 PageUp
^s                 CursorLeft
^t                 DelRtWord
^u                 UnKill
^v                 ToggleInsert
^w                 ScrollUp
^x                 CursorDown
^y                 DelLine
^z                 ScrollDown

*
* other enhanced only keys
*
@'
@,
@.
@/
@;
@[
@\
@]
@`
@backspace
@enter
@escape
@grey*
@grey+
@grey-
@grey/
@greycursordown
@greycursorleft
@greycursorright
@greycursorup
@greydel
@greyend
@greyhome
@greyins
@greypgdn
@greypgup
@greyenter
@tab

greyenter          Return
^greyenter         ExecuteScrap
^centercursor
^cursordown        LineDown
^cursorup          LineUp
^del

^grey*
^grey+
^grey-
^grey/
^ins
^tab

centercursor

*
* EOF: QCONFIG.WS
*
