/********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0a  1.44mb Disks
 * Copyright (C) 1992 - 1995 Adobe Systems Inc.  All rights reserved.
 * Control file administrator: Frederick LLoyd
 ********************************************************************/

PRODUCT "PageMaker 6.0"	{}

VERSIONREQ "3.0"

/*************************/
/** Dialog definitions	**/

DIALOG MinCPURequired "&OK"
{
	CAPTION "CPU Requirements"
	TEXT
	{
	"Unable to install Adobe PageMaker 6.0. Minimum configuration "
	"requires a 486 processor or greater."
	}
}

DIALOG MinRAMRequiredWin95 "&OK"
{
	CAPTION "RAM Memory Requirements"
	TEXT
	{
	"Unable to install Adobe PageMaker 6.0. Minimum memory requirement "
	"for operating under Windows 95 is 8 megabytes of RAM."
	}
}

DIALOG MinRAMRequiredWin32s "&OK"
{
	CAPTION "RAM Memory Requirements"
	TEXT
	{
	"Unable to install Adobe PageMaker 6.0. Minimum memory requirement "
	"for operating under Windows 3.x is 10 megabytes of RAM."
	}
}
/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
	GETCPUTYPE	CpuType

	IF CpuType EQS "I386"
	{
		DISPLAY MinCPURequired
		EXIT
	}

	GETOPSYS	O_System

	IF O_System EQS "Win95"
	{
		GETRAMMEMORY	"8" TotalResult ""
		IF TotalResult EQS "FALSE"
		{
			DISPLAY MinRAMRequiredWin95
			EXIT
		}
	}

	IF O_System EQS "Win32s"
	{
		GETRAMMEMORY	"8"  TotalResult ""
		IF TotalResult EQS "FALSE"
		{
			DISPLAY MinRAMRequiredWin32s
			EXIT
		}
	}

	BTNCHOICEDLG 3 "Language Choice" "Choose the language version you wish to install." "U.S. English" "Canadian English" "International English" "" "" LangChoice

	IF LangChoice EQS "1"
	{
		LOADRESOURCE "aldlang.dll"
		EXECCTLFILE  "NET\ADMIN_US.144"
	}
	IF LangChoice EQS "2"
	{
		LOADRESOURCE "engsetup.dll"
		EXECCTLFILE  "NET\ADMIN_CE.144"
	}
	IF LangChoice EQS "3"
	{
		LOADRESOURCE "engsetup.dll"
		EXECCTLFILE  "NET\ADMIN_IE.144"
	}
	EXIT
}

