# Makefile for DDE Library and Sample AutoCAD/ADS Programs
# Tested with Microsoft C 6.0AX and the Microsoft Windows 3.0 Toolkit
#
#     Compiler flags
# -Zi => create object file for use with CodeView
# -Od => disable code rearrangement optimization for debugger
# -AL => Large model (large code, large data) 
# -G2 => use 80286 instructions
# -Gs => turn off stack checking
# -Zp => pack structure data on byte boundries
# -Zl => no default libraries
# -W2 => 2nd level warning messages
# -FPi87 => inline 80x87 code
# -D  => Define variable for #ifdef tests
#     Link flags
# /F /PACKC /PACKD => speed optimization for 286/386
# /CO => Codeview debugging
# /NOD => Specify standard library

# ADS directory
ADS = ..
AOBJ = $(ACOBJ)\ads
WAOBJ = $(AOBJ)\winads.obj ddeconv.obj

WLIB = ddeml llibcew libw

CFLAG = -c -AL -G2sw -Zp -FPi87 -DWIN -I$(ADS) -EM
DFLAG = -Od -Zi -DCV
LFLAG = /NOD /NOE

# Debugging ON
CFLAGS = $(CFLAG) $(DFLAG)
LF = /CO $(LFLAG)

# Release version, debugging OFF
#CFLAGS = $(CFLAG)
#LF = $(LFLAG)

LIBS = dde.lib $(AOBJ)\winads $(WLIB)

LIBOBJ = spreadsh.obj ddewin.obj winutil.obj

# Targets
all: ddetest.exe ddelisp.exe shaft.exe

#
# Compile DDE Library and Sample Programs
#

ddetest.obj: ddetest.c ddewin.h options.h spreadsh.h

winutil.obj: winutil.c options.h

ddelisp.obj: ddelisp.c ddewin.h options.h spreadsh.h ddeconv.h

shaft.obj: shaft.c ddewin.h options.h spreadsh.h

spreadsh.obj: spreadsh.c ddewin.h options.h

ddeconv.obj: ddeconv.c options.h ddewin.h options.h spreadsh.h

ddewin.obj: ddewin.c ddewin.h options.h


#
# Link Sample Programs
#


ddetest.exe: ddetest.obj spreadsh.obj winutil.obj dde.lib ddetest.lnk

ddelisp.EXE: $*.obj $(WAOBJ) dde.lib $(AOBJ)\winads.lib ddelisp.lnk

shaft.EXE: $*.obj $(WAOBJ) dde.lib $(AOBJ)\winads.lib shaft.lnk

#
# Create DDE.LIB
#

Dde.lib: $(LIBOBJ) 
        if exist dde.lib del dde.lib
        lib dde.lib $(LIBOBJ), dde.map;

#
# Create Link Files
#

ddetest.lnk: dde
        echo $(LF) + >$*.lnk
        echo $* >>$*.lnk
        echo $*.exe, $*.map, >>$*.lnk
        echo dde.lib $(WLIB), $*.def; >>$*.lnk
        link @$*.lnk
        rc -t $*.rc $*.exe

ddelisp.lnk: dde
        echo $(LF) + >$*.lnk
        echo $* $(WAOBJ) >>$*.lnk
        echo $*.exe, $*.map, >>$*.lnk
        echo $(LIBS), $*.def; >>$*.lnk
        link @$*.lnk
        rc -t -k $*.rc $*.exe

shaft.lnk: dde
        echo $(LF) + >$*.lnk
        echo $* $(WAOBJ) >>$*.lnk
        echo $*.exe, $*.map, >>$*.lnk
        echo $(LIBS), $*.def; >>$*.lnk
        link @$*.lnk
        rc -t $*.rc $*.exe


.c.obj:
        cl $(CFLAGS) $*.c

.obj.exe:
        link @$*.lnk
        rc $*.rc $*.exe


