/*

    DdeTest

    A DDE Test Program by Autodesk, Inc. (1991).

    This is to be used to test sending and receiving data from another
    Windows application via DDE.
*/

/*
See "Dde.DOC".
*/



#include "options.h"

#include <stdio.h>
#include <math.h>

#include "adslib.h"    

#include <process.h>
#include <string.h>
#include <memory.h>
#include <dos.h>
#include <ctype.h>

#include "winutil.h"
#include "ddewin.h"
#include "ddeconv.h"
#include "spreadsh.h"
#include "ddetest.h"




DDEDATA *pDdeData = NULL;
PDDE pdde = NULL;
static char progname[] = "DdeTest";

#ifdef EXCEL
static char ddeapp[] = "Excel";       /* Defaults */
static char ddetopic[] = "Sheet1";
#else
static char ddeapp[] = "123w";       /* Defaults */
static char ddetopic[] = "Untitled";
#endif

int row = 1;
char item[25];
char datastr1[256] = 
"Testing DDE Poke strings that are large enough to fill up 80 characters......";
#define COL1  1
#define NCOLS 3
char datastr[101] = 
"1.11111\t2.22222\t3.33333\r\n" \
"4.44444\t5.55555\t6.66666\r\n" \
"7.77777\t8.88888\t9.99999\r\n" \
"11.1111\t22.2222\t33.3333\r\n"; 
#define DATASTRLEN (sizeof(datastr)-1)
char databuf[4096];
int datalen, rows;

char execstr[] = 
"[SELECT(\"R1C1\")][FORMULA(\"AutoCAD Graphics Data\")]";

HANDLE hInst;                       /* current instance                      */


/* All Function Prototypes for ddetest.c */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                                        LPSTR lpCmdLine, int nCmdShow);
BOOL InitApplication(HANDLE hInstance);
BOOL InitInstance(HANDLE hInstance, int nCmdShow);
long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam, 
        LPARAM lParam);
BOOL FAR PASCAL About(HWND hDlg, UINT message, WPARAM wParam, 
        LPARAM lParam);






int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                                        LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                                 /* message                      */

    if (!hPrevInstance)                  /* Other instances of app running? */
        if (!InitApplication(hInstance)) /* Initialize shared things */
            return (FALSE);              /* Exits if unable to initialize     */

    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg, NULL, NULL, NULL)) {
        TranslateMessage(&msg);    /* Translates virtual key codes           */
        DispatchMessage(&msg);     /* Dispatches message to window           */
    }
    return (msg.wParam);           /* Returns the value from PostQuitMessage */
}



BOOL InitApplication(hInstance)
HANDLE hInstance;                              /* current instance           */
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;                    /* Class style(s).                    */
    wc.lpfnWndProc = MainWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance, "DDEICON");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "DdetestMenu";   /* Name of menu resource in .RC file. */
    wc.lpszClassName = "DdetestWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));
}



BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;          /* Current instance identifier.       */
    int             nCmdShow;           /* Param for first ShowWindow() call. */
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = CreateWindow(
        "DdetestWClass",                /* See RegisterClass() call.          */
        "Ddetest Sample Application",   /* Text for window title bar.         */
        WS_OVERLAPPEDWINDOW,            /* Window style.                      */
        CW_USEDEFAULT,                  /* Default horizontal position.       */
        CW_USEDEFAULT,                  /* Default vertical position.         */
        CW_USEDEFAULT,                  /* Default width.                     */
        CW_USEDEFAULT,                  /* Default height.                    */
        NULL,                           /* Overlapped windows have no parent. */
        NULL,                           /* Use the window class menu.         */
        hInstance,                      /* This instance owns this window.    */
        NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!hWnd)
        return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}


long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam,
        LPARAM lParam)
{
    FARPROC lpProcAbout;                  /* pointer to the "About" function */
    char buf[80];
    int total;
    char *ptr; 
    char item[25];

    switch (message) {
        case WM_CREATE:
            pDdeData = DdeInit(progname, hInst, NULL);
            assert(pDdeData != NULL);
            total = 0;
            ptr = databuf;
            for (rows = 0; ; ++rows) {
                if (total + DATASTRLEN < sizeof(databuf)) {
                    memcpy(ptr, datastr, DATASTRLEN);
                    ptr += DATASTRLEN;
                    total += DATASTRLEN;
                } else
                    break;
            } 
            *ptr = EOS;
            datalen = strlen(databuf);
            sprintf(buf, "Test string length: %d", datalen);
            /* MsgBox("DDE Data", buf); */
            break;

        case WM_COMMAND:           /* message: command from application menu */
            switch (wParam) {
            int loop;
            case IDM_LINK:
                pdde = DdeDlgStart(hWnd, FALSE);
                /* pdde = DdeInitiate(ddeapp, ddetopic); */
                if (pdde == NULL) {
                    sprintf(buf, "Error connecting to %s|%s", 
                        pDdeData->app, pDdeData->topic);
                    MsgBox("DDE Link", buf);
                } else {
                    strcpy(ddeapp, pdde->app);
                    strcpy(ddeapp, pdde->topic);
                }
                break;

            case IDM_POKE:
                if (pdde == NULL)
                    break;
                for (loop = 1; loop <= 10; ++loop) {
                    CellRange(item, row, COL1, rows, NCOLS);
                    DdePokeString(pdde, item, databuf);
                    row += rows;
                }
                break;
      
            case IDM_REQUEST:
                if (pdde == NULL)
                    break;
                DdeReqString(pdde, item);
                MsgBox("Request Data", pdde->pData);
                DdeFreeData(pdde);
                break;
       
            case IDM_EXECUTE:
                if (pdde == NULL)
                    break;
                DdeExec(pdde, execstr);
                break;
                            
            case IDM_ABOUT:
                lpProcAbout = MakeProcInstance(About, hInst);
                DialogBox(hInst,                 /* current instance         */
                    "AboutBox",                  /* resource to use          */
                    hWnd,                        /* parent handle            */
                    lpProcAbout);                /* About() instance address */

                FreeProcInstance(lpProcAbout);
                break;

            default:
                                    /* Lets Windows process it       */
                return (DefWindowProc(hWnd, message, wParam, lParam));
            }
            break;

        case WM_DESTROY:                  /* message: window being destroyed */
            DdeQuit();
            PostQuitMessage(0);
            break;

        default:                          /* Passes it on if unproccessed    */
            return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}



BOOL FAR PASCAL About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        case WM_INITDIALOG:                /* message: initialize dialog box */
            return (TRUE);

        case WM_COMMAND:                      /* message: received a command */
            if (wParam == IDOK                /* "OK" box selected?          */
                || wParam == IDCANCEL) {      /* System menu close command? */
                EndDialog(hDlg, TRUE);        /* Exits the dialog box        */
                return (TRUE);
            }
            break;
    }
    return (FALSE);                           /* Didn't process a message    */
}

