/*

    DdeBlank

    A Windows/ADS Application Starting Point

    This is to be used as a starting point, or skeleton, for new
    Windows ADS programs using DDE.  Substitute 
    new functions for "sample" and "listconst" below.

    The DdeCallback function below illustrates a way to use
    ADS as a DDE Server.  

    Commands:

        SAMPLE          Displays message in the AutoCAD text window.
        LISTCONST       List all blocks with constant attributes


*/
/*
See "Dde.TXT".
*/

#include "options.h"
#include "adslib.h"    

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>

#include "winutil.h"
#include "ddewin.h"
#include "windde.h"
#include "ddeconv.h"
#include "spreadsh.h"
#include "acaddefs.h"

#define SERVER_EXAMPLE 1              /* Include DDE server example */  


ddeDATA *pDdeData;

#ifdef SERVER_EXAMPLE
HSZ hszTestTopic;                     /* Handle to our DDE server topic 
                                         that client apps can use to 
                                         start a conversation with us. */       
int iClients = 0;
#endif

/* DDE Application */
char Application[MAXNAME+1] = "Excel"; /* Default application name */
char WorkFile[MAXNAME+1] = "shaft.xls"; /* Default work file name */
char AppStart[MAXPATH+1] = "c:\\excel\\excel.exe";
                                       /* Auto start up command line */ 


/* All Function Prototypes for ddeblank.c */

void main(int argc, char **argv);
static short funcload(void);
HDDEDATA DdeCallback(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2,
    HDDEDATA hdata, DWORD dwData1, DWORD dwData2);
static int sendAcad(char *func);

static void sample(void);
static void listconst(void);


/* Table of AutoCAD function (or command) names
   and corresponding C function name 
*/
CMDTAB cmdtab[] = {
    /*   Name    Function  */
    {"C:sample", sample},   
    {"C:LISTCONST", listconst},   
    };




/*

                  DdeBlank Main

*/



void main(int argc, char **argv)
{
    short scode = RSRSLT;
    short cindex;
    short ads_req; 

    /* Initialize DDE Manager with the program name and  
       the instance handles.  */

    pDdeData = DdeInit(adsw_AppName, adsw_hInstance, adsw_idInst);
    DdeDefaults(Application, WorkFile, AppStart);  /* Optional */       

#ifdef SERVER_EXAMPLE
    /* Accept DDE requests on the application "DdeBlank" and the 
       topic "TestTopic" */
    hszTestTopic = DdeCreateStringHandle(adsw_idInst, "TestTopic", CP_WINANSI);

#endif  /* SERVER_EXAMPLE */

    ads_init(argc, argv); 


    for ( ;; ) {

        /* This process will block (stop) here until AutoCAD has a 
           request for us */

        ads_req = ads_link(scode);        
        if (ads_req < 0)
            break;

        scode = RSRSLT;               /* default return code */

        /* Check for AT LEAST the following cases here */
        switch (ads_req) { 

        case RQXLOAD:          /* Load request. Send function names. */
            scode = -(funcload() ? RSRSLT : RSERR);
            break;

        /* Execute a "loaded" function that was defined via RQXLOAD */
        case RQSUBR:
            cindex = ads_getfuncode();

            if (cindex >= 0 && cindex < ELEMENTS(cmdtab))
                (*cmdtab[cindex].cmdfunc)();

            break;

        /* (xunload "adsw_AppName") entered or called in AutoCAD */ 
        case RQXUNLD:      
            /* Free up all memory allocated by DDE system.  Send 
               TERMINATE messages to open channels. */
            DdeQuit();
#ifdef SERVER_EXAMPLE
            DdeFreeStringHandle(adsw_idInst, hszTestTopic);
#endif
            break;

        default:
            break;
        }
    }           /* end of ADS loop */

}





/* Register our functions with the ADS system.  Also,
   any drawing initialization can go here, since this is
   called with each new drawing. 
*/
static short funcload(void)
{
    int idx;
    char *cname;

    for (idx = 0; idx < ELEMENTS(cmdtab); ++idx) {
        cname = cmdtab[idx].cmdname;
        ads_defun(cname, (short)idx);
    }

    SetFlatLand();                    /* set local flatland variable, for 
                                         dxftype function. */
    return TRUE;
}


#ifdef SERVER_EXAMPLE


/* 


                D D E    S e r v e r    E x a m p l e


*/



/* The following function will be called if another application
   creates a DDE link to DdeBlank on the application name 
   "DdeBlank" and the topic "TestTopic" (see above) and then
   sends a DDE request for data or an execute message.  We 
   just return the item name for requested data, or pass
   the command on to AutoCAD if it's an EXECUTE message. 
   A useful application would return something of value in
   ret_data; we're just testing the transfer functionality 
   and providing a framework for convenient expansion. */

HDDEDATA 
DdeCallback(UINT uType, UINT uFmt, HCONV hconv, HSZ hszTopic, HSZ hszItem,
    HDDEDATA hdata, DWORD dwData1, DWORD dwData2)
{
    HDDEDATA hData = (HDDEDATA)0;  
    char exec[256] = "";
    char item[35] = "";
    char ret_data[100];

    /* Is this our topic? */
    if (DdeCmpStringHandles(hszTopic, hszTestTopic) != 0) 
        return 0;                     /* For XTYP_CONNECT, 0 ret means we 
                                         don't accept request to connect */

    /* We're only responding to some DDE messages */
    switch (uType) {
    case XTYP_CONNECT:
        /* Accept the request to connect. */
        hData = TRUE;
        break;

    case XTYP_REQUEST:
        /* Only allow transactions on the formats we support */
        if (uFmt != CF_TEXT)
            break;                    /* illegal format. */
        /* Get string from hszItem into "item".  This identifies
           on what the client wants data.  The meaning of this
           item is application defined.  For spreadsheets it's
           the row and column or range of rows and columns. */
        DdeQueryString(adsw_idInst, hszItem, (LPSTR)&item,                   
                sizeof(item)-1, CP_WINANSI);

        /*_____________________________________________

           Create a handle to return data.  Substitute 
           something useful for "ret_data" below. 
        _______________________________________________*/

        sprintf(ret_data, "DdeBlank: item %s", item);
        hData = DdeCreateDataHandle(adsw_idInst,
                        (LPBYTE)ret_data, 
                        strlen(ret_data)+1, 
                        0L, 
                        hszItem, 
                        CF_TEXT,
                        0);
        break;

    case XTYP_EXECUTE:
        /* Get execute string from hData. */
        DdeGetData(hdata, exec, sizeof(exec), 0);
        /* Interrupt AutoCAD with this command */
        sendAcad(exec);
        hData = (HDDEDATA)TRUE;
        break;

    case XTYP_CONNECT_CONFIRM:
        /* We have a conversation now. */
        ++iClients;
        break;

    case XTYP_DISCONNECT:
        /* Client is disconnecting. */
        --iClients;
        break;

    default:
        break;
    }

    /* For the EXECUTE message... */    
    if ((uType & XCLASS_MASK) == XCLASS_FLAGS)
        return hData ? DDE_FACK : DDE_FNOTPROCESSED;
    return hData; 
} 


/* Send command such as "erase " to "interrupt" AutoCAD
   to perform command. */
static int sendAcad(char *func)
{
    /* Interrupt AutoCAD to execute our function */
    if (func && *func) {
        DdeSendAcadCmd(func);
    }
    return 0;
}

#endif  /* SERVER_EXAMPLE */


static void sample(void)
{
    ads_printf("ADS DdeBlank function \"sample\" A-OK.\n");
}


/* Sample function to be replaced by a real Windows ADS function 
   by ADS developers. */

static void listconst(void)
{
    BlkList *blkList = NULL;
    BlkList *blkLink;
    BlkAttr *attrLink;

    /* Create a list of block symbol table names and the constant 
       data values therein. */
    CreateConstList(&blkList);
    if (blkList != NULL) {
        ads_printf("Block Constant Attribute Data\n");
        for  (blkLink = blkList; blkLink != NULL; blkLink = blkLink->next) {
            ads_printf("%s\n", blkLink->block);
            for  (attrLink = blkLink->attrlist; attrLink != NULL; 
                                                attrLink = attrLink->next) {
                if (attrLink->handle)
                    ads_printf("    %s\n", attrLink->handle);
                if (attrLink->tag)
                    ads_printf("    %s\n", attrLink->tag);
                if (attrLink->value)
                    ads_printf("    %s\n", attrLink->value);
                ads_printf("\n");
            }
        }
    }
    FreeConstList(&blkList);
}



/* end of file */
