/* 
    MFCWND.CPP -
    
    This file:

        Defines CWINDOW that contains a CListBox and a CStatic.

    ( C ) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  ( i. ) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    ( ii. )  contain  Autodesk's  copyright  notice  "( C )  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "mfclist.h"

/******************************************************************************
*                                                                             *
*                            CWINDOW member functions                         *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
// The window's constructor
CWINDOW::CWINDOW()
{ 
    CRect rect;

    Create( NULL
            , "ADS MFCList Demo"
            , WS_OVERLAPPEDWINDOW
            , CRect( 0,0,250,100 ) ); 
    
    GetClientRect( &rect );
    rect.bottom -= 24;
    list = new CListBox();
    list->Create( WS_CHILD | WS_VISIBLE|WS_BORDER 
                    | WS_VSCROLL | WS_HSCROLL | LBS_NOINTEGRALHEIGHT
                    | LBS_NOTIFY | LBS_EXTENDEDSEL
                  , rect
                  , this
                  , LIST );

    GetClientRect( &rect );
    rect.top = rect.bottom - 24;        
    label = new CStatic();
    label->Create( "xxx"
                , WS_CHILD | WS_BORDER | WS_VISIBLE
                , rect
                , this
                , LABEL );

    entity_name[ 0 ] = 0;
    entity_name[ 1 ] = 0;
    // Fill the list
    ads_name    ename;

    if ( ads_entnext( NULL, ename ) != RTERROR )
    {
        do
        {
            struct resbuf *rb;
            rb = ads_entget( ename );

            ADS_ENT_OBJ* temp_obj = MakeAdsEntity( rb );
            if ( temp_obj != 0 )
            {
                char s[100];
                temp_obj->GetEntityName( s, 100 );
                list->AddString( s );
                DeleteAdsEntity( temp_obj );
            }
            ads_relrb( rb );
        }
        while ( ads_entnext( ename, ename ) != RTERROR );
    }
}

//-----------------------------------------------------------------------------
CWINDOW::~CWINDOW()
{
    delete list;
    delete label;
}

//-----------------------------------------------------------------------------
// The message map
BEGIN_MESSAGE_MAP( CWINDOW, CFrameWnd )
    ON_WM_SIZE()
    ON_LBN_SELCHANGE( LIST, HandleSelchange )
    ON_LBN_DBLCLK( LIST, HandleDblclk )
END_MESSAGE_MAP()

//-----------------------------------------------------------------------------
// Handle resize events
void CWINDOW::OnSize( UINT nFlags, int cx, int cy )
{
    CRect rect;
    
    GetClientRect( &rect );
    rect.bottom -= 24;
    list->MoveWindow( rect );
    
    GetClientRect( &rect );
    rect.top = rect.bottom - 24;
    label->MoveWindow( rect );        
}

//-----------------------------------------------------------------------------
// Handle selections
void CWINDOW::HandleSelchange()
{
    int i, *a;
    i = list->GetSelCount();
    a = new int[i];
    list->GetSelItems( i,a );

    char s[100];
    int x;
    ostrstream ostr( s,100 );
    for ( x=0; x<i; x++ )
    {
        ostr << a[x] << " ";
    }
    ostr << ends;
    SetDlgItemText( LABEL, s );

    delete a;
}

//-----------------------------------------------------------------------------
// Handle double clicked items
void CWINDOW::HandleDblclk()
{
    int i = list->GetCurSel();

    char s[100];
    list->GetText( i,s );

    SetDlgItemText( LABEL, s );
    Str2AdsName( entity_name, s );

    ( DDE_GLOBAL::acad_connection )->ExcuteCommand( "GetSelectedEntity\n" );
}

