/* 
    EDTDIAL.H -
    
    This file:

        Declare different dialog boxes that are used to represent
        different ADS C++ entities.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef EDTDIAL_H
#define EDTDIAL_H

#include "adsinc.h"
#include "mfcads.h"

//-----------------------------------------------------------------------------
// Available dialog boxes:
//
struct CENTITYDIALOG;
struct CLINEDIALOG;
struct CCIRCLEDIALOG;

/******************************************************************************
*                                                                             *
*                    CENTITYDIALOG class                                      *
*                                                                             *
******************************************************************************/
struct CENTITYDIALOG : CDialog
{
                    CENTITYDIALOG( ads_name _ent_name
                                , UINT template_id
                                , CWnd *pParent = NULL );
    virtual BOOL    OnInitDialog();
    virtual BOOL    SetEntityItems( ADS_ENT_OBJ* ads_ent ) = 0;

protected:
    ads_name        ent_name;
private:
    BASIC_CPP_STUFF( CENTITYDIALOG )
};

/******************************************************************************
*                                                                             *
*                      CLINEDIALOG class                                      *
*                                                                             *
******************************************************************************/
struct CLINEDIALOG : CENTITYDIALOG
{
                    CLINEDIALOG( ads_name line_name
                                , CWnd *pParent = NULL );
    virtual BOOL    SetEntityItems( ADS_ENT_OBJ* ads_ent );
private:
    BASIC_CPP_STUFF( CLINEDIALOG )
};

/******************************************************************************
*                                                                             *
*                    CCIRCLEDIALOG class                                      *
*                                                                             *
******************************************************************************/
struct CCIRCLEDIALOG : CENTITYDIALOG
{
                    CCIRCLEDIALOG( ads_name ent_name
                                    , CWnd *pParent = NULL );
    virtual BOOL    SetEntityItems( ADS_ENT_OBJ* ads_ent );
private:
    BASIC_CPP_STUFF( CCIRCLEDIALOG )
};

//-----------------------------------------------------------------------------
CENTITYDIALOG*  MakeEntityDialog( ads_name& temp_ent_name );
void            DeleteEntityDialog( CENTITYDIALOG* dialog );

#endif
