/* 
    EDTDIAL.CPP -
    
    This file:

        Define different dialog boxes that are used to represent
        different ADS C++ entities.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "mfclist.h"

//-----------------------------------------------------------------------------
static char temp_buf[ 256 ];

//-----------------------------------------------------------------------------
CENTITYDIALOG*  MakeEntityDialog( ads_name& temp_ent_name )
{
    struct resbuf *rb = ads_entget( temp_ent_name );
    ADS_ENT_OBJ *ads_ent = MakeAdsEntity( rb );

    //
    // temp. need help, TBD
    ads_ent->WhoAmI( temp_buf );
    CENTITYDIALOG *ret_val = NULL;
    if ( strcmp( temp_buf, "ADS_LINE" ) == 0 )
    {
        ret_val = new CLINEDIALOG( temp_ent_name );
    }
    else if ( strcmp( temp_buf, "ADS_CIRCLE" ) == 0 )
    {
        ret_val = new CCIRCLEDIALOG( temp_ent_name );
    }
    else
    {
        // Need more dialogs!
        ret_val = NULL;
    }

    DeleteAdsEntity( ads_ent );
    return ret_val;
}

//-----------------------------------------------------------------------------
void            DeleteEntityDialog( CENTITYDIALOG* dialog )
{ 
    delete dialog; 
}

/******************************************************************************
*                                                                             *
*                    CENTITYDIALOG class                                      *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
CENTITYDIALOG::CENTITYDIALOG( ads_name _ent_name, UINT template_id, CWnd *pParent )
                            : CDialog( template_id, pParent )
{
    ent_name[ 0 ] = _ent_name[ 0 ];
    ent_name[ 1 ] = _ent_name[ 1 ];
}

//-----------------------------------------------------------------------------
BOOL    
CENTITYDIALOG::OnInitDialog()
{
    if ( CDialog::OnInitDialog() )
    {
        struct resbuf   *rb;
        rb = ads_entget( ent_name );

        ADS_ENT_OBJ *ads_ent = MakeAdsEntity( rb );

        // Set the common items
        ads_ent->GetEntityName( temp_buf, sizeof( temp_buf ) );
        SetDlgItemText( IDC_ENTITY_NAME, temp_buf );

        SetEntityItems( ads_ent );

        DeleteAdsEntity( ads_ent );
        return TRUE;
    }
    return FALSE;
}
/******************************************************************************
*                                                                             *
*                      CLINEDIALOG class                                      *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
CLINEDIALOG::CLINEDIALOG( ads_name line_name
                        , CWnd *pParent ) 
                    : CENTITYDIALOG( line_name, LINE_DIALOG, pParent )
{
}

//-----------------------------------------------------------------------------
BOOL    
CLINEDIALOG::SetEntityItems( ADS_ENT_OBJ* ads_obj )
{
    ASSERT( ads_obj != NULL );

    ads_obj->WhoAmI( temp_buf );
    if ( strcmp( temp_buf, "ADS_LINE" ) != 0 )
    {
        return FALSE;
    }
    ADS_LINE    *line_ent = ( ADS_LINE* )ads_obj;

    ads_point temp_point;

    line_ent->GetPrimary( temp_point );
    Double2Str( temp_buf, temp_point[ 0 ] );
    SetDlgItemText( IDC_EDIT_P_X, temp_buf );

    Double2Str( temp_buf, temp_point[ 1 ] );
    SetDlgItemText( IDC_EDIT_P_Y, temp_buf );

    Double2Str( temp_buf, temp_point[ 2 ] );
    SetDlgItemText( IDC_EDIT_P_Z, temp_buf );

    line_ent->GetSecondary( temp_point );
    Double2Str( temp_buf, temp_point[ 0 ] );
    SetDlgItemText( IDC_EDIT_S_X, temp_buf );

    Double2Str( temp_buf, temp_point[ 1 ] );
    SetDlgItemText( IDC_EDIT_S_Y, temp_buf );

    Double2Str( temp_buf, temp_point[ 2 ] );
    SetDlgItemText( IDC_EDIT_S_Z, temp_buf );
    
    return TRUE;
}

/******************************************************************************
*                                                                             *
*                    CCIRCLEDIALOG class                                      *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
CCIRCLEDIALOG::CCIRCLEDIALOG( ads_name circle_name
                        , CWnd *pParent ) 
                    : CENTITYDIALOG( circle_name, CIRCLE_DIALOG, pParent )
{
}

//-----------------------------------------------------------------------------
BOOL    
CCIRCLEDIALOG::SetEntityItems( ADS_ENT_OBJ* ads_obj )
{
    ASSERT( ads_obj != NULL );
    ads_obj->WhoAmI( temp_buf );
    if ( strcmp( temp_buf, "ADS_CIRCLE" ) != 0 )
    {
        return FALSE;
    }

    ADS_CIRCLE  *circle_ent = ( ADS_CIRCLE* )ads_obj;
    ads_point temp_point;

    circle_ent->GetCenter( temp_point );
    Double2Str( temp_buf, temp_point[ 0 ] );
    SetDlgItemText( IDC_CENTER_X, temp_buf );

    Double2Str( temp_buf, temp_point[ 1 ] );
    SetDlgItemText( IDC_CENTER_Y, temp_buf );

    Double2Str( temp_buf, temp_point[ 2 ] );
    SetDlgItemText( IDC_CENTER_Z, temp_buf );

    circle_ent->GetRadius( temp_point );
    Double2Str( temp_buf, temp_point[ 0 ] );
    SetDlgItemText( IDC_RADIUS, temp_buf );

    return TRUE;
}

