#
# MFCBLANK.MAK
#
#       makefile to make ADS MFC sample MFCBLANK.EXE
#
#      (C) Copyright 1988-1994 by Autodesk, Inc.
#
#      This program is copyrighted by Autodesk, Inc. and is  licensed
#      to you under the following conditions.  You may not distribute
#      or  publish the source code of this program in any form.   You
#      may  incorporate this code in object form in derivative  works
#      provided  such  derivative  works  are  (i.) are  designed and
#      intended  to  work  solely  with  Autodesk, Inc. products, and
#      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
#      1988-1994 by Autodesk, Inc."
#
#      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
#      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
#      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
#      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
#      UNINTERRUPTED OR ERROR FREE.
#
#
#
!include <..\..\adsmake.nt>
!include <..\mfcads.inc>
!include <MFCBLANK.inc>

VPATH   = $(MFCBLANK_OBJ_DIR)
LOCINC  = $(ADS_CPP)\GENERAL $(ADS_CPP)\mfcads $(ADS)

#
# VC2/MFC3.0 requires a standard C RTL that supports "threads"
# so we have to use /MT on the compiler command line.
#
!if "$(ACCOMPILER)" == "VC2" || "$(ACCOMPILER)" == "vc2"
LIBTYPE = /MT
!endif

ADSLIB = $(ACOBJ)\ADS\WINADS.LIB

all: $(ACEXE)\MFCBLANK.EXE

MFCLIB=nafxcwd.lib
LINK_LIBS = $(MFCLIB) $(ac_guilibs) SHELL32.LIB ADVAPI32.LIB $(ADSLIB)

#
# Note the sequence of libraries, $(guilibsmt) is placed in front 
# of nafxcwd.lib.  This is done so LIBCMT.LIB in $(guilibsmt) will 
# not pick up WinMain() definition from $(ADSLIB)
# 
!if "$(ACCOMPILER)" == "VC2" || "$(ACCOMPILER)" == "vc2"
LINK_LIBS = $(guilibsmt) $(MFCLIB) SHELL32.LIB $(ADSLIB)
!endif

LINK_OBJS = $(MFCBLANKOBJS) $(MFCADSOBJS) 

$(ACEXE)\MFCBLANK.EXE: $(LINK_OBJS) $(MAKEFILE) $(VPATH)\$(@B).res
    echo Linking $(ac_ldebug_echo) $@
    $(link)  @<< $(ERRSTUFF) 
	$(CVDBUG) 
    $(VPATH)\$(@B).res 
	$(ads_lflags) /MACHINE:IX86 
	-nodefaultlib 
	$(LINK_LIBS)  $(LINK_OBJS)
	$(ac_ldebug_flags)
	-out:$@ 
<<

# --- default rules for making .exe ---
{.}.cpp{$(VPATH)}.obj:
    echo Compiling $(@B).cpp
    if exist $@ del $@
    $(COMP) -Tp$(@B).cpp $(ERRSTUFF)
    $(POSTERR)

{.}.rc{$(VPATH)}.res:
    echo Compiling Resource $@
    rc -Fo$(VPATH)\$(@B).res $(@B).rc

    
clean:
	echo Cleaning MFCBLANK Objects
	if not exist $(VPATH) mkdir $(VPATH)
    if exist $(VPATH)\*.* del /Q $(VPATH)\*.*
    if exist $(MFCBLANK_DIR)\*.pdb del /Q $(MFCBLANK_DIR)\*.pdb
    if exist $(ACEXE)\MFCBLANK.* del /Q $(ACEXE)\MFCBLANK.*

