/* 
    MFCADS.H -
    
    This file:

        declares a MFC ADS application class.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef __MFCADS_H_
#define __MFCADS_H_

#include <afxwin.h>

#include "adsinc.h"

/******************************************************************************
*                                                                             *
*                       class: ADS_APP                                        *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
class ADS_APP : public CWinApp
{
public:
    //
    // MFC...
    //
    BOOL            InitApplication();
    BOOL            InitInstance();
    virtual BOOL    OnIdle(LONG lCount);

                    ADS_APP();
    virtual         ~ADS_APP(){}
    int             InsertExternFunc(ADS_FUNC_INFO&);

    virtual BOOL    Valid() { return app_state = APP_OK ; }

typedef int ( ADS_APP::*ADS_RUN_RSP_FUN )( void );

typedef void ( ADS_APP::*ADS_APP_RUN_FUNC )( void );
    ADS_APP_RUN_FUNC    run_funs[10];
    int             num_run_funs;

protected:

    virtual int     LOADFun( void );
    virtual int     SUBRFun( void );
    virtual int     UNLDFun( void );
    virtual int     ENDFun( void ){ return RSRSLT; }
    virtual int     QUITFun( void );
    virtual int     SAVEFun( void ){ return RSRSLT; }
    virtual int     HUPFun( void );
    virtual int     CFGFun( void ){ return RSRSLT; }

    int             LOAD_status;
    int             UNLD_status;
    int             SUBR_status;

    struct DISPATCHER
    {
        int command;
        ADS_RUN_RSP_FUN rsp_fun;
    };

private:
    static DISPATCHER 
                    dispatcher[];
    ADS_FUNC_INFO   exfuns[MAX_ADS_FUNC];
    int             num_funs;
    ADS_APP_STATE   app_state;

    BASIC_CPP_STUFF( ADS_APP )
};

#endif //__ADSCPP_H_

