/* 
    MAINWND.H -
    
    This file:

        Declares basic WINDOW object and MAINWDOW object.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef MAINWND_H
#define MAINWND_H

#include "HELLOADS.h"


/******************************************************************************
*                                                                             *
*                            class WINDOW                                     *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
class WINDOW : ADS_OBJ
{
protected:
    HWND                hWnd;

public:
    HWND                GetHandle( void ) { return hWnd; }

    BOOL                Show( int showcmd ) 
                        { 
                            return ShowWindow( hWnd, showcmd );
                        }
    void                Update( void ) 
                        { 
                            InvalidateRect( hWnd, NULL, TRUE );
                            UpdateWindow( hWnd );
                        }
    virtual LRESULT     WndProc( UINT , WPARAM , LPARAM ) = 0;
    virtual BOOL        Valid(){ return hWnd != NULL; }
};

/******************************************************************************
*                                                                             *
*                          class MAINWINDO                                    *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
class MAINWINDOW : public WINDOW
{
private:
    static char         szClassName[14];
    ADS_STRING          text;

public:
    void                SetText( ADS_STRING& new_text ){ text = new_text; }
    ADS_STRING&         Text() { return text; }
    static BOOL         Register( void );
    LRESULT             WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );
                        MAINWINDOW();
    void                Paint( void );
    virtual BOOL        Valid()
                        {
                            return WINDOW::Valid(); 
                        }
};

#endif

