/* 
    HELLOADS.H -
    
    This file:

        Delcares traditional Windows Application object, 
        WIN_APP, and ADS_APP is then derived to employ ADS 
        functions.
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef HELLOADS_H
#define HELLOADS_H

#include "adsinc.h"
#include "mainwnd.h"
#include "resource.h"

#define APP_NAME    "HELLOADS"

/******************************************************************************
*                                                                             *
*                               WIN_APP                                       *
*                                                                             *
******************************************************************************/
class WIN_APP : ADS_OBJ
{
    friend HINSTANCE AppInstance();

protected:
    MSG                 msg;
    WINDOW              *main_wnd;

    HINSTANCE           main_hinst;
    HINSTANCE           prev_hinst;
    int                 ncmdshow;
    ADS_STRING          cmdline;

public:
    virtual BOOL        InitInstance( HINSTANCE hInst, HINSTANCE hprev );
    virtual BOOL        InitApplication( int nCmdShow, LPSTR lpcmd );
    void                ShowMainWindow();
    virtual int         Run( void );

    virtual BOOL        Valid(){ return main_hinst != NULL; }

                        WIN_APP();
    WINDOW*             MainWindow() { return main_wnd; }
};

/******************************************************************************
*                                                                             *
*                                 ADS_APP                                     *
*                                                                             *
******************************************************************************/
class ADS_APP : public WIN_APP
{
protected:
	int                 ads_stat;
    short               scode;

public:
    BOOL                InitApplication( int nCmdShow, LPSTR _cmdline );
    BOOL                AdsLoop();
    virtual int         Run( void );

    virtual BOOL        Valid(){ return main_hinst != NULL; }

                        ADS_APP()
                        { 
                            ads_stat = 0;
                            scode    = RSRSLT;
                        }

};

//-----------------------------------------------------------------------------
// Globals
//
extern ADS_APP          myapp;

extern HINSTANCE        AppInstance();
extern char*            ModuleName();
extern LRESULT CALLBACK WndProc( HWND hWnd
                                , UINT iMessage
                                , WPARAM wParam
                                , LPARAM lParam );


#endif
