/* 
    HELLOADS.CPP -
    
    This file:

        A very simple ADS Windows application.

        From ACAD command window:

        ( xload "helloads" ) to bring up the application and it's
        window.

        Command:

        (HELLOADS "message") Change application's main window text.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "HELLOADS.h"

//-----------------------------------------------------------------------------
ADS_APP myapp;

//-----------------------------------------------------------------------------
WIN_APP* CurApp()
{
    return ( WIN_APP* )&myapp;
}

//-----------------------------------------------------------------------------
HINSTANCE AppInstance()
{
    return myapp.main_hinst;
}

//-----------------------------------------------------------------------------
char* ModuleName()
{
    return APP_NAME;
}

//-----------------------------------------------------------------------------
LRESULT CALLBACK WndProc( HWND hWnd
                        , UINT iMessage
                        , WPARAM wParam
                        , LPARAM lParam );

/******************************************************************************
*                                                                             *
*                                 WIN_APP                                     *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
WIN_APP::WIN_APP()
{
    main_wnd    = 0;
    main_hinst  = 0;
    prev_hinst  = 0;
}

//-----------------------------------------------------------------------------
void WIN_APP::ShowMainWindow()
{
    if ( main_wnd )
    {
        main_wnd->Show( ncmdshow );
        main_wnd->Update();
    }
}

//-----------------------------------------------------------------------------
BOOL WIN_APP::InitInstance( HINSTANCE hInst, HINSTANCE hprev )
{
    main_hinst = hInst;
    prev_hinst = hprev;

    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL WIN_APP::InitApplication( int nCmdShow, LPSTR _cmdline )
{
    cmdline = _cmdline;
    ncmdshow = nCmdShow;

    return TRUE;
}

//-----------------------------------------------------------------------------
int WIN_APP::Run( void )
{
    while ( GetMessage( &msg, NULL, 0, 0 ) )
    {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }
    return msg.wParam;
}

/******************************************************************************
*                                                                             *
*                                 ADS_APP                                     *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
BOOL ADS_APP::InitApplication( int nCmdShow, LPSTR _cmdline )
{
    if ( WIN_APP::InitApplication( nCmdShow, _cmdline ) )
    {

        if ( ads_winit( AppInstance(), ModuleName() ) == RTNORM ) 
        {
            main_wnd = new MAINWINDOW;
            return TRUE;
        }
    }
    return FALSE;
}


//-----------------------------------------------------------------------------
int ADS_APP::Run( void )
{
    while ( TRUE )
    {
        if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
        {
            if ( msg.message == WM_QUIT )
            {
                break;
            }
            TranslateMessage ( &msg );
            DispatchMessage ( &msg );
        }
        else
        {
            if ( !AdsLoop() )
            {
                return -1;
            }
        }
    }
    return msg.wParam;
}


//-----------------------------------------------------------------------------
BOOL ADS_APP::AdsLoop()
{

	if ( ( ads_stat = ads_link( scode ) ) < 0 ) 
    {
	    char errmsg[80];
	    sprintf( errmsg
                , "%s: bad ads_status from ads_link() = %d"
                , ModuleName()
                , ads_stat );
	    ::MessageBox( NULL, errmsg, "ADS Error", MB_OK );
        return FALSE;
	}

	scode = RSRSLT;

	switch ( ads_stat ) 
    {
	    case RQXLOAD:
        {
	        if ( !ads_defun( ModuleName(), 1 ) )    /* command has id 1 */
            {
		        scode = -RSERR;
            }
	        else 
            {
		        ads_printf( "%s \"string to show\" command invokes trivial test.\n", ModuleName() );
		        scode = -RSRSLT;
            }
	        break;
	    }

	    case RQHUP:
        {
            return FALSE;
        }

	    case RQSUBR:
        {
	        switch ( ads_getfuncode() ) 
            {
		        case 1:
                {
                    struct resbuf *rp;
                    rp = ads_getargs();
	                if ( rp->restype == RTSTR )
                    {
                        ( ( MAINWINDOW* )main_wnd )->SetText( ADS_STRING( rp->resval.rstring ) );
                        main_wnd->Update();
                    }
		            break;
                }
		        default:
                {
		            break;
                }
            }
            break;
	    }

    	default:
        {
	        break;
	    }
    }

    return TRUE;
}

//-----------------------------------------------------------------------------
int PASCAL WinMain( HINSTANCE hInstance
                    , HINSTANCE hPrevInstance
                    , LPSTR lpszCmdLine
                    , int nCmdShow )
{
    if ( CurApp()->InitInstance( hInstance, hPrevInstance ) )
    {
        if ( CurApp()->InitApplication( nCmdShow, lpszCmdLine ) )
        {
            CurApp()->ShowMainWindow();
            return CurApp()->Run();
        }
    }
    return -1;
}
