/* 
    ADSTABLE.H -
    
    This file:

        Declares ADS table objects.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef _ADSTABLE_H
#define _ADSTABLE_H

//-----------------------------------------------------------------------------
struct ADS_TABLE_OBJ;
struct ADS_LAYER;
struct ADS_LTYPE;
struct ADS_VIEW;
struct ADS_STYLE;
struct ADS_BLOCK;
struct ADS_UCS;
struct ADS_DIMSTYLE;
struct ADS_VPORT;
struct ADS_APPID;

//-----------------------------------------------------------------------------
struct ADS_TABLE_OBJ*   MakeAdsTable( struct resbuf* rb );
void                    DeleteAdsTable( ADS_TABLE_OBJ* table_obj );

//-----------------------------------------------------------------------------
struct ADS_TABLE_OBJ : ADS_OBJ
{
    struct resbuf   *rb;

                    ADS_TABLE_OBJ( struct resbuf* _rb )
                    {
                        rb = _rb;
                    }
    virtual         ~ADS_TABLE_OBJ(){}
    BOOL            Valid() { return ( rb != NULL ); }

    ADS_STRING      formatstring;
    ADS_STRING&     FormatTableString();

private:
    BASIC_CPP_STUFF( ADS_TABLE_OBJ )
};

//-----------------------------------------------------------------------------
struct ADS_LAYER : ADS_TABLE_OBJ
{
                    ADS_LAYER( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_LAYER(){}

private:
    BASIC_CPP_STUFF( ADS_LAYER )
};

//-----------------------------------------------------------------------------
struct ADS_LTYPE : ADS_TABLE_OBJ
{
                    ADS_LTYPE( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_LTYPE(){}

private:
    BASIC_CPP_STUFF( ADS_LTYPE )
};

//-----------------------------------------------------------------------------
struct ADS_VIEW : ADS_TABLE_OBJ
{
                    ADS_VIEW( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_VIEW(){}

private:
    BASIC_CPP_STUFF( ADS_VIEW )
};

//-----------------------------------------------------------------------------
struct ADS_STYLE : ADS_TABLE_OBJ
{
                    ADS_STYLE( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_STYLE(){}

private:
    BASIC_CPP_STUFF( ADS_STYLE )
};

//-----------------------------------------------------------------------------
struct ADS_BLOCK : ADS_TABLE_OBJ
{
                    ADS_BLOCK( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_BLOCK(){}

private:
    BASIC_CPP_STUFF( ADS_BLOCK )
};

//-----------------------------------------------------------------------------
struct ADS_UCS : ADS_TABLE_OBJ
{
                    ADS_UCS( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_UCS(){}

private:
    BASIC_CPP_STUFF( ADS_UCS )
};

//-----------------------------------------------------------------------------
struct ADS_DIMSTYLE : ADS_TABLE_OBJ
{
                    ADS_DIMSTYLE( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_DIMSTYLE(){}

private:
    BASIC_CPP_STUFF( ADS_DIMSTYLE )
};

//-----------------------------------------------------------------------------
struct ADS_VPORT : ADS_TABLE_OBJ
{
                    ADS_VPORT( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_VPORT(){}

private:
    BASIC_CPP_STUFF( ADS_VPORT )
};

//-----------------------------------------------------------------------------
struct ADS_APPID : ADS_TABLE_OBJ
{
                    ADS_APPID( struct resbuf* _rb ) : ADS_TABLE_OBJ( _rb ){}
    virtual         ~ADS_APPID(){}

private:
    BASIC_CPP_STUFF( ADS_APPID )
};

#endif
