/* 
    ADSTABLE.CPP -
    
    This file:

        Defines ADS_TABLE class and all it's descendents and
        the machines( functions ) to create and destroy these 
        objects.


    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "adsinc.h"

//-----------------------------------------------------------------------------
//static ADS_STRING table_end_string( "\n\tEnd of Table" );
//static ADS_STRING table_begin_string( "\tBegin of Table\n" );

static ADS_STRING table_record_seperator( "\n" );
static ADS_STRING table_end_string( "\n" );
static ADS_STRING table_begin_string( " " );

//static ADS_STRING table_record_seperator( " " );

//-----------------------------------------------------------------------------
ADS_TABLE_OBJ*  MakeLayerTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeLtypeTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeViewTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeStyleTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeBlockTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeUcsTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeDimstyleTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeVportTbl( struct resbuf *rb );
ADS_TABLE_OBJ*  MakeAppidTbl( struct resbuf *rb );

//-----------------------------------------------------------------------------
struct _ADS_TABLE_TYPES
{
    ADS_TABLE_OBJ* ( *MakeTableFun )( struct resbuf *rb );
    char            *tablename;
}ADS_TABLE_TYPES[] =
{
    { MakeLayerTbl,         "LAYER" }
    , { MakeLtypeTbl,       "LTYPE" }
    , { MakeViewTbl,        "VIEW" }
    , { MakeStyleTbl,       "STYLE" }
    , { MakeBlockTbl,       "BLOCK" }
    , { MakeUcsTbl,         "UCS" }
    , { MakeDimstyleTbl,    "DIMSTYLE" }
    , { MakeVportTbl,       "VPORT" }
    , { MakeAppidTbl,       "APPID" }
};

//-----------------------------------------------------------------------------
int FormatResBufInfo( char *buffer, struct resbuf* rb );

//-----------------------------------------------------------------------------
void DeleteAdsTable( ADS_TABLE_OBJ* table_obj )
{
    delete table_obj;
}

//-----------------------------------------------------------------------------
struct ADS_TABLE_OBJ* MakeAdsTable( struct resbuf* rb )
{
    if ( rb->restype != 0 )
    {
        return NULL;
    }
    int     table_index;
    for ( table_index = 0
            ; table_index < ARRAY_SIZE( ADS_TABLE_TYPES  ) 
            ; table_index++ )
    {
        if ( _stricmp( rb->resval.rstring
                    , ADS_TABLE_TYPES[ table_index ].tablename ) == 0 )
        {
            return ( * ( ADS_TABLE_TYPES[ table_index ].MakeTableFun ) )( rb );
        }
    }
    return NULL;
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeLayerTbl( struct resbuf *rb )
{
    return new ADS_LAYER( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeLtypeTbl( struct resbuf *rb )
{
    return new ADS_LTYPE( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeViewTbl( struct resbuf *rb )
{
    return new ADS_VIEW( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeStyleTbl( struct resbuf *rb )
{
    return new ADS_STYLE( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeBlockTbl( struct resbuf *rb )
{
    return new ADS_BLOCK( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeUcsTbl( struct resbuf *rb )
{
    return new ADS_UCS( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeDimstyleTbl( struct resbuf *rb )
{
    return new ADS_DIMSTYLE( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeVportTbl( struct resbuf *rb )
{
    return new ADS_VPORT( rb );
}

//-----------------------------------------------------------------------------
inline ADS_TABLE_OBJ*  MakeAppidTbl( struct resbuf *rb )
{
    return new ADS_APPID( rb );
}

/******************************************************************************
*                                                                             *
*                    ADS_TABLE_OBJ member functions                           *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
ADS_STRING& ADS_TABLE_OBJ::FormatTableString()
{
    if ( rb == NULL )
    {
		formatstring = "";
        return formatstring;
    }

    //
    // Terrible way to do this, what if rb has more info GENERAL_BUFFER_SIZE
    // can handle?
    //
    formatstring = table_begin_string;

    while ( rb )
    {
        char    record_buffer[ 256 ];
        if ( DXFGroupCode2Str( rb, record_buffer ) != NULL )
        {
            formatstring += table_record_seperator + record_buffer;
        }
        rb = rb->rbnext;
    }
    formatstring += table_end_string;
    return formatstring;
}
