/* 
    ADSDXF.H

    This file:

    Declares DXF group conversion functions and enums in converting
    DXF group code.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef ADSDXF_H
#define ADSDXF_H

#include "adsinc.h"

//-----------------------------------------------------------------------------
// This can be broken down even deeper, depends on the application needs.
//
enum DXF_GROUP_CODE_BOUNDS
{
    /*******************************
    *       String groups          *
    *******************************/
    DXF_PRIM_ENT_TEXT_LOWER_1   = 1
    , DXF_PRIM_ENT_TEXT_UPPER_1 = 1
    // General string coverage...
    , DXF_STRING_LOWER_1        = 0
    , DXF_STRING_UPPER_1        = DXF_STRING_LOWER_1 + 9

    /*******************************
    *    Floating point group 1    *
    *******************************/
    , DXF_PRIM_X_LOWER          = 10
    , DXF_PRIM_X_UPPER          = 10
    , DXF_OTHER_X_LOWER         = 11
    , DXF_OTHER_X_UPPER         = 17
    , DXF_PRIM_Y_LOWER          = 20
    , DXF_PRIM_Y_UPPER          = 20
    , DXF_OTHER_Y_LOWER         = 21
    , DXF_OTHER_Y_UPPER         = 27
    , DXF_PRIM_Z_LOWER          = 30
    , DXF_PRIM_Z_UPPER          = 30  
    , DXF_OTHER_Z_LOWER         = 31
    , DXF_OTHER_Z_UPPER         = 37
    , DXF_FLOAT_FACT_LOWER_1    = 40
    , DXF_FLOAT_FACT_UPPER_1    = 49
    , DXF_ANGLE_LOWER           = 50
    , DXF_ANGLE_UPPER           = 59
    , DXF_FLOAT_LOWER_1         = 10
    , DXF_FLOAT_UPPER_1         = 59

    /*******************************
    *       integer group 1        *
    *******************************/
    , DXF_COLOR_NUMBER_LOWER    = 62
    , DXF_COLOR_NUMBER_UPPER    = 62
    // General intger 
    , DXF_INTEGER_LOWER_1       = 61
    , DXF_INTEGER_UPPER_1       = 70

    /*******************************
    *   Long group 1               *
    *******************************/
    , DXF_LONG_LOWER            = 90
    , DXF_LONG_UPPER            = 99

    /*******************************
    *   String group 3             *
    *******************************/
    , DXF_STRING_LOWER_2        = 100
    , DXF_STRING_UPPER_2        = 109

    /*******************************
    *    Floating point group 2    *
    *******************************/
    , DXF_FLOAT_LOWER_2         = 140
    , DXF_FLOAT_UPPER_2         = 149
    /*******************************
    *       integer group 2        *
    *******************************/
    , DXF_INTEGER_LOWER_2       = 170
    , DXF_INTEGER_UPPER_2       = 179
    /*******************************
    *    Floating point group 3    *
    *******************************/
    , DXF_EXTRUSION_X_LOWER     = 210
    , DXF_EXTRUSION_X_UPPER     = 210
    , DXF_EXTRUSION_Y_LOWER     = 220
    , DXF_EXTRUSION_Y_UPPER     = 220
    , DXF_EXTRUSION_Z_LOWER     = 230
    , DXF_EXTRUSION_Z_UPPER     = 230
    // general floating point 3
    , DXF_FLOAT_LOWER_3         = 210
    , DXF_FLOAT_UPPER_3         = 239

    /********************************
    *    integer group 3            *
    ********************************/
    , DXF_INTEGER_LOWER_3       = 270
    , DXF_INTEGER_UPPER_3       = 279

    /********************************
    *    string group 3             *
    ********************************/
    , DXF_STRING_LOWER_3         = 300
    , DXF_STRING_UPPER_3         = 369


    /*******************************
    *        Comment group         *
    *******************************/
    , DXF_COMMENT_LOWER         = 999
    , DXF_COMMENT_UPPER         = 999

    /*******************************
    *      Extended stuff...       *
    *******************************/
    , DXF_STRING_LOWER_4        = 1000
    , DXF_STRING_UPPER_4        = 1009
    , DXF_FLOAT_LOWER_4         = 1010
    , DXF_FLOAT_UPPER_4         = 1059
    , DXF_INTEGER_LOWER_4       = 1060
    , DXF_INTEGER_UPPER_4       = 1079
    , DXF_UNKNOWN_LOWER         = 1080
    , DXF_UNKNOWN_UPPER         = 0xFFFFFFFF
};

//-----------------------------------------------------------------------------
// How many upper/lower pairs in DXF_GROUP_CODE_BOUNDS
//
enum DXFGROUPCODE
{
    DXF_PRIM_ENT_TEXT = 0
    , DXF_STRING1
    , DXF_PRIM_X
    , DXF_OTHER_X
    , DXF_PRIM_Y
    , DXF_OTHER_Y
    , DXF_PRIM_Z
    , DXF_OTHER_Z
    , DXF_FLOAT_FACT
    , DXF_ANGLE
    , DXF_FLOAT1
    , DXF_COLOR_NUMBER
    , DXF_INTEGER1
    , DXF_LONG
    , DXF_STRING2
    , DXF_FLOAT2
    , DXF_INTEGER2
    , DXF_EXTRUSION_X
    , DXF_EXTRUSION_Y
    , DXF_EXTRUSION_Z
    , DXF_FLOAT3
    , DXF_INTEGER3
    , DXF_STRING3
    , DXF_COMMENT_STRING
    , DXF_STRING4
    , DXF_FLOAT4
    , DXF_INTEGER4
    , DXF_UNKNOWN_GROUP
};

//-----------------------------------------------------------------------------
typedef char* ( *DXF2STRFUNC )( char*, struct resbuf* );
typedef struct resbuf* ( *STR2DXFFUNC )( struct resbuf*, char* );

//-----------------------------------------------------------------------------
char                *ThreeD2Str( char* dst, struct resbuf* src );
struct resbuf       *Str2ThreeD( struct resbuf* dst, char* src );

char                *Double2Str( char* dst, struct resbuf* src );
struct resbuf       *Str2Double( struct resbuf* dst, char* src );

char                *Double2Str( char* dst, double src );
double              *Str2Double( double* dst, char* src );

char                *Int2Str( char* dst, struct resbuf* src );
struct resbuf       *Str2Int( struct resbuf* dst, char* src );

char                *Long2Str( char* dst, struct resbuf* src );
struct resbuf       *Str2Long( struct resbuf* dst, char* src );

char                *Str2Str( char* dst, struct resbuf* src );
struct resbuf       *Str2Str( struct resbuf* dst, char* src );

char                *AdsName2Str( char* dst, struct resbuf *src );
struct resbuf       *Str2AdsName( struct resbuf* dst, char *src);

char                *AdsName2Str( char* dst, ads_name& src );
ads_name&           Str2AdsName( ads_name& dst, char *src);


//-----------------------------------------------------------------------------
struct DXF_GROUP_INFO
{
    DXFGROUPCODE                dxfgroup;
    DXF_GROUP_CODE_BOUNDS       lower;
    DXF_GROUP_CODE_BOUNDS       upper;
    DXF2STRFUNC                 dxf2strfunc;
    STR2DXFFUNC                 str2dxfunc;
    char                        *string;
};

//-----------------------------------------------------------------------------
DXFGROUPCODE    DXFGroupCode( int dxfcode );
char            *DXFGroupCode2Str( struct resbuf* src, char *buffer );

#endif

