/* 
    SSCLNT.CPP -
    
    This file:

        Defines spread sheet client connection class in a ADS
        application.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

/******************************************************************************
*                                                                             *
*                SS_CLIENT_CONNECTION member functions                        *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
SS_CLIENT_CONNECTION::SS_CLIENT_CONNECTION( SS_SERVER_INFO& server_info )
                                         : DDE_CLIENT_CONNECTION()
{
    server = new SS_SERVER_INFO( server_info );
}

//-----------------------------------------------------------------------------
SS_CLIENT_CONNECTION::~SS_CLIENT_CONNECTION()
{
    if ( server ) delete server; server = NULL;
}

//-----------------------------------------------------------------------------
BOOL SS_CLIENT_CONNECTION::EndSend()
{
    DDE_CLIENT_CONNECTION::EndSend();

    SS_SERVER_INFO* temp_info = ( SS_SERVER_INFO* )server;
    dde_item->Reset();
    temp_info->SetCurCol( 1 );
    temp_info->SetCurRow( 1 );

    return TRUE;
}

/******************************************************************************
*                                                                             *
*                EXCEL_CLIENT_CONNECTION member functions                        *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
BOOL EXCEL_CLIENT_CONNECTION::InitItem( ADS_STRING& item_name )
{
    ASSERT( dde_item == NULL );
    dde_item = new EXCEL_ITEM( this );
    ASSERT( dde_item );
    return ( dde_item->NewHandle( item_name ) != NULL );
}

