/* 
    DDEMISC.H -
    
    This file:

        Has miscellaneous function declarations used in ADS 
        DDE C++ classes.
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef DDEMISC_H
#define DDEMISC_H

#include "ddeinc.h"

//-----------------------------------------------------------------------------
struct  DDETHIS_LOOKUP;
struct  DDE_INSTANCE;
struct  DDE_STRING_HANDLE;
struct  DDE_HCONV;


//-----------------------------------------------------------------------------
#define MAX_ADS_INSTANCE      20
#define POKE_BUFFER_SIZE    4*1024
#define TAB                 '\t'
#define NEW_LINE            '\n'


/******************************************************************************
*                                                                             *
*                           DDETHIS_LOOKUP class                              *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
typedef ADS_OBJ const*  ADS_OBJ_THIS;
struct  ADS_THIS_LOOKUP
{
    HCONV               conv_id;
    ADS_OBJ_THIS        ads_this;
};

/******************************************************************************
*                                                                             *
*                           ADS_INSTANCE class                                 *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
struct  ADS_INSTANCE
{
    int                 num_instance;
    ADS_THIS_LOOKUP     ads_instances[ MAX_ADS_INSTANCE ];
                        ADS_INSTANCE();
    BOOL                RemoveInstanceIndex( int this_index );
    BOOL                RemoveInstance( ADS_OBJ_THIS _this );
    int                 GetNumInstances() { return num_instance; }
    int                 AddInstanceIndex( ADS_OBJ_THIS new_this
                                        , HCONV h_conv );
    ADS_OBJ_THIS   This(HCONV _conv_id);
};

//-----------------------------------------------------------------------------
inline ADS_INSTANCE::ADS_INSTANCE()
{ 
    num_instance = 0; 
    for ( int i = 0; i < MAX_ADS_INSTANCE; i++ )
    {
        ads_instances[ i ].ads_this = NULL;
        ads_instances[ i ].conv_id = 0;
    }
}

//-----------------------------------------------------------------------------
inline BOOL ADS_INSTANCE::RemoveInstance( ADS_OBJ_THIS _this )
{
    for ( int i = 0; i < num_instance; i++ )
    {
        if ( ads_instances[ i ].ads_this == _this )
        {
            return RemoveInstanceIndex( i );
        }
    }
    return FALSE;
}

//-----------------------------------------------------------------------------
inline BOOL ADS_INSTANCE::RemoveInstanceIndex( int this_index )
{
    if ( ads_instances[ this_index ].ads_this != NULL )
    {
        ads_instances[ this_index ].ads_this = NULL;
        ads_instances[ this_index ].conv_id = 0;
        num_instance--;
        //
        // Packing...
        //
        for ( int i = this_index
            ; ( ads_instances[ i+1 ].ads_this != NULL ) && ( i+1 < MAX_ADS_INSTANCE )
            ; i++ )
        {
            ads_instances[ i ].ads_this = ads_instances[ i+1 ].ads_this;
            ads_instances[ i ].conv_id = ads_instances[ i+1 ].conv_id;
            ads_instances[ i+1 ].ads_this = NULL;
            ads_instances[ i+1 ].conv_id = 0;
        }
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}
//-----------------------------------------------------------------------------
inline int ADS_INSTANCE::AddInstanceIndex( ADS_OBJ_THIS new_this
                                        , HCONV h_conv )
{
    ASSERT ( new_this != NULL && h_conv != NULL && num_instance < MAX_ADS_INSTANCE );
    
    if ( num_instance < MAX_ADS_INSTANCE )
    {
        ads_instances[ num_instance ].ads_this = new_this;
        ads_instances[ num_instance ].conv_id = h_conv;
        num_instance++;
        return num_instance;
    }
    return -1;
}
//-----------------------------------------------------------------------------
inline ADS_OBJ_THIS ADS_INSTANCE::This(HCONV _conv_id)
{ 
    ASSERT ( _conv_id != NULL );

    for ( int i = 0; i < num_instance; i++)
    {
        if ( _conv_id == ads_instances[ i ].conv_id )
        {
            ASSERT ( ads_instances[ i ].ads_this != NULL );
            return ads_instances[ i ].ads_this;
        }
    }
    return NULL;
}


/******************************************************************************
*                                                                             *
*                                 DDE_HCONV                                   *
*                                                                             *
******************************************************************************/
struct DDE_HCONV : ADS_OBJ
{
    HCONV           cur_conv;
    DDE_CONNECTION  *conx;
    SERVER_INFO     *server;
                    
                    DDE_HCONV( DDE_CONNECTION* _conx
                            , SERVER_INFO *_server 
                            , PCONVCONTEXT pcc );
                    DDE_HCONV()
                    { 
                        cur_conv = NULL;
                        conx = NULL;
                        server = NULL; 
                    }
                    DDE_HCONV( const DDE_HCONV& src )
                    {
                        cur_conv = src.cur_conv;
                        conx = src.conx;
                        server = src.server;
                    }

                    ~DDE_HCONV();

    BOOL            DisConnect();
    HCONV           NewConv( DDE_CONNECTION *_conx
                            , SERVER_INFO *_server 
                            , PCONVCONTEXT pcc );
    virtual BOOL    Valid() { return cur_conv != NULL; }
                    operator HCONV( ){ return cur_conv; }
};


/******************************************************************************
*                                                                             *
*                            DDE_STRING_HANDLE                                *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
struct      DDE_STRING_HANDLE : ADS_OBJ
{
    DDE_CONNECTION      *conx;
    HSZ                 handle;
    HSZ                 Handle() { return handle; }
    ADS_STRING          string;
    virtual HSZ         NewHandle( ADS_STRING& s );
                        DDE_STRING_HANDLE( DDE_CONNECTION* _conx );
    virtual             ~DDE_STRING_HANDLE();
    BOOL                IsSameDDEString( char *_string );
    BOOL                IsSameDDEString( ADS_STRING& _string );
    virtual BOOL        Valid()
                        {
                            return ( conx && handle );
                        }
                        operator HSZ( ) { return handle; }
private:
    //
    // No time to implement this...
    //
    DDE_STRING_HANDLE&  operator=( const DDE_STRING_HANDLE& );
                        DDE_STRING_HANDLE( const DDE_STRING_HANDLE& );
};

/******************************************************************************
*                                                                             *
*                              DDE_SERVICE                                    *
*                                                                             *
******************************************************************************/
struct DDE_SERVICE : DDE_STRING_HANDLE
{
                    DDE_SERVICE( DDE_CONNECTION *_conx )
                    : DDE_STRING_HANDLE( _conx ) {}
                                operator HSZ( ) { return handle; }
};

/******************************************************************************
*                                                                             *
*                               DDE_TOPIC                                     *
*                                                                             *
******************************************************************************/
struct DDE_TOPIC : DDE_STRING_HANDLE
{
                    DDE_TOPIC( DDE_CONNECTION *_conx ) 
                    : DDE_STRING_HANDLE( _conx ) {}
                                operator HSZ( ) { return handle; }
};

/******************************************************************************
*                                                                             *
*                               DDE_ITEM                                      *
*                                                                             *
*   DDE_ITEM is the abstract layer to represent the transfer item in a dde    *
*   communication.  Since all dde communication transfers have different      *
*   ways of building, reseting the item                                       *
*                                                                             *
******************************************************************************/
struct DDE_ITEM : DDE_STRING_HANDLE
{
    virtual void                Reset(){ string = ""; }
    virtual HSZ                 Range(){ return Handle(); }
    virtual HSZ                 ConstructDDEString( ADS_STRING& string );
                                DDE_ITEM( DDE_CONNECTION *_conx )
                                : DDE_STRING_HANDLE( _conx ) {}
                                operator HSZ( ) { return handle; }
};

/******************************************************************************
*                                                                             *
*                           EXCEL_ITEM                                        *
*                                                                             *
*                                                                             *
******************************************************************************/
struct EXCEL_ITEM : DDE_ITEM
{
    int                         max_range_row;
    int                         max_range_col;
    static ADS_STRING           init_string;

    virtual void                Reset(){}
    HSZ                         hrange;
    virtual HSZ                 Range();
    ADS_STRING                  range_string;

    virtual HSZ                 ConstructDDEString( ADS_STRING& );
                                ~EXCEL_ITEM();
                                EXCEL_ITEM( DDE_CONNECTION *_conx )
                                : DDE_ITEM( _conx ) 
                                {
                                    range_string = "";
                                    hrange = 0;
                                    max_range_row = 1;
                                    max_range_col = 1;
                                    NewHandle( init_string );
                                }
                                operator HSZ( ) { return handle; }
};

//-----------------------------------------------------------------------------
// inliners
//-----------------------------------------------------------------------------
inline BOOL DDE_STRING_HANDLE::IsSameDDEString( char *_string )
{
    return ( _string == string );
}

//-----------------------------------------------------------------------------
inline BOOL DDE_STRING_HANDLE::IsSameDDEString( ADS_STRING& _string )
{
    return ( _string == string );
}


#endif

