/* 
    DDEMISC.CPP -
    
    This file:

        Defines miscellaneous functions that are used in ADS 
        DDE C++ classes.
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

//-----------------------------------------------------------------------------
#ifdef DDEADS_DBG
static char     dbg_string[256];
#endif

/******************************************************************************
*                                                                             *
*                        DDE_HCONV member functions                           *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
DDE_HCONV::DDE_HCONV( DDE_CONNECTION* _conx
                    , SERVER_INFO *_server 
                    , PCONVCONTEXT pcc)
                    : ADS_OBJ(), conx( _conx ), server( _server )
{
    cur_conv = DdeConnect( DDE_GLOBAL::GetInstId()
                        , conx->DDEService()
                        , conx->DDETopic()
                        , pcc );

    if ( cur_conv == 0 )
    {
        MessageBox( GetFocus()
                    , "DDE Connection failed."
                    , "DDE_HCONV Info", MB_OK );
    }
#ifdef DDEADS_DBG
    wsprintf( dbg_string
            , " DdeConnect: this = %lx cur_conv = %lx"
            , this
            , cur_conv );
    OutputDebugString( dbg_string );
#endif
}

//-----------------------------------------------------------------------------
BOOL DDE_HCONV::DisConnect()
{
    if ( cur_conv )
    {
#ifdef DDEADS_DBG
    wsprintf( dbg_string
            , " DdeDisconnect: this = %lx cur_conv = %lx"
            , this
            , cur_conv );
    OutputDebugString( dbg_string );
#endif
        if ( DdeDisconnect( cur_conv ) )
        {
            cur_conv = 0;
            return TRUE;
        }
        else
        {
            DWORD   err = GetLastError();

            ::MessageBox( GetFocus()
                        , "Fail to disconnect conversation"
                        , "DDE_HCONV"
                        , MB_OK );
            return FALSE;
        }
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
DDE_HCONV::~DDE_HCONV()
{
    if ( cur_conv )
    {
        conx->RemoveConnection();
    }
}

//-----------------------------------------------------------------------------
// 
// New conversation can be set up by providing a new DDE_CONNECTION
// and a SERVER_INFO, and PCONVCONTEXT.  Unless DDE_CONNECTION's 
// topic or service name change, no new conversation is initiated.
//
HCONV DDE_HCONV::NewConv( DDE_CONNECTION* _conx
                            , SERVER_INFO *_server 
                            , PCONVCONTEXT pcc)
{
    if ( Valid() )
    {
        if ( !DisConnect() )
        {
            return NULL;
        }
    }
    
    ASSERT( _conx != NULL );
    ASSERT( _server != NULL );
    
    conx = _conx;
    server = _server;

    ASSERT( conx->DDEService() );
    ASSERT( conx->DDETopic() );

   cur_conv = DdeConnect( DDE_GLOBAL::GetInstId()
                        , conx->DDEService()
                        , conx->DDETopic()
                        , pcc );
#ifdef DDEADS_DBG
    wsprintf( dbg_string
            , " DdeConnect: this = %lx cur_conv = %lx"
            , this
            , cur_conv );
    OutputDebugString( dbg_string );
#endif
    if ( !cur_conv )
    {
        // try to start the application then
        server->Start();
    
        cur_conv = DdeConnect( DDE_GLOBAL::GetInstId()
                            , conx->DDEService()
                            , conx->DDETopic()
                            , pcc );
        if ( cur_conv == 0 )
        {
            MessageBox( GetFocus()
                        , "DDE Connection failed."
                        , "DDE_HCONV Info", MB_OK );
        }
    }
    return ( cur_conv );
}

/******************************************************************************
*                                                                             *
*                 DDE_STRING_HANDLE member functions                          *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
DDE_STRING_HANDLE::DDE_STRING_HANDLE( DDE_CONNECTION* _conx )
{
    handle = NULL; 
    conx = _conx; 
}

//-----------------------------------------------------------------------------
DDE_STRING_HANDLE::~DDE_STRING_HANDLE() 
{ 
    if ( handle )
    {
        DdeFreeStringHandle( DDE_GLOBAL::GetInstId(), handle );
    }
}

//-----------------------------------------------------------------------------
HSZ DDE_STRING_HANDLE::NewHandle( ADS_STRING& dde_string_name )
{
    if ( conx && conx->linking )
    {
        conx->Unlink();
    }

    if ( handle )
    {
        DdeFreeStringHandle( DDE_GLOBAL::GetInstId(), handle );
        handle = NULL;
    }
    if ( dde_string_name.Valid() )
    {
        string = dde_string_name;
        char temp_buf[ 256 ];
        strcpy( temp_buf, string.CString() );
        handle = DdeCreateStringHandle( DDE_GLOBAL::GetInstId()
										, temp_buf
                                        , CP_WINANSI );
    }
    return handle;
}

/******************************************************************************
*                                                                             *
*                               DDE_ITEM                                      *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
// Default value for DDE_ITEM 
//
HSZ DDE_ITEM::ConstructDDEString( ADS_STRING& string )
{
    Reset();
    return NewHandle( string );
}

/******************************************************************************
*                                                                             *
*                              EXCEL_ITEM                                     *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
ADS_STRING EXCEL_ITEM::init_string = "R1C1";

//-----------------------------------------------------------------------------
HSZ  EXCEL_ITEM::ConstructDDEString( ADS_STRING& send_string )
{

    ASSERT( send_string.Valid() );
    
    int     startRow    = (DDE_GLOBAL::excel_server_info)->GetCurRow();
    int     startCol    = (DDE_GLOBAL::excel_server_info)->GetCurCol();
    int     nRow        = (DDE_GLOBAL::excel_server_info)->GetMaxRow();
    int     nCol        = (DDE_GLOBAL::excel_server_info)->GetMaxCol();
    int     endRow, endCol;

    //
    // Check to see if we have enough row and col to accommendate
    // the string
    //
    // The dumb way...
    int num_row_needed = 1;
    int num_col_needed = 1;
    int current_col_needed = 1;

    //
    // Num of col = max width of the spreadsheet, if 
    // (DDE_GLOBAL::excel_server_info)->row_seperator is seen, check the num col needed 
    // for this row.
    //

    //
    // kludge before I have time to use ADS_STRING functions...
    //
    char *temp_ptr = ( char * )send_string.CString();
    while ( *temp_ptr != EOS 
        && ( temp_ptr = strpbrk( temp_ptr
                                , (DDE_GLOBAL::excel_server_info)->seperators.CString() ) ) 
           != NULL )
    {
        if ( strncmp( (DDE_GLOBAL::excel_server_info)->row_seperator.CString()
                    , temp_ptr
                    , (DDE_GLOBAL::excel_server_info)->row_seperator.Length() ) == 0 )
        {
            num_row_needed++;
            if ( current_col_needed > num_col_needed )
            {
                num_col_needed = current_col_needed;
            }
            current_col_needed = 1;
        }
		else if ( strncmp( (DDE_GLOBAL::excel_server_info)->col_seperator.CString()
                        , temp_ptr
                        , (DDE_GLOBAL::excel_server_info)->col_seperator.Length() ) == 0 )
        {
            current_col_needed++;
        }
        temp_ptr++;
    }

    if ( ( nRow - startRow ) < num_row_needed 
        || ( nCol - startCol ) < num_col_needed )
    {
        ::MessageBox( GetFocus()
                    , "Hit the spreadsheet limit, item name not build, transfer incomplete"
                    , "ADS Dde transfer information"
                    , MB_OK );
        Reset();
        return NULL;
    }

    char    NumStr[20];

    endRow = num_row_needed + startRow - 1;
    endCol = num_col_needed + startCol - 1;

    if ( endCol > max_range_col )
    {
        max_range_col = endCol;
    }

    if ( endRow > max_range_row )
    {
        max_range_row = endRow;
    }

    string = (DDE_GLOBAL::excel_server_info)->ssrow;
    _itoa( startRow, NumStr, 10 );
    string += NumStr;
    string += (DDE_GLOBAL::excel_server_info)->sscol;
    _itoa( startCol, NumStr, 10);
    string += NumStr;

    if ( nRow == 1 && nCol == 1 )
    {
        return Handle();
    }
    string += (DDE_GLOBAL::excel_server_info)->ssdelim;

    string += (DDE_GLOBAL::excel_server_info)->ssrow;
    _itoa( endRow, NumStr, 10 );
    string += NumStr;

    string += (DDE_GLOBAL::excel_server_info)->sscol;
    _itoa( endCol, NumStr, 10 );
    string += NumStr;

    //
    // Update the spread sheet server_info here, set current row and col
    //
    (DDE_GLOBAL::excel_server_info)->SetCurRow( endRow + 1 );
    
    return NewHandle( string );    
}

//-----------------------------------------------------------------------------
HSZ EXCEL_ITEM::Range()
{
    char    NumStr[20];

    range_string = (DDE_GLOBAL::excel_server_info)->ssrow;
    range_string += "1";
    range_string += (DDE_GLOBAL::excel_server_info)->sscol;
    range_string += "1";

    range_string += (DDE_GLOBAL::excel_server_info)->ssdelim;

    range_string += (DDE_GLOBAL::excel_server_info)->ssrow;
    _itoa( max_range_row, NumStr, 10 );
    range_string += NumStr;

    range_string += (DDE_GLOBAL::excel_server_info)->sscol;
    _itoa( max_range_col, NumStr, 10 );
    range_string += NumStr;

    if ( hrange != 0 )
    {
        DdeFreeStringHandle( DDE_GLOBAL::GetInstId(), hrange );
    }
    hrange = DdeCreateStringHandle( DDE_GLOBAL::GetInstId()
                                    , ( char* ) range_string.CString()
                                    , CP_WINANSI );
    return hrange;    
    
}

//-----------------------------------------------------------------------------
EXCEL_ITEM::~EXCEL_ITEM()
{
    if ( hrange != 0 )
    {
        DdeFreeStringHandle( DDE_GLOBAL::GetInstId(), hrange );
        hrange = 0;
    }
}

