/* 
    DDEINFO.H -
    
    This file:

        Declare specific DDE server information.  

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef __DDEINFO_H_
#define __DDEINFO_H_

#include "ddeinc.h"

//-----------------------------------------------------------------------------
enum DDESERVER
{
    MSEXCEL
    , LOTUS123
    , R13ACAD
    , UNKNOWNSERVER
};

//-----------------------------------------------------------------------------
struct SERVER_INFO;
struct SS_SERVER_INFO;

//-----------------------------------------------------------------------------
#define     SPREAD_SHEET_MAX_ROW    16384
#define     SPREAD_SHEET_MAX_COL    200
#define     EXCEL_MAX_ROW           SPREAD_SHEET_MAX_ROW
#define     EXCEL_MAX_COL           SPREAD_SHEET_MAX_COL

#define     EXCEL_REG_KEY           "ExcelWorksheet\\protocol\\StdFileEditing"
#define     ACAD_REG_KEY            "AutoCAD-r13\\protocol\\StdFileEditing"

#define     EXCEL_ROW               "R"
#define     EXCEL_COL               "C"
#define     EXCEL_DELIM             ":"
#define     EXCEL_ROW_SEPERATOR     "\n"
#define     EXCEL_COL_SEPERATOR     "\t"

//-----------------------------------------------------------------------------
struct SERVER_INFO : ADS_OBJ
{                                              
    ADS_STRING                  exepath;
    void                        Start();
    BOOL                        Ready( HSZ service, HSZ topic, HSZ item );
                                SERVER_INFO();
                                SERVER_INFO( char *regkey, DDESERVER id );
    virtual                     ~SERVER_INFO();
    DDESERVER                   server_id;
    BOOL                        Valid();
    BASIC_CPP_STUFF(SERVER_INFO)
};
//-----------------------------------------------------------------------------
inline BOOL SERVER_INFO::Valid() 
{ 
    return exepath[ 0 ]; 
}

//-----------------------------------------------------------------------------
inline SERVER_INFO& SERVER_INFO::operator=( const SERVER_INFO& src )
{
    server_id = src.server_id;
    exepath = src.exepath;
    return *this;
}
//-----------------------------------------------------------------------------
inline SERVER_INFO::SERVER_INFO( const SERVER_INFO& src)
{
    server_id = src.server_id;
    exepath = src.exepath;
}

//-----------------------------------------------------------------------------
struct SS_SERVER_INFO : SERVER_INFO
{
    ADS_STRING                  ssrow;
    ADS_STRING                  sscol;
    ADS_STRING                  ssdelim;
    ADS_STRING                  row_seperator;
    ADS_STRING                  col_seperator;
    ADS_STRING                  seperators;
    
    int                         cur_row;
    int                         GetCurRow() { return cur_row; }
    int                         SetCurRow( int new_row ) 
                                { 
                                    cur_row = new_row; 
                                    return cur_row; 
                                }

    int                         cur_col;
    int                         GetCurCol() { return cur_col; }
    int                         SetCurCol( int new_col ) 
                                { 
                                    cur_col = new_col; 
                                    return cur_col;
                                }

    int                         max_row;
    int                         GetMaxRow() { return max_row; }
    int                         max_col;
    int                         GetMaxCol() { return max_col; }

                                SS_SERVER_INFO( char *regkey 
                                                , int _max_row
                                                , int _max_col 
                                                , int _cur_row
                                                , int _cur_col 
                                                , char *_ssrow
                                                , char *_sscol
                                                , char *_ssdelim
                                                , char *_row_sep
                                                , char *_col_sep
                                                , DDESERVER id );
    virtual                     ~SS_SERVER_INFO();
    BASIC_CPP_STUFF(SS_SERVER_INFO)
};

//-----------------------------------------------------------------------------


#endif
