/* 
    DDEGLOB.CPP -
    
    This file:

        Defines global objects DDE_GLOBAL, this object is 
        created once and only once to set up some essential
        information in a ADS DDE application, such as connection
        to ACAD and the global DDE instance ID.


    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

#ifdef DDEADS_DBG
static char     dbg_string[256];
#endif

//-----------------------------------------------------------------------------
// 
// This variable should be the only DDE variable in a program
//
//-----------------------------------------------------------------------------
DWORD                   DDE_GLOBAL::InstId = 0;
SERVER_INFO*            DDE_GLOBAL::acad_info = NULL;
DDE_CLIENT_CONNECTION*  DDE_GLOBAL::acad_connection = NULL;
SS_SERVER_INFO*         DDE_GLOBAL::excel_server_info = NULL;

DDE_GLOBAL              dde_global;

//-----------------------------------------------------------------------------
DDE_GLOBAL::DDE_GLOBAL()
{
    //
    // First step: initialize the instance id
    //
    if ( DdeInitialize( &InstId
                        , ( PFNCALLBACK ) ( FARPROC )DDE_CLIENT_CONNECTION::ClientCallBack
                        , APPCMD_CLIENTONLY
                        , 0 )
                        != DMLERR_NO_ERROR )
    {
        ::MessageBox( 0
                    , "Initialization failed."
                    , "DDEML client connection"
                    , MB_ICONSTOP|MB_TASKMODAL);
        exit( 0 );
    }
#ifdef DDEADS_DBG
    wsprintf( dbg_string
            , " DdeInitialized: this = %lx InstId = %lx"
            , this
            , InstId );
    OutputDebugString( dbg_string );
#endif

    //
    // Initialize acad connection
    //
    acad_info = new SERVER_INFO( ACAD_REG_KEY, R13ACAD );
    acad_connection = new DDE_CLIENT_CONNECTION( *acad_info );
    acad_connection->Init( ADS_STRING( "AutoCAD.r13.DDE" )
                            , ADS_STRING( "System" )
                            , ADS_STRING( "" ) );
    ( DDE_GLOBAL::acad_connection )->SetupConnection();
    
    //
    // Initialize excel connection
    //
    excel_server_info = new SS_SERVER_INFO( EXCEL_REG_KEY
                                            , EXCEL_MAX_ROW
                                            , EXCEL_MAX_COL
                                            , 1
                                            , 1
                                            , EXCEL_ROW
                                            , EXCEL_COL
                                            , EXCEL_DELIM
                                            , EXCEL_ROW_SEPERATOR
                                            , EXCEL_COL_SEPERATOR 
                                            , MSEXCEL );
    //
    // Initialize other server connections here
    //
}

//-----------------------------------------------------------------------------
DDE_GLOBAL::~DDE_GLOBAL()
{
    delete excel_server_info; excel_server_info = NULL;
    delete acad_connection; acad_connection = NULL;
    delete acad_info; acad_info = NULL;

    //
    // Last step: deinitialize the instance ID
    //
    if ( DdeUninitialize( InstId ) == TRUE )
    {
        InstId = 0;
    }
    else
    {
        DWORD err = GetLastError();
        
        ::MessageBox( 0
                    , "UnInitialization failed."
                    , "DDEML client connection"
                    , MB_ICONSTOP|MB_TASKMODAL);
    }
}

