#
#   DDEADS.MAK -
#
#      makefile for DDEADSPP.EXE
#
#      (C) Copyright 1988-1994 by Autodesk, Inc.
#
#      This program is copyrighted by Autodesk, Inc. and is  licensed
#      to you under the following conditions.  You may not distribute
#      or  publish the source code of this program in any form.   You
#      may  incorporate this code in object form in derivative  works
#      provided  such  derivative  works  are  (i.) are  designed and
#      intended  to  work  solely  with  Autodesk, Inc. products, and
#      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
#      1988-1994 by Autodesk, Inc."
#
#      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
#      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
#      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
#      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
#      UNINTERRUPTED OR ERROR FREE.
#
!include <..\..\adsmake.nt>
!include <ddeads.inc>

VPATH     = $(DDEADS_OBJ_DIR)
LOCINC    = $(ADS_CPP)\ADSCPP $(ADS_CPP)\GENERAL $(ADS_CPP)\DDE $(ADS)

ADSLIB          = $(ACOBJ)\ADS\WINADS.LIB

all: $(ACEXE)\DDEADSPP.EXE
            
LINK_LIBS = $(MFCLIB) $(guilibsmt) SHELL32.LIB ADVAPI32.LIB $(ADSLIB)
LINK_OBJS = $(BASEOBJS) $(DDEADSOBJS) $(ADSCPPOBJS) $(DDEOBJS)

$(ACEXE)\DDEADSPP.EXE: $(LINK_OBJS) $(VPATH)\$(@B).res $(MAKEFILE) $(DDEOBJ) $(BASEOBJS)
    echo Linking $(ac_ldebug_echo) $@
    $(link)  @<<$(CVDBUG) 
    $(VPATH)\$(@B).res $(LINK_OBJS)
	$(ads_lflags) $(USRLFLAGS)
	-nodefaultlib -MACHINE:IX86
	$(LINK_LIBS)
	$(ac_ldebug_flags)
	-out:$@
<<

# --- default rules for making .exe ---
{.}.cpp{$(VPATH)}.obj:
    echo Compiling $(@B).cpp
    if exist $@ del $@
    $(COMP) -Tp$(@B).cpp $(ERRSTUFF)
    $(POSTERR)

{.}.rc{$(VPATH)}.res:
    echo Compiling Resource $@
    rc -Fo$(VPATH)\$(@B).res $(@B).rc

clean:
	echo Cleaning DDEADS Objects
	if not exist $(DDEADS_OBJ_DIR) mkdir $(DDEADS_OBJ_DIR)
    if exist $(DDEADS_OBJ_DIR)\*.* del /Q $(DDEADS_OBJ_DIR)\*.*
    if exist $(DDEADS_DIR)\*.pdb del /Q $(DDEADS_DIR)\*.pdb
    if exist $(ACEXE)\DDEADSPP.* del /Q $(ACEXE)\DDEADSPP.*
