/* 
    DDEADS.H -
    
    This file:

        Declares DDE functions to simulate the DDEADS functions
        in R12.  These functions are not fully implemented, they
        are only used to show the usage of DDE classes.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef DDEADS_H
#define DDEADS_H

#include    "adscpp.h"
#include    "ddeinc.h"

//-----------------------------------------------------------------------------
void    fddedlgstart(struct resbuf *);
void    fddedialog(struct resbuf *);
int     fddedrawing(struct resbuf *);
int     fddeblocks(struct resbuf *);
int     fddesset(struct resbuf *);
int     fddeupdate(struct resbuf *);
int     fddeformat(struct resbuf *);
int     fddedefaults(struct resbuf *);
int     doddetransfer( struct resbuf *);

//-----------------------------------------------------------------------------
class DDEADS_APP;
class CLIENT_CHANNELS;
class CHANNELS;

//-----------------------------------------------------------------------------
class CLIENT_CHANNEL : ADS_OBJ
{
    friend class CHANNELS;

    DDE_CLIENT_CONNECTION   *channel;
    CLIENT_CHANNEL          *next;
                            CLIENT_CHANNEL( DDE_CLIENT_CONNECTION * chnl)
                            {
                                channel = chnl;
                            }
                            ~CLIENT_CHANNEL(){ delete channel; }
    BOOL                    Valid() { return ( channel != NULL ); }

    BASIC_CPP_STUFF(CLIENT_CHANNEL)
};

//-----------------------------------------------------------------------------
class CHANNELS : ADS_OBJ
{
    friend class DDEADS_APP;

    CLIENT_CHANNEL          *head;
    CLIENT_CHANNEL          *tail;
    CLIENT_CHANNEL          *current;
    int                     count;
                            CHANNELS() : tail( NULL ), head( NULL )
                                       , count( 0 ), current( NULL ){}
                            ~CHANNELS()
                            {
                                while ( head )
                                {
                                    current = head->next;
                                    delete head;
                                    head = current;
                                }
                                count = 0;
                                head = current = tail = NULL;
                            }
    int                     Add( DDE_CLIENT_CONNECTION* new_connection );
    int                     Remove( int chnl );
    int                     SetCurrent( int chnl )
                            {
                                ASSERT( chnl < count );
                                current = head;
                                while( --chnl )
                                {
                                    current = current->next;
                                }
                                return chnl;
                            }
    BOOL                    Valid() { return ( head != NULL  ); }
    DDE_CLIENT_CONNECTION   *Current()
                            {
                                return ( ( current ) ? ( current->channel ) : NULL );
                            }

    BASIC_CPP_STUFF(CHANNELS)
};

//-----------------------------------------------------------------------------
class DDEADS_APP : public ADS_APP
{
    CHANNELS                channels;
public:
    DDE_CLIENT_CONNECTION*  CurChannel() 
                            { 
                                return channels.Current(); 
                            }
    int                     AddChannel( DDE_CLIENT_CONNECTION* conx )
                            {
                                return channels.Add( conx );
                            }
    int                     ExportDrawing();
    BOOL                    ImportDrawing();
    BOOL                    StartHotLink();
                            DDEADS_APP( int argc, char **argv );
                            ~DDEADS_APP(){}
private:
    BASIC_CPP_STUFF( DDEADS_APP )
};

#endif
