/* 
    ADSCPP.CPP -
    
    This file:

    Defines general ADS application object, ADS_APP.  This 
    application object is to be used when ads_main() is employed 
    instead of WinMain().
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "adscpp.h"

//-----------------------------------------------------------------------------
ADS_APP     *main_app = NULL;

//-----------------------------------------------------------------------------
ADS_APP* GetAdsApp()
{
    ASSERT ( main_app != NULL );
    return main_app;
}

//-----------------------------------------------------------------------------
ADS_APP::DISPATCHER  ADS_APP::dispatcher[] =
{
    { RQXLOAD,      &ADS_APP::LOADFun }
    , { RQSUBR,     &ADS_APP::SUBRFun }
    , { RQXUNLD,    &ADS_APP::UNLDFun }
    , { RQEND,      &ADS_APP::ENDFun }
    , { RQQUIT,     &ADS_APP::QUITFun }
    , { RQSAVE,     &ADS_APP::SAVEFun }
    , { RQHUP,      &ADS_APP::HUPFun }
    , { RQCFG,      &ADS_APP::CFGFun }
};

//-----------------------------------------------------------------------------
ADS_APP::ADS_APP(int argc, char **argv)
{
    ads_init(argc, argv);

    LOAD_status = RTNORM;
    UNLD_status = RTERROR;
    SUBR_status = RTNORM;
    num_funs = 0;
    num_run_funs = 0;
    app_state = APP_OK;
}

//-----------------------------------------------------------------------------
int ADS_APP::InsertExternFunc(ADS_FUNC_INFO& target)
{
    if (num_funs < MAX_ADS_FUNC)
    {
        target.func_code = num_funs;    // zero based
        exfuns[num_funs++] = target;
        return num_funs;
    }
    else
    {
        return -1;
    }
}

//-----------------------------------------------------------------------------
int ADS_APP::LOADFun()
{
    int i;
    for (i = 0; i < num_funs; i++) 
    {
        if ( !ads_defun(exfuns[i].extern_name, i) )
        {
            LOAD_status = RTERROR;
            break;
        }
        else
        {
            ads_printf(exfuns[i].message);
        }
    }
    return ( (LOAD_status == RTNORM) ? -RSRSLT : -RSERR);
}


//-----------------------------------------------------------------------------
int ADS_APP::UNLDFun()
{
    UNLD_status = RTNORM;
    for (int i = 0; i < num_funs; i++) 
    {
        if (ads_undef(exfuns[i].extern_name,i) == RTERROR)
        {
            UNLD_status = RTERROR;
        }
    }
    app_state = APP_DONE;
    ads_printf( "Unloading.\n" );
    return ( (UNLD_status == RTNORM) ? -RSRSLT : - RSERR);
}

//-----------------------------------------------------------------------------
int ADS_APP::Run()
{
    short   scode = RSRSLT;             /* Normal result code (default) */
    int     stat;

    while ( app_state != APP_DONE )
    {
        if ( ( stat = ads_link( scode ) ) < 0 )
        {
            return (1);
        }
        //
        // Dispatching the result
        //
        scode = RSRSLT;
        int i;
        for ( i = 0; i < ARRAY_SIZE( dispatcher ); i++ )
        {            
            if ( dispatcher[i].command == stat)
            {
                scode = ( this->*dispatcher[i].rsp_fun )();
                break;
            }            
        }

        if ( num_run_funs != 0 )
        {
            while ( --num_run_funs )
            {
                ( this->*run_funs[ num_run_funs ] )();
            }
        }
    }
    ads_link( scode );
    return 1;
}

//-----------------------------------------------------------------------------
int ADS_APP::SUBRFun()
{
    struct resbuf *rb=NULL;
    int func_code = ads_getfuncode();

    if ( func_code< 0 
        || func_code > num_funs )
        //
        // We should check the arguments here
        //
        // || ((rb = ads_getargs()) == NULL))
    {
        return 0;
    }

    switch (exfuns[func_code].func_type)
    {
        case ADS_INT_FUNC:
        {
            ads_retint(exfuns[func_code].extern_func.calling_fun.AdsIntFunc(rb));
        }
        break;

        case ADS_VOID_FUNC:
        {
            exfuns[func_code].extern_func.calling_fun.AdsVoidFunc(rb);
            ads_retvoid();
        }
        break;

        case ADS_REAL_FUNC:
        {
            ads_retreal(exfuns[func_code].extern_func.calling_fun.AdsRealFunc(rb));
        }
        break;
    }
    return ( (SUBR_status == RTERROR) ? RSERR : RSRSLT);
}

/******************************************************************************

                ADS_FUNC_INFO member functions    
    
******************************************************************************/
//-----------------------------------------------------------------------------
ADS_FUNC_INFO::ADS_FUNC_INFO(ADS_FUNC _extern_func
                            , ADS_FUNC_TYPE _ads_func_type
                            , char *_extern_name
                            , char *_message):extern_func(_extern_func)
{
    func_type = _ads_func_type;
    
    strcpy(extern_name, _extern_name);
    
    if ( _message == NULL)
    {
        message[0] = '\0';
    }
    else
    {
        strcpy(message, _message);
    }
}
