@echo off
:: --------------------------------------------------------------------
:: (C) Copyright 1990-1994 by Autodesk, Inc.
:: Permission to use, copy, modify, and distribute this software and its
:: documentation for any purpose and without fee is hereby granted.   
:: THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
:: ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
:: MERCHANTABILITY ARE HEREBY DISCLAIMED.                                 
:: --------------------------------------------------------------------
::
::        Sample batch file to create an R13 ADS program 
::           using 32-bit MSVC++ and Phar Lap 6
::
:: This batch file demonstrates how to build an R13 DOS ADS program. You will
:: need the 32-bit edition Microsoft Visual C++ compiler (1.1 or greater)
:: and Phar Lap 6.x TNT SDK.
:: Be sure you use the updated DOSADS.LIB supplied along with this batch 
:: (see the readme for more information).

:: check to be sure filename is first parameter
if (%1) == () goto noname

:: Location of root directory of MSVC++ 32-bit compiler 
set VC=\msvc32s

:: Location of root directory of Phar Lap SDK
set PHARLAP=\pharlap

:: Location of ADS include files
set ADSINC=\acad\ads

:: Location of ADS library and MVCADS.LNK files
set ADSLIB=\acad\ads

:: Tells compiler where to look for include files
set INCLUDE=%VC%\include;%ADSINC%

:: Tells linker where to search for library and object files
set LIB=%PHARLAP%\lib;%VC%\lib;%ADSLIB%

:: Save the current path so it can be restored later
set SAVPTH=%path%

:: Add MSVC++ and Phar Lap to path
set PATH=%VC%\bin;%PHARLAP%\bin;%path%;

:: compile the source
cl %1.c -Fo%1.obj -c -omf -Ox -Zp1 -DADS=1 -DPROTOTYPES=1 -W3

:: link to a .EXP using Phar Lap's linker
386link %1.obj -sym -exe %1.exp -lib MVCADS13.LIB @%ADSLIB%\mvcads13.lnk

:: clean up the DOS environment
set PATH=%SAVPTH%
set SAVPTH=
set VC=
set INCLUDE=
set PHARLAP=
set LIB=
set ADSINC=
set ADSLIB=

goto end

:noname
@echo Syntax: MKMSVC13 [FILENAME with no extension]

:end
