// Next available MSG number is   392 
// MODULE_ID RENDCOMM_DCL_

//     Copyright (C) 1991, 1992, 1993, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//.

//****************************************************************************
//
// Common Render Dialogue Control Language (DCL) -- Version 1.0
//
//****************************************************************************

//***************************************************************************
// Support dialog box code

var_text : text_part { label = ""; }

//***************************************************************************
// Information dialog box
 
pref_info : dialog {
    label = /*RENDCOMM_DCL_1*/"Render Information";

    : text_part {
        alignment = centered;
        label = /*RENDCOMM_DCL_2*/"AutoCAD Render";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"prodname";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"cyears";
    }
    : text_part {
        alignment = centered;
        label = /*RENDCOMM_DCL_3*/"by Autodesk, Inc.  All Rights Reserved.";
    }
    : var_text {
        alignment = centered;
        key = /*MSG0*/"release";
    }
    spacer_1;
    : text_part {
        alignment = left;
        label = /*RENDCOMM_DCL_4*/"Current Configuration:";
    }
    : concatenation {
        : text_part {label = /*RENDCOMM_DCL_5*/"Rendering: "; }
        : var_text {
            key = /*MSG0*/"rendering";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = "           "; }
        : var_text {
            key = /*MSG0*/"rendname";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = /*RENDCOMM_DCL_6*/"Hardcopy: "; }
        : var_text {
            key = /*MSG0*/"hardcopy";
            width = 60;
        }
    }
    : concatenation {
        : text_part { label = /*MSG0*/"           "; }
        : var_text {
            key = /*MSG0*/"hardname";
            width = 60;
        }
    }
    : list_box { 
        key = /*MSG0*/"extras";
        height = 5;
        width = 60;
        multiple_select = false;
        allow_accept = false;
    }
    spacer_1_ok_only;
}

//****************************************************************************
// For showing real numbers.
 
text_part_12 : text_part { width = 12; }
 
//****************************************************************************
// Standard size list_box
 
list_box_8x8 : list_box {
    height = 8;          // (10x10) width includes scrollbar.
}
 
//****************************************************************************
// For File name, where max filename = 100.
 
edit_box_100 : edit_box {
    edit_width = 14;
    edit_limit = 100;
}
 
//****************************************************************************
// For Directory paths , where max pathname = 256.
 
edit_box_256 : edit_box {
    edit_width = 14;
    edit_limit = 256;
}
 
//****************************************************************************
// For File names and the like.
 
edit_box_14 : edit_box {
    edit_width = 14;
    edit_limit = 14;
}
 
//****************************************************************************
// For names that are <= 8 characters long.
 
edit_box_8 : edit_box {
//  edit_width = 8;
    edit_width = 15;  // used since Windows has variable width fonts and
                      // proteus uses the wrong width
    edit_limit = 8;
}
 
//****************************************************************************
// For names that are <= 16 characters long.
 
edit_box_16 : edit_box {
    edit_width = 16;
    edit_limit = 16;
}
 
//****************************************************************************
// For real numbers 0.00->1.00.
 
edit_box_4 : edit_box {
    edit_width = 4;
    edit_limit = 4;
}
 
//****************************************************************************
// For real numbers 0.000->1.000 (or nE-mm)
 
edit_box_6 : edit_box {
    edit_width = 6;
    edit_limit = 6;
}
 
//****************************************************************************
// For real numbers 0.00->1.00.
 
slider_0_1 : slider {
    min_value = 0;
    max_value = 100;
    small_increment = 1;
    big_increment = 10;
    is_tab_stop = false;        //  We have edit_boxes for all
}
 
//****************************************************************************
// Fixed slider for real numbers 0.00->1.00.
 
slider_0_1_fixed : slider {
    min_value = 0;
    max_value = 100;
    width = 16;
    fixed_width = true;
    alignment = centered;
    small_increment = 1;
    big_increment = 10;
    is_tab_stop = false;        //  We have edit_boxes for all
}
 
//****************************************************************************
//  Spacer tiles
 
spacer_0_1: spacer {
    height = 0.1;
}
 
spacer_0_25: spacer {
    height = 0.25;
}
 
spacer_0_5: spacer {
    height = 0.5;
}
 
spacer_1_25 : spacer {
    height = 1.25;
}
 
spacer_1_5 : spacer {
    height = 1.5;
}
 
//****************************************************************************
//  Dialogs with Cancel as the default.
 
cancel_ok_48 : dialog {
    width = 48;
    key = /*MSG0*/"dialog";
    initial_focus = /*MSG0*/"cancel"; // Doesn't work allways
    children_alignment = centered;
    spacer_1;
    : var_text { key = /*MSG0*/"line1"; }
    : var_text { key = /*MSG0*/"line2"; }
    cancel_ok;                          // Makes "Cancel" the default.
}

cancel_ok_32 : dialog {
    width = 32 ;
    key = /*MSG0*/"dialog";
    initial_focus = /*MSG0*/"cancel"; // Doesn't work allways
    children_alignment = centered;
    spacer_1;
    : var_text { key = /*MSG0*/"line1"; }
    : var_text { key = /*MSG0*/"line2"; }
    cancel_ok;                          // Makes "Cancel" the default.
}

cancel_ok : column {        // Makes "Cancel" the default.
    spacer_1;
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { is_default = false; }
        : spacer { width = 2; }
        : cancel_button { is_default = true; }
    }
}


//****************************************************************************
//  Generic botton-line button combinations
 
spacer_0_1_ok_cancel_help_errtile : column {
    spacer_0_1;
    ok_cancel_help_errtile;
}
 
spacer_1_ok_cancel_help_errtile : column {
    spacer_1;
    ok_cancel_help_errtile;
}
 
spacer_1_ok_cancel_help : column {
    spacer_1;
    ok_cancel_help;
}
 
spacer_1_ok_help : column {
    spacer_1;
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { is_cancel = true; }
        : spacer { width = 2; }
        help_button;
    }
}
 
spacer_1_ok_only : column {
    spacer_1;
    ok_only;
}

 
//****************************************************************************
// Define common widgets
 
button_new : button {
    key = /*MSG0*/"new";
    label = /*RENDCOMM_DCL_7*/"New...   ";
    mnemonic = /*RENDCOMM_DCL_8*/"N";
}
 
button_mod : button {
    key = /*MSG0*/"modify";
    label = /*RENDCOMM_DCL_9*/"Modify...";
    mnemonic = /*RENDCOMM_DCL_10*/"M";
    is_enabled = false;     // Enable when Items are selected.
}
 
button_dup : button {
    key = /*MSG0*/"duplicate";
    label = /*RENDCOMM_DCL_11*/"Duplicate...";
    mnemonic = /*RENDCOMM_DCL_12*/"u";
    is_enabled = false;     // Enable when Items are selected.
}
 
button_del : button {
    key = /*MSG0*/"delete";
    label = /*RENDCOMM_DCL_13*/"Delete   ";
    mnemonic = /*RENDCOMM_DCL_14*/"D";
    is_enabled = false;     // Enable when Items are selected.
}
 
button_imp : button {
    key = /*MSG0*/"import";
    label = /*RENDCOMM_DCL_15*/"Materials Library...";
    mnemonic = /*RENDCOMM_DCL_16*/"L";
}
 
button_exp : button {
    key = /*MSG0*/"export";
    label = /*RENDCOMM_DCL_17*/"Export   ";
    mnemonic = /*RENDCOMM_DCL_18*/"x";
}
 
button_pkt : button {
    key = /*MSG0*/"pickit";
    label = /*RENDCOMM_DCL_19*/"Select <   ";
    mnemonic = /*RENDCOMM_DCL_20*/"S";
}

/******************************************************************************/
/*********************** GENERIC COLORSYSTEM SLIDER SET ***********************/
/******************************************************************************/
color_system_set : row {
    key = /*MSG0*/"color_system_set";
    : column {
        : text {
            key = /*MSG0*/"Red_txt";
            label = /*RENDCOMM_DCL_21*/"Hue:";
        }
        : text {
            key = /*MSG0*/"Green_txt";
            label = /*RENDCOMM_DCL_22*/"Lightness:";
        }
        : text {
            key = /*MSG0*/"Blue_txt";
            label = /*RENDCOMM_DCL_23*/"Saturation:";
        }
    }
    : column {
        : edit_box_4 {
            key = /*MSG0*/"red_edit";
        }
        : edit_box_4 {
            key = /*MSG0*/"green_edit";
        }
        : edit_box_4 {
            key = /*MSG0*/"blue_edit";
        }
    }
    : column {
        : slider_0_1_fixed { key = /*MSG0*/"red_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"green_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"blue_slider"; }
    }
}


//****************************************************************************
// Black Cat dialog boxes
//****************************************************************************
//3DS input
object_list : list_box
{
    label   = /*RENDCOMM_DCL_24*/"Object Name:          Type:";
    tabs    = /*MSG0*/"18";
    height  = 7;
    width   = 28;
    multiple_select = true;
}


//****************************************************************************
//
//****************************************************************************
// this is a clone of ok_cancel_help, without a default button
okNoDef_cancel_help : column 
{
    : row 
    {
        fixed_width = true;
        alignment = centered;
        : ok_button 
        {
            is_default      = false;
        }
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
}
//****************************************************************************
//
//****************************************************************************
// 
bc3dsin : dialog
{
    label   = /*RENDCOMM_DCL_25*/"3D Studio File Import Options";

    : column {
        : row {
            : column {
                : boxed_column {
                    label           = /*RENDCOMM_DCL_26*/"Available Objects";
                    : object_list {
                        key     = /*MSG0*/"available";
                    }
                    : row {
                        children_fixed_width    = true;

                        spacer_1;
                        : button {
                            key     = /*MSG0*/"selall";
                            label   = /*RENDCOMM_DCL_27*/"Add All";
                            mnemonic = /*RENDCOMM_DCL_28*/"A";
                            is_default = true;
                        }
                        : button {
                            key     = /*MSG0*/"select";
                            label   = /*RENDCOMM_DCL_29*/"Add";
                            mnemonic = /*RENDCOMM_DCL_30*/"d";
                        }
                        spacer_1;
                    }
                }
                spacer_1;
                : boxed_radio_column
                {
                    label           = /*RENDCOMM_DCL_31*/"Save to Layers:";
                    : radio_button
                    {
                        key     = /*MSG0*/"byobject";
                        label   = /*RENDCOMM_DCL_32*/"By Object";
                        mnemonic = /*RENDCOMM_DCL_33*/"O";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"bymaterial";
                        label   = /*RENDCOMM_DCL_34*/"By Material";
                        mnemonic = /*RENDCOMM_DCL_35*/"M";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"bycolor";
                        label   = /*RENDCOMM_DCL_36*/"By Object Color";
                        mnemonic = /*RENDCOMM_DCL_37*/"B";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"onelayer";
                        label   = /*RENDCOMM_DCL_38*/"Single Layer";
                        mnemonic = /*RENDCOMM_DCL_39*/"L";
                    }
                }
            }
            spacer_1;
            : column
            {
                : boxed_column {       
                    label           = /*RENDCOMM_DCL_40*/"Selected Objects";
                    : object_list {
                        key     = /*MSG0*/"selected";
                    }
                    : row
                    {
                        children_fixed_width    = true;
                
                        spacer_1;
                        : button
                        {
                            key     = /*MSG0*/"remove";
                            label   = /*RENDCOMM_DCL_41*/"Remove";
                            mnemonic = /*RENDCOMM_DCL_42*/"R";
                        }
                        : button
                        {
                            key     = /*MSG0*/"rmvall";
                            label   = /*RENDCOMM_DCL_43*/"Remove All";
                            mnemonic = /*RENDCOMM_DCL_44*/"v";
                        }
                        spacer_1;
                    }
                }
                spacer_1;
                : boxed_radio_column
                {
                    label           = /*RENDCOMM_DCL_45*/"Multiple Material Objects:";
                    : radio_button
                    {
                        key     = /*MSG0*/"prompt";
                        label   = /*RENDCOMM_DCL_46*/"Always Prompt";
                        mnemonic = /*RENDCOMM_DCL_47*/"P";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"break";
                        label   = /*RENDCOMM_DCL_48*/"Split by Material";
                        mnemonic = /*RENDCOMM_DCL_49*/"S";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"first";
                        label   = /*RENDCOMM_DCL_50*/"Assign First Material";
                        mnemonic = /*RENDCOMM_DCL_51*/"F";
                    }
                    : radio_button
                    {
                        key     = /*MSG0*/"none";
                        label   = /*RENDCOMM_DCL_52*/"Don't Assign a Material";
                        mnemonic = /*RENDCOMM_DCL_53*/"n";
                    }
                }
            }
        }
        spacer_1;
        okNoDef_cancel_help;
    }
}


//****************************************************************************
//
//****************************************************************************
bcmatls : dialog
{
    label   = /*RENDCOMM_DCL_54*/"Material Assignment Alert";
    
    : text {
        key     = /*MSG0*/"objname";
        width   = 50; /* "Object1234567890 has multiple materials assigned" */
    }
    : boxed_column {
        label                   = "";
        children_alignment      = centered;
        children_fixed_width    = true;

        : radio_column {
            : radio_button {
                key     = /*MSG0*/"breakapart";
                label   = /*RENDCOMM_DCL_55*/"Split Object By Material";
                mnemonic = /*RENDCOMM_DCL_56*/"S";
            }
            : radio_button {
                key     = /*MSG0*/"applyfirst";
                label   = /*RENDCOMM_DCL_57*/"Assign First Material";
                mnemonic = /*RENDCOMM_DCL_58*/"A";
            }
            : radio_button {
                key     = /*MSG0*/"applyone";
                label   = /*RENDCOMM_DCL_59*/"Select a Material:";
                mnemonic = /*RENDCOMM_DCL_60*/"M";
            }
        }
        : row {
            : popup_list {
                key     = /*MSG0*/"materials";
                value   = "0";
                edit_width  = 25;
            }
        }
    }
    spacer_1;
    ok_cancel_help;
}


//****************************************************************************
//
//****************************************************************************
// this is a clone of ok_cancel_help 
rename_cancel_replace : column 
{
    : row 
    {
        fixed_width = true;
        alignment = centered;
        : retirement_button 
        {
            label           = /*RENDCOMM_DCL_61*/" Rename ";
            key             = /*MSG0*/"rename";
            is_default      = true;
        }
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        : retirement_button 
        {
            label           = /*RENDCOMM_DCL_62*/" Replace ";
            key             = /*MSG0*/"replace";
            mnemonic        = /*RENDCOMM_DCL_63*/"R";
        }
    }
}


//****************************************************************************
//
//****************************************************************************
bcrenmat : dialog
{
    label   = /*RENDCOMM_DCL_64*/"Mordred Message";

    : text 
    {
        key     = /*MSG0*/"prompt";
        width   = 40;
    }
    : text 
    {
        label = /*RENDCOMM_DCL_65*/"Do you want to replace it?";
    }
    spacer_1;
    rename_cancel_replace;
}

//****************************************************************************
// 3DS Output
//****************************************************************************
outOptions : dialog
{
  label = /*RENDCOMM_DCL_66*/"3D Studio File Export Options";

  :boxed_radio_column
  {
    label = /*RENDCOMM_DCL_67*/"Derive 3D Studio Objects From";
    key = /*MSG0*/"method";
    :radio_button
    {
      label = /*RENDCOMM_DCL_68*/"Layer";
      key = /*MSG0*/"methLay";
      mnemonic = /*RENDCOMM_DCL_69*/"L";
    }
    :radio_button
    {
      label = /*RENDCOMM_DCL_70*/"AutoCAD Color Index (ACI)";
      key = /*MSG0*/"methCol";
      mnemonic = /*RENDCOMM_DCL_71*/"A";
    }
    :radio_button
    {
      label = /*RENDCOMM_DCL_72*/"AutoCAD Object Type";
      key = /*MSG0*/"methType";
      mnemonic = /*RENDCOMM_DCL_73*/"O";
    }
  }
  :boxed_row
  {
    label = /*RENDCOMM_DCL_74*/"AutoCAD Blocks";
    :toggle
    {
      label = /*RENDCOMM_DCL_75*/"Override (Each block is one object)";
      key = /*MSG0*/"mode";
      mnemonic = /*RENDCOMM_DCL_76*/"v";
    }
  }
  :boxed_row
  {
    height = 2;
    label = /*RENDCOMM_DCL_77*/"Smoothing";
    :toggle
    {
      label = /*RENDCOMM_DCL_78*/"Auto-Smoothing";
      key = /*MSG0*/"sEn";
      mnemonic = /*RENDCOMM_DCL_79*/"S";
    }
    :edit_box
    {
      label = /*MSG0*/" ";
      key = /*MSG0*/"smooth";
      edit_width = 3;
      edit_limit = 3;
      allow_accept = true;
    }
    :text
    {
      label = /*RENDCOMM_DCL_80*/"Degrees";
      key = /*MSG0*/"sText";
    }
  }
  :boxed_row
  {
    height = 2;
    label = /*RENDCOMM_DCL_81*/"Welding";
    :toggle
    {
      label = /*RENDCOMM_DCL_82*/"Auto-Welding";
      key = /*MSG0*/"wEn";
      mnemonic = /*RENDCOMM_DCL_83*/"W";
    }
    spacer_1;
    :edit_box
    {
      key = /*MSG0*/"weld";
      label = /*RENDCOMM_DCL_84*/"&Threshold";
      edit_width = 8;
      edit_limit = 8;
      allow_accept = true;
    }
    :text
    {
      label = " ";
    }
  }
  spacer_1;
  errtile;
  ok_cancel_help;
}
//****************************************************************************
// VL conversion
//****************************************************************************
presOptions : dialog
{
  label = /*RENDCOMM_DCL_85*/"Visual Link Data Conversion";
  initial_focus = /*MSG0*/"overwt";
  :toggle
  {
    key = /*MSG0*/"overwt";
    mnemonic = "";
    label = /*RENDCOMM_DCL_86*/"Overwrite AutoVision Material and Mapping Assignments";
  }
  spacer_1;
  ok_cancel_help;
}

//****************************************************************************
// 
//****************************************************************************
warning : dialog
{
  label = /*RENDCOMM_DCL_87*/"Visual Link Conversion Alert";
  :text
  {
    label = /*RENDCOMM_DCL_88*/"Some Visual Link material assignments";
  }
  :text
  {
    label = /*RENDCOMM_DCL_89*/"could not be represented by AutoVision";
  }
  :text
  {
    label = /*RENDCOMM_DCL_90*/"and therefore were not converted";
  }
  spacer_1;
  ok_only;
}

//****************************************************************************
// RHEXPORT support
//****************************************************************************
rhexport : dialog
{
  label = /*RENDCOMM_DCL_91*/"File Output Configuration";

  : row {
      : column {
          : boxed_column {
              label = /*RENDCOMM_DCL_92*/"File Type";
              : popup_list { 
                  key = /*MSG0*/"f_types";
                  // CHANGING THE ORDER OF THE LIST OR WHAT IS ON IT
                  // REQUIRES A CHANGE IN dlg_rhex.c !!!!!
                  list = /*RENDCOMM_DCL_391*/"GIF\nX11\nPBM\nBMP\nTGA\nPCX\nSUN\nFITS\nPostScript\nTIFF\nFAX G III\nIFF";
                  value = "4";
              }
              : popup_list { 
                  key = /*MSG0*/"resol";
                  // CHANGING THE ORDER OF THE LIST OR WHAT IS ON IT
                  // REQUIRES A CHANGE IN dlg_rhex.c !!!!!
                  // Just changing the strings is OK.
                  width = 30;
list = /*RENDCOMM_DCL_390*/"320 x 200 (CGA/MCGA color)\n\
640 x 200 (CGA Monochrome)\n\
640 x 350 (EGA)\n\
640 x 400\n\
640 x 480 (VGA)\n\
720 x 540\n\
800 x 600\n\
1024 x 768\n\
1152 x 900 (Sun Standard)\n\
1600 x 1280 (Sun hi-res)\n\
2048 x 1366\n\
2048 x 1536\n\
4096 x 2736\n\
4096 x 3072\n\
User Defined";
                  value = "4";
              }
              : row {
                  : edit_box {
                      label = /*RENDCOMM_DCL_93*/"X:";
                      key   = /*MSG0*/"RES_X";
                      value = /*MSG0*/"640";
                      mnemonic = /*RENDCOMM_DCL_94*/"X";
                      edit_limit = 5;
                  }
                  : edit_box {
                      label = /*RENDCOMM_DCL_95*/"Y:";
                      key   = /*MSG0*/"RES_Y";
                      value = /*MSG0*/"480";
                      mnemonic = /*RENDCOMM_DCL_96*/"Y";
                      edit_limit = 5;
                  }
              }
              : edit_box {
                  label = /*RENDCOMM_DCL_97*/"Aspect Ratio:";
                  key   = /*MSG0*/"ASPECT";
                  value = /*MSG0*/"1.0";
                  mnemonic = /*RENDCOMM_DCL_98*/"R";
                  edit_limit = 5;
              }
          }
          : boxed_radio_column {
              label = /*RENDCOMM_DCL_99*/"Colors";
              key = /*MSG0*/"colortype";
              : radio_button {
                  key = /*MSG0*/"b_1";
                  label = /*RENDCOMM_DCL_100*/"Monochrome";
                  mnemonic = /*RENDCOMM_DCL_101*/"M";
              }
              : radio_button {
                  key = /*MSG0*/"b_8";
                  label = /*RENDCOMM_DCL_102*/"8 Bits (256 Grayscale)";
                  mnemonic = /*RENDCOMM_DCL_103*/"G";
              }
              : radio_button {
                  key = /*MSG0*/"b_8c";
                  label = /*RENDCOMM_DCL_104*/"8 Bits (256 Color)";
                  mnemonic = /*RENDCOMM_DCL_105*/"C";
              }
              : radio_button {
                  key = /*MSG0*/"b_16";
                  label = /*RENDCOMM_DCL_106*/"16 Bits";
                  mnemonic = /*RENDCOMM_DCL_387*/"B";
              }
              : radio_button {
                  key = /*MSG0*/"b_24";
                  label = /*RENDCOMM_DCL_107*/"24 Bits";
                  mnemonic = /*RENDCOMM_DCL_388*/"B";
                  value = "1";
              }
              : radio_button {
                  key = /*MSG0*/"b_32";
                  label = /*RENDCOMM_DCL_108*/"32 Bits";
                  mnemonic = /*RENDCOMM_DCL_389*/"B";
              }
          }
      }
      : boxed_column {
          label = /*RENDCOMM_DCL_109*/"Options";
          : row {
              : column {
                  : toggle {
                      key = /*MSG0*/"compress";
                      label = /*RENDCOMM_DCL_110*/"Compressed";
                      value = /*MSG0*/"1";
                      mnemonic = /*RENDCOMM_DCL_111*/"C";
                  }
                  : toggle {
                      key = /*MSG0*/"up_down";
                      label = /*RENDCOMM_DCL_112*/"Bottom Up";
                      mnemonic = /*RENDCOMM_DCL_113*/"U";
                  }
                  : toggle {
                      key = /*MSG0*/"bit_rev";
                      label = /*RENDCOMM_DCL_114*/"Bit Reversed";
                      mnemonic = /*RENDCOMM_DCL_115*/"R";
                  }
              }
              : boxed_radio_column {
                  label = /*RENDCOMM_DCL_116*/"Interlace";
                  key = /*MSG0*/"inter_a";
                  : radio_button {
                      key = /*MSG0*/"inter_1";
                      label = /*RENDCOMM_DCL_117*/"None";
                      mnemonic = /*RENDCOMM_DCL_118*/"N";
                  }
                  : radio_button {
                      key = /*MSG0*/"inter_2";
                      label = /*RENDCOMM_DCL_119*/"2 to 1";
                      mnemonic = /*RENDCOMM_DCL_385*/"t";
                  }
                  : radio_button {
                      key = /*MSG0*/"inter_4";
                      label = /*RENDCOMM_DCL_120*/"4 to 1";
                      mnemonic = /*RENDCOMM_DCL_386*/"t";
                  }
              }
          }
          : row {
              : boxed_column {
                  label = /*RENDCOMM_DCL_121*/"PostScript Options";
                  key   = /*MSG0*/"post_opts";
                  : radio_row {
                      key = /*MSG0*/"ps_port_land";
                      : radio_button {
                          key = /*MSG0*/"ps_land";
                          label = /*RENDCOMM_DCL_122*/"Landscape";
                          mnemonic = /*RENDCOMM_DCL_123*/"L";
                      }
                      : radio_button {
                          key = /*MSG0*/"ps_port";
                          label = /*RENDCOMM_DCL_124*/"Portrait";
                          mnemonic = /*RENDCOMM_DCL_125*/"P";
                      }
                  }
                  : column {
                      : radio_column {
                          key = /*MSG0*/"ps_imgsize";
                          : radio_button {
                              key = /*MSG0*/"ps_auto";
                              label = /*RENDCOMM_DCL_126*/"Auto";
                              mnemonic = /*RENDCOMM_DCL_127*/"u";
                          }
                          : radio_button {
                              key = /*MSG0*/"ps_img";
                              label = /*RENDCOMM_DCL_128*/"Image Size";
                              mnemonic = /*RENDCOMM_DCL_129*/"S";
                          }
                          : radio_button {
                              key = /*MSG0*/"ps_cust";
                              label = /*RENDCOMM_DCL_130*/"Custom";
                              mnemonic = /*RENDCOMM_DCL_131*/"u";
                          }
                      }
                      : edit_box {
                          label = /*RENDCOMM_DCL_132*/"Image Size";
                          key   = /*MSG0*/"img_size";
                          value = /*MSG0*/"640";
                          mnemonic = /*RENDCOMM_DCL_133*/"I";
                          edit_limit = 5;
                      }
                  }
              }
              : boxed_column {
                  label = /*RENDCOMM_DCL_134*/"PBM Options";
                  key = /*MSG0*/"pbm_options";
                  : radio_column {
                      key = /*MSG0*/"pbm_opt";
                      : radio_button {
                          key = /*MSG0*/"pbm";
                          label = /*RENDCOMM_DCL_135*/"PBM";
                          mnemonic = /*RENDCOMM_DCL_136*/"B";
                      }
                      : radio_button {
                          key = /*MSG0*/"pgm";
                          label = /*RENDCOMM_DCL_137*/"PGM";
                          mnemonic = /*RENDCOMM_DCL_138*/"G";
                      }
                      : radio_button {
                          key = /*MSG0*/"ppm";
                          label = /*RENDCOMM_DCL_139*/"PPM";
                          mnemonic = /*RENDCOMM_DCL_140*/"M";
                      }
                  }
                  spacer_1;
                  : radio_column {
                      key = /*MSG0*/"ascii_bin";
                      : radio_button {
                          key = /*MSG0*/"ascii";
                          label = /*RENDCOMM_DCL_141*/"ASCII";
                          mnemonic = /*RENDCOMM_DCL_142*/"A";
                      }
                      : radio_button {
                          key = /*MSG0*/"bin";
                          label = /*RENDCOMM_DCL_143*/"Binary";
                          mnemonic = /*RENDCOMM_DCL_144*/"B";
                      }
                  }
              }
          }
      }
  }

  ok_cancel_help_errtile;
}


//***************************************************************************
//***************************************************************************
//***************************************************************************
//***************************************************************************
// AutoCAD render options

other_options : column {
    : toggle {
        key = /*MSG0*/"discard_bf";
        label = /*RENDCOMM_DCL_145*/"Discard Back Faces";
        mnemonic = /*RENDCOMM_DCL_146*/"D";
    }
    : toggle {
        key = /*MSG0*/"neg_normal";
        label = /*RENDCOMM_DCL_147*/"Back Face Normal is Negative";
        mnemonic = /*RENDCOMM_DCL_148*/"N";
    }
}

boxed_other_options : boxed_column {
    label = /*RENDCOMM_DCL_149*/"Face Controls";
    other_options;
}

crender_options : dialog {
    label = /*RENDCOMM_DCL_150*/"AutoCAD Render Options";
    : row {
        : boxed_radio_column {
            label = /*RENDCOMM_DCL_151*/"Render Quality";
            key = /*MSG0*/"pf_crend_qual";
            : radio_button {
                key = /*MSG0*/"pf_crend_qual_10";
                label = /*RENDCOMM_DCL_152*/"Gouraud";
                mnemonic = /*RENDCOMM_DCL_153*/"G";
            }
            : radio_button {
                key = /*MSG0*/"pf_crend_qual_20";
                label = /*RENDCOMM_DCL_154*/"Phong";
                mnemonic = /*RENDCOMM_DCL_155*/"P";
            }
        }
        spacer_1;
        : column {
            boxed_other_options;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//******************************************************************************
//******************************************************************************
// Render and Preferences widgets

render_colormap : boxed_column {
    alignment = top;
    label = /*RENDCOMM_DCL_156*/"Screen Palette";
    : popup_list {
        key = /*MSG0*/"pf_ac";
        list = /*RENDCOMM_DCL_157*/"Best Map/No Fold\nBest Map/Fold\nFixed ACAD Map";
        mnemonic = /*RENDCOMM_DCL_158*/"P";
    }
}
 
render_colormap2 : boxed_column {
    label = /*RENDCOMM_DCL_159*/"Screen Palette";
    : popup_list {
        key = /*MSG0*/"pf_ac";
        list = /*RENDCOMM_DCL_160*/"Best Map/No Fold\nBest Map/Fold\nFixed ACAD Map";
        mnemonic = /*RENDCOMM_DCL_161*/"P";
    }
}

render_scene_list : list_box {
    width = 18;
    height = 5;
    key = /*MSG0*/"pf_scene";
    label = /*RENDCOMM_DCL_162*/"Scene to Render";
    mnemonic = /*RENDCOMM_DCL_163*/"S";
}
 

//****************************************************************************
// Color selection dialog box
 
ave_color : dialog {
    label = /*RENDCOMM_DCL_164*/"Color";
    spacer_1;
    : row {
        spacer_1;
        description;
        spacer_1;
        : image_button {
            key = /*MSG0*/"color_wheel";
            height = 16;
            aspect_ratio = 1;
            color = -15;       /* dialog box background color = -15*/
            is_tab_stop = false;
        }
        : slider_0_1 {
            key = /*MSG0*/"lightness_slider";
            layout = vertical;
        }
        spacer_1;
    }
    spacer_1_ok_cancel_help_errtile;
}

ave_color_1 : dialog {
    label = /*RENDCOMM_DCL_165*/"Color";
    spacer_1;
 
    : row {
        color_system;
    }
    spacer_1;
    components;
    spacer_1;
    aci;
 
    spacer_1_ok_cancel_help_errtile;
}

description : column {
    : row {
        color_system;
    }
    spacer_1;
    components;
    spacer_1;
    aci;
    spacer_1;
    : column {
        children_alignment = centered;
        : text_part { label = /*RENDCOMM_DCL_166*/"Color Selected"; }
        : boxed_row {
            fixed_width = true;
            : image {
                key = /*MSG0*/"patch";
                height = 2;
                aspect_ratio = 2;
                fixed_width = true;
                color = -15;             /* background color */
            }
        }
    }
}

aci : button {
    key = /*MSG0*/"select_aci";
    label = /*RENDCOMM_DCL_167*/"Select from ACI...";
    mnemonic = /*RENDCOMM_DCL_168*/"S";
    fixed_width = true;
    alignment = centered;
}

components : row {
    : column {
        : color_name       { key = /*MSG0*/"top_name"; }
        : color_name       { key = /*MSG0*/"middle_name"; }
        : color_name       { key = /*MSG0*/"bottom_name"; }
    }
    : column {
        : edit_box_4       { key = /*MSG0*/"top_edit"; }
        : edit_box_4       { key = /*MSG0*/"middle_edit"; }
        : edit_box_4       { key = /*MSG0*/"bottom_edit"; }
    }
    : column {
        : slider_0_1_fixed { key = /*MSG0*/"top_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"middle_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"bottom_slider"; }
    }
    : column {
        : color_image      { key = /*MSG0*/"top_image"; }
        : color_image      { key = /*MSG0*/"middle_image"; }
        : color_image      { key = /*MSG0*/"bottom_image"; }
    }
}



color_name : text_part {
    width = 11;
    label = "";
}
 
color_image : image {
    height = 1;
    aspect_ratio = 1;
    fixed_height = true;
    fixed_width = true;
    color = -15;         /* -15 = dialog background color */
}
 
//****************************************************************************
// Replay

replay : dialog {
    label = /*RENDCOMM_DCL_169*/"Image Specifications";
    width = 22;
    alignment = centered;
    spacer_1;
    : column {
        : row {
            : column {
                fixed_width = true;
                width = 20;
                : text_part {
                    alignment = centered;
                    key = /*MSG0*/"imgsz";
                    width = 16;
                }
                : image_button {              // Virtual image window
                    alignment = centered;
                    key = /*MSG0*/"vimg";
                    color = 0;
                    aspect_ratio = 1;
                    height = 6;
                    width = 16;
                    fixed_width = true;
                    fixed_height = true;
                    is_tab_stop = false;
                }
                spacer;
                : text_part {
                    alignment = centered;
                    label = /*RENDCOMM_DCL_170*/" Image Offset";
                    width = 16;
                }
                : row {
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_171*/"X:";
                        key = /*MSG0*/"imgoffx"; 
                    }
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_172*/"Y:";
                        key = /*MSG0*/"imgoffy"; 
                    }
                }
            }
            spacer;
            : column {
                fixed_width = true;
                width = 20;
                : text_part {
                    alignment = centered;
                    key = /*MSG0*/"winsz";
                    width = 16;
                }
                : image_button {              // Virtual window window
                    alignment = centered;
                    key = /*MSG0*/"vwin";
                    color = 0;
                    aspect_ratio = 1;
                    height = 6;
                    width = 16;
                    fixed_width = true;
                    fixed_height = true;
                    is_tab_stop = false;
                }
                spacer;
                : text_part {
                    alignment = centered;
                    label = /*RENDCOMM_DCL_173*/" Screen Offset";
                    width = 16;
                }
                : row {
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_174*/" X:";
                        key = /*MSG0*/"winoffx"; 
                    }
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_175*/"Y:";
                        key = /*MSG0*/"winoffy"; 
                    }
                }
             }
          }
          spacer_1;
          : row {
            : column {
                fixed_width = true;
                width = 20;
                : text_part {
                    alignment = centered;
                    label = /*RENDCOMM_DCL_176*/" Image Size";
                    width = 16;
                }
                : row {
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_177*/"X:";
                        key = /*MSG0*/"imgsizex"; 
                    }
                    : edit_box_4 { 
                        label = /*RENDCOMM_DCL_178*/"Y:";
                        key = /*MSG0*/"imgsizey"; 
                    }
                }
            }
            : column {
                fixed_width = true;
                width = 20;
                : text_part {
                    alignment = centered;
                    label = /*RENDCOMM_DCL_179*/" Screen Size";
                    width = 16;
                }
                : row {
                    : concatenation {
                        : text_part { 
                            label = /*RENDCOMM_DCL_180*/" X:  ";
                        }
                        : text_part { 
                            key = /*MSG0*/"winsizex"; 
                            width = 4; 
                        }
                    }
                    : concatenation {
                        : text_part { 
                            label = /*RENDCOMM_DCL_181*/"Y:  ";
                        }
                        : text_part { 
                            key = /*MSG0*/"winsizey"; 
                            width = 4; 
                        }
                    }
                }
            }
        }
    }
    spacer_1;
    : button {
        key = /*MSG0*/"rst";
        mnemonic = /*RENDCOMM_DCL_182*/"R";
        label = /*RENDCOMM_DCL_183*/"Reset";
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//  saveimg rendering combined

saveimgrc : dialog {
    label = /*RENDCOMM_DCL_184*/"Save Image";
    : cluster {
        : boxed_radio_column {
            label = /*RENDCOMM_DCL_185*/"Format";
            key = /*MSG0*/"frmt";
            : radio_button {
                label = /*RENDCOMM_DCL_186*/"TGA";
                key = /*MSG0*/"tga";
                mnemonic = /*RENDCOMM_DCL_187*/"T";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_188*/"TIFF";
                key = /*MSG0*/"tif";
                mnemonic = /*RENDCOMM_DCL_189*/"F";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_190*/"GIF";
                key = /*MSG0*/"gif";
                mnemonic = /*RENDCOMM_DCL_191*/"G";
            }
        }
        : boxed_radio_column {
            label = /*RENDCOMM_DCL_192*/"Portion";
            key = /*MSG0*/"prtn";
            : radio_button {
                label = /*RENDCOMM_DCL_193*/"Active Viewport";
                key = "A";
                mnemonic = /*RENDCOMM_DCL_194*/"A";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_195*/"Drawing Area";
                key = "D";
                mnemonic = /*RENDCOMM_DCL_196*/"w";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_197*/"Full Screen";
                key = "F";
                mnemonic = /*RENDCOMM_DCL_198*/"u";
            }
        }
    }
    spacer;
    : cluster {
        : button {
            key = /*MSG0*/"opt";
            label = /*RENDCOMM_DCL_199*/"Options...";
            mnemonic = /*RENDCOMM_DCL_200*/"p";
        }
        : button {
            key = /*MSG0*/"rst";
            label = /*RENDCOMM_DCL_201*/"Reset";
            mnemonic = /*RENDCOMM_DCL_202*/"R";
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { 
            label = /*RENDCOMM_DCL_203*/"   Offset ";
            mnemonic = /*RENDCOMM_DCL_204*/"O";
          }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_205*/"X:";
            key = /*MSG0*/"winoffx"; 
        }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_206*/" Y:";
            key = /*MSG0*/"winoffy"; 
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { 
            label = /*RENDCOMM_DCL_207*/"     Size "; 
            mnemonic = /*RENDCOMM_DCL_208*/"S";
          }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_209*/"X:";
            key = /*MSG0*/"winsizex"; 
        }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_210*/" Y:";
            key = /*MSG0*/"winsizey"; 
        }
    }
    : row {
        : concatenation {
            : text_part { label = /*RENDCOMM_DCL_211*/"Default "; }
            : text_part { key = /*MSG0*/"winsz"; width = 9; }
        }
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//  saveimg rendering seperate

saveimgrs : dialog {
    label = /*RENDCOMM_DCL_212*/"Save Image";
    : cluster {
        : boxed_radio_column {
            label = /*RENDCOMM_DCL_217*/"Format";
            key = /*MSG0*/"frmt";
            : radio_button {
                label = /*RENDCOMM_DCL_218*/"TGA";
                key = /*MSG0*/"tga";
                mnemonic = /*RENDCOMM_DCL_219*/"T";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_220*/"TIFF";
                key = /*MSG0*/"tif";
                mnemonic = /*RENDCOMM_DCL_221*/"F";
            }
            : radio_button {
                label = /*RENDCOMM_DCL_222*/"GIF";
                key = /*MSG0*/"gif";
                mnemonic = /*RENDCOMM_DCL_223*/"G";
            }
        }
        : boxed_column {
            label = /*RENDCOMM_DCL_224*/"Portion";
            : image_button {              // Virtual window window
                key = /*MSG0*/"vwin";
                color = 0;
                alignment = centered;
                aspect_ratio = 1;
                height = 6;
                width = 16;
                fixed_width = true;
                fixed_height = true;
            }
        }
    }
    spacer;
    : cluster {
        : button {
            key = /*MSG0*/"opt";
            label = /*RENDCOMM_DCL_225*/"Options...";
            mnemonic = /*RENDCOMM_DCL_226*/"p";
        }
        : button {
            key = /*MSG0*/"rst";
            label = /*RENDCOMM_DCL_227*/"Reset";
            mnemonic = /*RENDCOMM_DCL_228*/"R";
        }
    }
    spacer;
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { 
            label = /*RENDCOMM_DCL_229*/"   Offset ";
            mnemonic = /*RENDCOMM_DCL_230*/"O";
          }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_231*/"X:";
            key = /*MSG0*/"winoffx"; 
        }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_232*/" Y:";
            key = /*MSG0*/"winoffy"; 
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : text_part { 
            label = /*RENDCOMM_DCL_233*/"     Size ";
            mnemonic = /*RENDCOMM_DCL_234*/"S";
          }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_235*/"X:";
            key = /*MSG0*/"winsizex"; 
        }
        : edit_box_4 { 
            label = /*RENDCOMM_DCL_236*/" Y:";
            key = /*MSG0*/"winsizey"; 
        }
    }
    : row {
        : concatenation {
            : text_part { label = /*RENDCOMM_DCL_237*/"Default "; }
            : text_part { key = /*MSG0*/"winsz"; width = 9; }
        }
        fixed_width = true;
        alignment = centered;
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
//

tga_options : dialog {
    label = /*RENDCOMM_DCL_238*/"TGA Options";
    spacer;
    : boxed_radio_row {
        label = /*RENDCOMM_DCL_239*/"Compression";
        key = /*MSG0*/"comp";
        : radio_button {
            label = /*RENDCOMM_DCL_240*/"None";
            mnemonic = /*RENDCOMM_DCL_241*/"N";
            key = /*MSG0*/"none";       // returned as "value" of radio_cluster
        }
        : radio_button {
            label = /*RENDCOMM_DCL_242*/"RLE";
            mnemonic = /*RENDCOMM_DCL_243*/"R";
            key = /*MSG0*/"rle";
        }
    }
    spacer_1_ok_cancel_help;
}

//****************************************************************************
//

tif_options : dialog {
    label = /*RENDCOMM_DCL_244*/"TIFF Options";
    spacer;
    : boxed_radio_row {
        label = /*RENDCOMM_DCL_245*/"Compression";
        key = /*MSG0*/"comp";
        : radio_button {
            label = /*RENDCOMM_DCL_246*/"None";
            mnemonic = /*RENDCOMM_DCL_247*/"N";
            key = /*MSG0*/"none";       // returned as "value" of radio_cluster
        }
        : radio_button {
            label = /*RENDCOMM_DCL_248*/"PACK";
            mnemonic = /*RENDCOMM_DCL_249*/"P";
            key = /*MSG0*/"pack";
        }
        : radio_button {
            label = /*RENDCOMM_DCL_250*/"LZW";
            mnemonic = /*RENDCOMM_DCL_251*/"L";
            key = /*MSG0*/"lzw";
        }
    }
    spacer_1_ok_cancel_help;
}

//******************************************************************************
//******************************************************************************
// Lights Common widgets

distant_light_parameters_panel : column {
    fixed_height = true;
    : edit_box_8 {
        label = /*RENDCOMM_DCL_252*/"Name:";
        key = /*MSG0*/"name";
        mnemonic = /*RENDCOMM_DCL_253*/"N";
    }
    : row {
        : edit_box_8 {
            label = /*RENDCOMM_DCL_254*/"Intensity: ";
            key = /*MSG0*/"inten_t";
            edit_width = 8;
            mnemonic = /*RENDCOMM_DCL_255*/"I";
        }
        : slider {
            key = /*MSG0*/"inten_s";
            min_value = 0;
            max_value = 10000;
            small_increment = 100;
            big_increment = 1000;
        }
    }
    light_color_panel;
}

light_color_panel : boxed_column {
    label = /*RENDCOMM_DCL_256*/"Color";
    rgb_edit_slider;
    : row {
        : image_button {
            key = /*MSG0*/"color";
            color = -15;             /* background color */
            height = 1;
            aspect_ratio = 1;
        }
        : button {
            label = /*RENDCOMM_DCL_257*/"Use Color Wheel...";
            key = /*MSG0*/"mod_color";
            fixed_width = true;
            mnemonic = /*RENDCOMM_DCL_258*/"W";
        }
    }
}

light_source_panel : column {
    : boxed_column {
        label = /*RENDCOMM_DCL_259*/"Light Source Vector";
        : row {
            : edit_box_4 {
                label = /*RENDCOMM_DCL_260*/"X:";
                key = /*MSG0*/"x";
                mnemonic = /*RENDCOMM_DCL_261*/"X";
            }
            spacer;
            : edit_box_4 {
                label = /*RENDCOMM_DCL_262*/"Y:";
                key = /*MSG0*/"y";
                mnemonic = /*RENDCOMM_DCL_263*/"Y";
            }
            spacer;
            : edit_box_4 {
                label = /*RENDCOMM_DCL_264*/"Z:";
                key = /*MSG0*/"z";
                mnemonic = /*RENDCOMM_DCL_265*/"Z";
            }
        }
        : button {
            alignment = centered;
            fixed_width = true;
            key = /*MSG0*/"mod_points";
            label = /*RENDCOMM_DCL_266*/"Modify <";
            mnemonic = /*RENDCOMM_DCL_267*/"M";
        }
    }
}

azimuth_altitude_panel : boxed_row {
    : column {
        : edit_box {
            label = /*RENDCOMM_DCL_268*/"Azimuth:";
            key = /*MSG0*/"azimuth_t";
            mnemonic = /*RENDCOMM_DCL_269*/"A";
            edit_width = 6;
            edit_limit = 6;
        }
        : image_button {
            key = /*MSG0*/"azimuth_image";
            color = dialog_background;
            height = 7;
            aspect_ratio = 1;
            fixed_height = true;
            fixed_width = true;
            alignment = centered;
        }
        : slider  {
            key = /*MSG0*/"azimuth_slider";
            min_value = -180;
            max_value = 180;
            small_increment = 1;
            big_increment = 10;
        }
    }
    : column {
        : edit_box {
            label = /*RENDCOMM_DCL_270*/"Altitude:";
            key = /*MSG0*/"altitude_t";
            mnemonic = /*RENDCOMM_DCL_271*/"l";
            edit_width = 6;
            edit_limit = 6;
        }
        : image_button {
            key = /*MSG0*/"altitude_image";
            color = dialog_background;
            height = 7;
            aspect_ratio = 1;
            fixed_height = true;
            fixed_width = true;
            alignment = centered;
        }
        : slider  {
            key = /*MSG0*/"altitude_slider";
            min_value = 0;
            max_value = 90;
            small_increment = 1;
            big_increment = 10;
        }
    }
}


//****************************************************************************
// Tile used by all three light types.
 
ave_basic_lights : column {
    : edit_box_8 {
        label = /*RENDCOMM_DCL_272*/"Light Name:";
        key = /*MSG0*/"name";
        mnemonic = /*RENDCOMM_DCL_273*/"N";
    }
    : edit_box_8 {
        label = /*RENDCOMM_DCL_274*/"Intensity:";
        key = /*MSG0*/"inten_t";
        mnemonic = /*RENDCOMM_DCL_275*/"I";
    }
    : slider  {
        key = /*MSG0*/"inten_s";
        min_value = 0;
        max_value = 10000;
        small_increment = 100;
        big_increment = 1000;
    }
    : boxed_row {
        label = /*RENDCOMM_DCL_276*/"Position";
        : button {
            label = /*RENDCOMM_DCL_277*/"Modify <";
            key = /*MSG0*/"mod_points";
            mnemonic = /*RENDCOMM_DCL_278*/"M";
        }
        : button {
            label = /*RENDCOMM_DCL_279*/"Show...";
            key = /*MSG0*/"show_points";
            mnemonic = /*RENDCOMM_DCL_280*/"S";
            other = "1";
        }
    }
    light_color_panel;
}

attenuation_panel : boxed_radio_column {
    label = /*RENDCOMM_DCL_281*/"Attenuation";
    key = /*MSG0*/"falloff";
    fixed_height = true;
    : radio_button {
        label = /*RENDCOMM_DCL_282*/"None";
        mnemonic = /*RENDCOMM_DCL_283*/"o";
        key = "0";      // returned as "value" of radio_cluster
    }
    : radio_button {
        label = /*RENDCOMM_DCL_284*/"Inverse Linear";
        mnemonic = /*RENDCOMM_DCL_285*/"L";
        key = "1";
    }
    : radio_button {
        label = /*RENDCOMM_DCL_286*/"Inverse Square";
        mnemonic = /*RENDCOMM_DCL_287*/"q";
        key = "2";
    }
}

//****************************************************************************
//  Display the Location and Target points of lights.  Target should be
//  disabled when displaying a Point Light.
 
show_points : dialog {
    label = /*RENDCOMM_DCL_288*/"Show Light Position";
    : row {
        : boxed_row {
            key = /*MSG0*/"location";
            label = /*RENDCOMM_DCL_289*/"Location";
            : paragraph {
                : text_part { label = /*RENDCOMM_DCL_290*/"X ="; }
                : text_part { label = /*RENDCOMM_DCL_291*/"Y ="; }
                : text_part { label = /*RENDCOMM_DCL_292*/"Z ="; }
            }
            : paragraph {
                : text_part_12 { key = /*MSG0*/"lfx"; }
                : text_part_12 { key = /*MSG0*/"lfy"; }
                : text_part_12 { key = /*MSG0*/"lfz"; }
            }
        }
        : boxed_row    {
            key = /*MSG0*/"target";     //  Disabled for Point Lights
            label = /*RENDCOMM_DCL_293*/"Target";
            : paragraph {
                : text_part { label = /*RENDCOMM_DCL_294*/"X ="; }
                : text_part { label = /*RENDCOMM_DCL_295*/"Y ="; }
                : text_part { label = /*RENDCOMM_DCL_296*/"Z ="; }
            }
            : paragraph {
                : text_part_12 { key = /*MSG0*/"lax"; }
                : text_part_12 { key = /*MSG0*/"lay"; }
                : text_part_12 { key = /*MSG0*/"laz"; }
            }
        }
    }
    spacer_1_ok_help;
}

//****************************************************************************
// Main scene dialog
 
ave_scene : dialog {
    label = /*RENDCOMM_DCL_297*/"Scenes";
    : row {
        : list_box_8x8 {
            key = /*MSG0*/"scen";
            label = /*RENDCOMM_DCL_298*/"Scenes:";
            mnemonic = /*RENDCOMM_DCL_299*/"S";
        }
        : column {
            spacer_0;
            button_new;
            button_mod;
            button_del;
            spacer_0;
        }
    }
    spacer_1_ok_cancel_help;
}
 
//****************************************************************************
// Dialog to modify a scene.
 
ave_scene_mod : dialog {
    key = /*MSG0*/"dialog";
    : edit_box_8 {
        label = /*RENDCOMM_DCL_300*/"Scene Name:";
        key = /*MSG0*/"name";
        mnemonic = /*RENDCOMM_DCL_301*/"N";
    }
    spacer;
    : row {
        : column {
            : text {
                label = /*RENDCOMM_DCL_302*/"Views";
                mnemonic = /*RENDCOMM_DCL_303*/"V";
            }
            : list_box_8x8 {
                key = /*MSG0*/"view";
            }
        }
        : column {
            : text {
                label = /*RENDCOMM_DCL_304*/"Lights";
                mnemonic = /*RENDCOMM_DCL_305*/"L";
            }
            : list_box_8x8 {
                key = /*MSG0*/"lght";
                multiple_select = true;
            }
        }
    }
    spacer_1_ok_cancel_help_errtile;
}



//****************************************************************************
//Materials list dialog -- common components
material_column : column {
    : row {
        : text {
            label = /*RENDCOMM_DCL_306*/"Materials List:";
            mnemonic = /*RENDCOMM_DCL_307*/"M";
        }
    }
    : list_box {
        height = 12;
        width = 24;
        key = /*MSG0*/"materials_list";
        multiple_select = true;
    }
    : row {
        : button {
            key = /*MSG0*/"cleanup";
            label = /*RENDCOMM_DCL_308*/"Purge";
            mnemonic = /*RENDCOMM_DCL_309*/"u";
        }
        : button {
            key = /*MSG0*/"saveList";
            label = /*RENDCOMM_DCL_310*/"Save...";
            mnemonic = /*RENDCOMM_DCL_311*/"S";
        }
    }
}
 
import_export_delete : column {
    : button {
        key = /*MSG0*/"import";
        label = /*RENDCOMM_DCL_312*/"<-Import";
        mnemonic = /*RENDCOMM_DCL_313*/"I";
        is_enabled = false;
    }
    : button {
        key = /*MSG0*/"export";
        label = /*RENDCOMM_DCL_314*/"Export->";
        mnemonic = /*RENDCOMM_DCL_315*/"E";
        is_enabled = false;
    }
    : button {
        key = /*MSG0*/"delete";
        label = /*RENDCOMM_DCL_316*/"Delete";
        mnemonic = /*RENDCOMM_DCL_317*/"D";
        is_enabled = false;
    }
}

library_column : column {
    : row {
        : text {
            label = /*RENDCOMM_DCL_318*/"Library List:";
            mnemonic = /*RENDCOMM_DCL_319*/"L";
        }
        : text {
            key = /*MSG0*/"libraryTitle";
            width = 12;
            fixed_width = true;
        }
    }
    : list_box {
        height = 12;
        width = 24;
        key = /*MSG0*/"library_list";
        multiple_select = true;
    }
    : row {
        : button {
            key = /*MSG0*/"openLibrary";
            label = /*RENDCOMM_DCL_320*/"Open...";
            mnemonic = /*RENDCOMM_DCL_321*/"O";
        }
        : button {
            key = /*MSG0*/"saveLibrary";
            label = /*RENDCOMM_DCL_322*/"Save...";
            mnemonic = /*RENDCOMM_DCL_323*/"a";
        }
    }
}

spacer_1_ok_cancel_help_custom : column {
    spacer_1;
    ok_cancel_help_custom;
}
 
ok_cancel_help_custom : column {
    :column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            : spacer { width = 2; }
            cancel_button_custom;
            : spacer { width = 2; }
            help_button;
        }
        errtile;
    }
}

cancel_button_custom : retirement_button {
        label           = /*RENDCOMM_DCL_324*/"Cancel";
        key             = /*MSG0*/"cancel";
        is_cancel       = false;            // reason for custom
}

ave_confirm_library_save : dialog {
    label = /*RENDCOMM_DCL_325*/"Library Modification";
    initial_focus = "save";
    : column {
        : text {
            label = /*RENDCOMM_DCL_326*/"The current materials library has been changed.";
            alignment = centered;
        }
        : row {
            : button {
                label = /*RENDCOMM_DCL_327*/"Save Changes...";
                is_default = true;
                mnemonic = /*RENDCOMM_DCL_328*/"S";
                key = /*MSG0*/"save";
            }
            : button {
                label = /*RENDCOMM_DCL_329*/"Discard Changes";
                mnemonic = /*RENDCOMM_DCL_330*/"D";
                key = /*MSG0*/"discard";
            }
            : button {
                label = /*RENDCOMM_DCL_331*/"Cancel Command";
                is_cancel = true;
                mnemonic = /*RENDCOMM_DCL_332*/"C";
                key = /*MSG0*/"cancel";
            }
        }
    }
}

//****************************************************************************
//Reconcile Imported Material Names dialog
 
ave_reconcile_import : dialog {
    label = /*RENDCOMM_DCL_333*/"Reconcile Imported Material Names";
    initial_focus = /*MSG0*/"new_name";
    spacer_1;
    : row {
        children_alignment = top;
        : column {
            : boxed_column {
                fixed_height = true;
                label = /*RENDCOMM_DCL_334*/"Options";
                key = /*MSG0*/"options";
                dialog_kind = /*MSG0*/"import";
                : toggle {
                    label = /*RENDCOMM_DCL_335*/"Overwrite Existing Material";
                    value = /*MSG0*/"1";
                    key = /*MSG0*/"overwrite";
                    mnemonic = /*RENDCOMM_DCL_336*/"O";
                }
                : toggle {
                    label = /*RENDCOMM_DCL_337*/"Transfer Attachments";
                    key = /*MSG0*/"transfer";
                    value = /*MSG0*/"1";
                    mnemonic = /*RENDCOMM_DCL_338*/"T";
                }
            }
            : boxed_column {
                fixed_height = true;
                label = /*RENDCOMM_DCL_339*/"Material Names";
                key = /*MSG0*/"names";
                : edit_box_16 {
                    label = /*RENDCOMM_DCL_340*/"Old Material in List:";
                    key = /*MSG0*/"old_name";
                    mnemonic = /*RENDCOMM_DCL_341*/"l";
                }
                : edit_box_16 {
                    label = /*RENDCOMM_DCL_342*/"New Material from Library:";
                    key = /*MSG0*/"new_name";
                    mnemonic = /*RENDCOMM_DCL_343*/"N";
                }
            }
            spacer_0;
        }
    }
    spacer_1_ok_ok_all_cancel_help;
}
//****************************************************************************
//Reconcile Exported Material Names dialog
 
ave_reconcile_export : dialog {
    label = /*RENDCOMM_DCL_344*/"Reconcile Exported Material Names";
    initial_focus = /*MSG0*/"new_name";
    spacer_1;
    : row {
        children_alignment = top;
        : column {
            : boxed_column {
                label = /*RENDCOMM_DCL_345*/"Options";
                key = /*MSG0*/"options";
                dialog_kind = /*MSG0*/"export";
                fixed_height = true;
                : toggle {
                    label = /*RENDCOMM_DCL_346*/"Overwrite Existing Material";
                    value = /*MSG0*/"1";
                    key = /*MSG0*/"overwrite";
                    mnemonic = /*RENDCOMM_DCL_347*/"O";
                }
            }
            : boxed_column {
                label = /*RENDCOMM_DCL_348*/"Material Names";
                key = /*MSG0*/"names";
                fixed_height = true;
                : edit_box_16 {
                    label = /*RENDCOMM_DCL_349*/"Old Material in Library:";
                    key = /*MSG0*/"old_name";
                    mnemonic = /*RENDCOMM_DCL_350*/"l";
                }
                : edit_box_16 {
                    label = /*RENDCOMM_DCL_351*/"New Material from List:";
                    key = /*MSG0*/"new_name";
                    mnemonic = /*RENDCOMM_DCL_352*/"N";
                }
            }
            spacer_0;
        }
    }
    spacer_1_ok_ok_all_cancel_help;
}
 
spacer_1_ok_ok_all_cancel_help : column {
    spacer_1;
    ok_ok_all_cancel_help;
}
 
ok_ok_all_cancel_help : column {
    : row {
        fixed_width = true;
        alignment = centered;
        ok_button;
        ok_all_button;
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
}
 
ok_all_button : retirement_button {
        label           = /*RENDCOMM_DCL_353*/"OK to All";
        key             = /*MSG0*/"okAll";
        mnemonic        = /*RENDCOMM_DCL_354*/"A";
}


//****************************************************************************
// Main material dialog -- common components

material_list : list_box {
    key = /*MSG0*/"list";
    label = /*RENDCOMM_DCL_355*/"Materials:";
    mnemonic = /*RENDCOMM_DCL_356*/"t";
    width = 18;
}

material_attach : column {
    : button {
        label = /*RENDCOMM_DCL_357*/"Attach <";
        key = /*MSG0*/"entities";
        mnemonic = /*RENDCOMM_DCL_358*/"A";
    }
    : button {
        label = /*RENDCOMM_DCL_359*/"Detach < ";
        key = /*MSG0*/"detach";
        mnemonic = /*RENDCOMM_DCL_360*/"D";
    }
    : button {
        label = /*RENDCOMM_DCL_361*/"By ACI... ";
        key = /*MSG0*/"ACI";
        mnemonic = /*RENDCOMM_DCL_362*/"B";
    }
    : button {
        label = /*RENDCOMM_DCL_363*/"By Layer... ";
        key = /*MSG0*/"layer";
        mnemonic = /*RENDCOMM_DCL_364*/"y";
    }
}

material_name : row {
    : edit_box_16 {
        label = /*RENDCOMM_DCL_365*/"Material Name:";
        key = /*MSG0*/"name";
        mnemonic = /*RENDCOMM_DCL_366*/"M";
        fixed_width = true;
    }
}

value_edit_slider : boxed_row {
    : edit_box_4 {
        label = /*RENDCOMM_DCL_367*/"Value:";
        key = /*MSG0*/"value_edit";
        mnemonic = /*RENDCOMM_DCL_368*/"V";
    }
    : slider_0_1_fixed { key = /*MSG0*/"value_slider"; }
}


//******************************************************************************
//******************************************************************************

//** RGB edit sliders
rgb_edit_slider : row {
    : column {
        : edit_box_4 {
            label = /*RENDCOMM_DCL_384*/"Red:";
            key = /*MSG0*/"red_edit";
            mnemonic = /*RENDCOMM_DCL_369*/"R";
        }
        : edit_box_4 {
            label = /*RENDCOMM_DCL_370*/"Green:";
            key = /*MSG0*/"green_edit";
            mnemonic = /*RENDCOMM_DCL_371*/"G";
        }
        : edit_box_4 {
            label = /*RENDCOMM_DCL_372*/"Blue:";
            key = /*MSG0*/"blue_edit";
            mnemonic = /*RENDCOMM_DCL_373*/"B";
        }
    }
    : column {
        : slider_0_1_fixed { key = /*MSG0*/"red_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"green_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"blue_slider"; }
    }
}
 
display_and_get_color : row {
    : image_button {
        key = /*MSG0*/"set_color_image";
        color = -15;             /* background color */
        height = 1;
        aspect_ratio = 1;
    }
    : button {
        label = /*RENDCOMM_DCL_374*/"Use Color Wheel...";
        mnemonic = /*RENDCOMM_DCL_375*/"W";
        key = /*MSG0*/"set_color";
        fixed_width = true;
    }
}
 
lock : toggle {
    label = /*RENDCOMM_DCL_376*/"Lock";
    key = /*MSG0*/"lock";
    mnemonic = /*RENDCOMM_DCL_377*/"k";
}
 
 
color_system : popup_list {
    label = /*RENDCOMM_DCL_378*/"Color System:";
    mnemonic = /*RENDCOMM_DCL_379*/"C";
    key = /*MSG0*/"color_system";
    list = /*RENDCOMM_DCL_380*/"RGB\nHLS";
    width = 5;
}
 
 
 
//****************************************************************************
// Finish Preview tile.
 
finish_preview : boxed_column {
    children_alignment = centered;
    : image_button {
        key = /*MSG0*/"image";
        color = graphics_background;
        height = 8;
        aspect_ratio = 1;
        fixed_height = true;
        fixed_width = true;
        mnemonic = /*RENDCOMM_DCL_381*/"P";     //  FIXME - Can we ALT to an image???
        is_tab_stop = false;
    }
    : button {
        key = /*MSG0*/"object";
        label = /*RENDCOMM_DCL_382*/"Preview";
        mnemonic = /*RENDCOMM_DCL_383*/"P";
    }
    spacer_0;
}
