// Next available MSG number is    51 
// MODULE_ID DDUNITS_DCL_
/* Next available MSG number is  60 */

//-------------------------------------------------------------------------
//
//     ddunits.dcl
//
//     Copyright (C) 1992, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//.
//    
//-------------------------------------------------------------------------
// DESCRIPTION:
// Dialogue definition file for DDUNITS.LSP - Units command. 
//-------------------------------------------------------------------------

//dcl_settings : default_dcl_settings { audit_level = 3; }

ddunits : dialog {
    label = "Units Control";
    //
    // Horizontal cluster that contains the Units and Angles clusters.
    //
    : row {
        //
        // Units cluster.
        //
        : boxed_column {
            label = "Units";
            //
            // Radio cluster for the units format selection.
            //
            : radio_column {
                : radio_button {
                    key = "scientific";
                    label = "Scientific";
                    mnemonic = "S";
                }
                : radio_button {
                    key = "decimal";
                    label = "Decimal";
                    mnemonic = "c";
                }
                : radio_button {
                    key = "engineering";
                    label = "Engineering";
                    mnemonic = "E";
                }
                : radio_button {
                    key = "architectural";
                    label = "Architectural";
                    mnemonic = "A";
                }
                : radio_button {
                    key = "fractional";
                    label = "Fractional";
                    mnemonic = "F";
                }
            }
            //
            // Linear Units Precision popup_list (System variable LUPREC).
            //
            spacer;
            : text {
                label = "Precision:";
                mnemonic = "P";
            }
            : popup_list {
                key = "luprec";
                edit_width = 14;
            }
        }
        //
        // Angle Formats Control.
        //
        : boxed_column {
            label = "Angles";
            //
            // Radio cluster for the angle format selection.
            //
            : radio_column {
                : radio_button {
                  key = "decimal_deg";
                  label = "Decimal Degrees";
                  mnemonic = "i";
                }
                : radio_button {
                    key = "dms";
                    label = "Deg/Min/Sec";
                    mnemonic = "M";
                }
                : radio_button {
                    key = "grads";
                    label = "Grads";
                    mnemonic = "G";
                }
                : radio_button {
                    key = "radians";
                    label = "Radians";
                    mnemonic = "R";
                }
                : radio_button {
                    key = "surveyor_deg";
                    label = "Surveyor";
                    mnemonic = "v";
                }
            }
            //
            // Angle Precision popup_list (system variable AUPREC).
            //
            spacer_0;
            : text {
                label = "Precision:";
                mnemonic = "n";
            }    
            : popup_list {
                key = "auprec";
                edit_width = 17;
            }
        }
    }
    //
    // Row of buttons at bottom: OK Cancel Direction... Help...
    //
    : row {
        ok_button;
        cancel_button;
        : button {
             label = "Direction...";
             key = "dir";
             mnemonic = "D";
             fixed_width = true;
        }
        help_button;
    }
}
//
// Direction child dialog.
//
direction : dialog {
    label = "Direction Control";
    : boxed_column {
        label = "Angle 0 Direction";
        fixed_width = true;
        width =22;
        //
        // Direction sub-cluster to group the radio cluster and the
        // pick button/edit box cluster.
        //
        :row {
            //
            // Radio cluster for the direction selection.
            //
            : radio_column {
                : radio_button {
                    key = "east";
                    label = "East";
                    mnemonic = "E";
                }
                : radio_button {
                    key = "north";
                    label = "North";
                    mnemonic = "N";
                }
                : radio_button {
                    key = "west";
                    label = "West";
                    mnemonic = "W";
                }
                : radio_button {
                    key = "south";
                    label = "South";
                    mnemonic = "S";
                }
                : radio_button {
                    key = "other";
                    label = "Other";
                    mnemonic = "O";
                }
            }
            //
            // Angle direction format labels appears to the right
            // of the radio cluster, a "pick" button next to "other"
            //
            : column {
                : text {
                    key = "zero";
                    label = "";
                    width = 9;
                }
                : text {
                    key = "ninety";
                    label = "";
                }
                : text {
                    key = "one_eighty";
                    label = "";
                }
                : text {
                    key = "two_seventy";
                    label = "";
                }
                : text {
                    key = "typed";
                    label = "Pick/Type";
                }
            }
        }
        //
        // Manual angle selection and direction selection.
        //
        //
        // Angle edit box.
        //
        : edit_box {
            key = "angle_edit";
            edit_width = 14;
            label = "Angle:";
            mnemonic = "A";
        }
        : button{
            label = "Pick <";
            key = "angle_pick";
            fixed_width = true;
            width = 8;
            alignment = left;
            mnemonic = "P";
        }
    }
    //
    // Angle direction radio cluster.
    //
    : radio_column {
        : radio_button {
            key = "angle_dir_ccw";
            label = "Counter-Clockwise";
            mnemonic = "C";
        }
        : radio_button {
            key = "angle_dir_cw";
            label = "Clockwise";
            mnemonic = "l";
        }
    }
    ok_cancel;
    : errtile {
        width = 22;
    }
}
// End Direction child dialog.

