; Next available MSG number is     7 
; MODULE_ID DDOSNAP_LSP_
;;;----------------------------------------------------------------------------
;;;    DDOSNAP.LSP  Version 0.5
;;;
;;;    Copyright (C) 1991, 1992, 1993, 1994 by Autodesk, Inc.
;;;
;;;    Permission to use, copy, modify, and distribute this software
;;;    for any purpose and without fee is hereby granted, provided
;;;    that the above copyright notice appears in all copies and
;;;    that both that copyright notice and the limited warranty and
;;;    restricted rights notice below appear in all supporting
;;;    documentation.
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;.
;;;----------------------------------------------------------------------------
;;;
;;; ===========================================================================
;;; ===================== load-time error checking ============================
;;;

  (defun ai_abort (app msg)
     (defun *error* (s)
        (if old_error (setq *error* old_error))
        (princ)
     )
     (if msg
       (alert (strcat " Application error: "
                      app
                      " \n\n  "
                      msg
                      "  \n"
              )
       )
     )
     (exit)
  )

;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.

  (cond
     (  (and ai_dcl (listp ai_dcl)))          ; it's already loaded.

     (  (not (findfile "ai_utils.lsp"))                     ; find it
        (ai_abort "DDOSNAP"
                  (strcat "Can't locate file AI_UTILS.LSP."
                          "\n Check support directory.")))

     (  (eq "failed" (load "ai_utils" "failed"))            ; load it
        (ai_abort "DDOSNAP" "Can't load file AI_UTILS.LSP"))
  )

  (if (not (ai_acadapp))               ; defined in AI_UTILS.LSP
      (ai_abort "DDOSNAP" nil)         ; a Nil <msg> supresses
  )                                    ; ai_abort's alert box dialog.

;;; ==================== end load-time operations ===========================

;;;----------------------------------------------------------------------------
;;; The main routine.
;;;----------------------------------------------------------------------------
(defun c:ddosnap( /
                  ap_size          ddosnap_main    olderr         x2         
                  cmd              do_setvars      osmode         x_aperture 
                  dcl_id           draw_size       osmode_init    y_aperture 
                  ddosnap_err      globals         x1             ap_size_init
                  undo_init
                )
  ;;
  ;; Pass an integer and draw a square of that size in the aperture image tile.
  ;; 
  (defun draw_size (intsize)
    (setq x1 (- (/ x_aperture 2) (1+ intsize) ))
    (setq x2 (+ (/ x_aperture 2) (1+ intsize) ))
    (setq y1 (- (/ y_aperture 2) (1+ intsize) ))
    (setq y2 (+ (/ y_aperture 2) (1+ intsize) ))
    (start_image "aperture_image")
    (fill_image 0 0 x_aperture y_aperture -2)
    (vector_image x1 y1 x2 y1 -1)
    (vector_image x2 y1 x2 y2 -1)
    (vector_image x2 y2 x1 y2 -1)
    (vector_image x1 y2 x1 y1 -1)
    (end_image)
  )
  ;;
  ;;  If OK, set setvars to selected values.
  ;;
  (defun do_setvars()
    (setq osmode 0)
    (if (= "1" (get_tile "endpoint")) 
      (setq osmode (logior osmode 1))
    )
    (if (= "1" (get_tile "midpoint")) 
      (setq osmode (logior osmode 2))
    )
    (if (= "1" (get_tile "center")) 
      (setq osmode (logior osmode 4))
    )
    (if (= "1" (get_tile "node")) 
      (setq osmode (logior osmode 8))
    )
    (if (= "1" (get_tile "quadrant")) 
      (setq osmode (logior osmode 16))
    )
    (if (= "1" (get_tile "intersection")) 
      (setq osmode (logior osmode 32))
    )
    (if (= "1" (get_tile "insertion")) 
      (setq osmode (logior osmode 64))
    )
    (if (= "1" (get_tile "perpendicular")) 
      (setq osmode (logior osmode 128))
    )
    (if (= "1" (get_tile "tangent")) 
      (setq osmode (logior osmode 256))
    )
    (if (= "1" (get_tile "nearest")) 
      (setq osmode (logior osmode 512))
    )
    (if (= "1" (get_tile "quick")) 
      (setq osmode (logior osmode 1024))
    )
    (if (= "1" (get_tile "apint")) 
      (setq osmode (logior osmode 2048))
    )
    (if (/= osmode osmode_init)
      (setvar "osmode" osmode)
    )
    (if (/= ap_size ap_size_init)
      (setvar "aperture" (1+ ap_size))
    )
  )
  ;;
  ;; Clears all the osmodes.
  ;;
  (defun clear_osmodes()
    (set_tile "endpoint" "0")
    (set_tile "midpoint" "0")
    (set_tile "center" "0")
    (set_tile "node" "0")
    (set_tile "quadrant" "0")
    (set_tile "intersection" "0")
    (set_tile "insertion" "0")
    (set_tile "perpendicular" "0")
    (set_tile "tangent" "0")
    (set_tile "nearest" "0")
    (set_tile "quick" "0")
    (set_tile "apint" "0")
  )
  ;;
  ;; Put up the dialogue.
  ;;
  (defun ddosnap_main()

    (if (not (new_dialog "ddosnap" dcl_id)) (exit))

    ;; The aperture variable must be within 1 - 20 for display within the image 
    ;; tile.  The aperture variable will only be updated if the user moves
    ;; the slider bar (0 - 19).
    (setq ap_size (1- (getvar "aperture")))
    (if (< 19 ap_size) (setq ap_size 19))
    (if (> 0 ap_size) (setq ap_size 0))
    (setq ap_size_init ap_size)

    (setq x_aperture (dimx_tile "aperture_image"))
    (setq y_aperture (dimy_tile "aperture_image"))

    (set_tile "aperture_slider" (itoa ap_size))

    (draw_size ap_size)

    (setq osmode_init (getvar "osmode")   ; get initial value of variable
          osmode      osmode_init
    )
    (if (= 1 (logand 1 osmode)) (set_tile "endpoint" "1"))
    (if (= 2 (logand 2 osmode)) (set_tile "midpoint" "1"))
    (if (= 4 (logand 4 osmode)) (set_tile "center" "1"))
    (if (= 8 (logand 8 osmode)) (set_tile "node" "1"))
    (if (= 16 (logand 16 osmode)) (set_tile "quadrant" "1"))
    (if (= 32 (logand 32 osmode)) (set_tile "intersection" "1"))
    (if (= 64 (logand 64 osmode)) (set_tile "insertion" "1"))
    (if (= 128 (logand 128 osmode)) (set_tile "perpendicular" "1"))
    (if (= 256 (logand 256 osmode)) (set_tile "tangent" "1"))
    (if (= 512 (logand 512 osmode)) (set_tile "nearest" "1"))
    (if (= 1024 (logand 1024 osmode)) (set_tile "quick" "1"))
    (if (= 2048 (logand 2048 osmode)) (set_tile "apint" "1"))

    (action_tile "clear" "(clear_osmodes)") 
    (action_tile "aperture_slider" 
                 "(draw_size (setq ap_size (atoi $value)))")
    (action_tile "help" "(help \"\" \"ddosnap\")")
    (action_tile "accept" "(do_setvars)(done_dialog 1)")

    (start_dialog)
  )

  ;; Set up error function.
  (setq old_cmd (getvar "cmdecho")    ; save current setting of cmdecho
        old_error  *error*            ; save current error function
        *error* ai_error              ; new error function
  )

  (setvar "cmdecho" 0)

  (cond
     (  (not (ai_transd)))                       ; transparent OK
     (  (not (ai_acadapp)))                      ; ACADAPP.EXP xloaded?
     (  (not (setq dcl_id (ai_dcl "ddosnap"))))  ; is .DCL file loaded?

     (t (if (and (/= 1 (logand 1 (getvar "cmdactive")))
                 (/= 8 (logand 8 (getvar "cmdactive")))
            )
         (ai_undo_push)
        )

        (ddosnap_main)                          ; proceed!

        (if (and (/= 1 (logand 1 (getvar "cmdactive")))
                 (/= 8 (logand 8 (getvar "cmdactive")))
            )
         (ai_undo_pop)
        )        

     )
  )


  (setq *error* old_error) 
  (setvar "cmdecho" old_cmd)
  (princ)
)
;;;----------------------------------------------------------------------------
(princ "  DDOSNAP loaded.")
(princ)


