// Next available MSG number is   120
// MODULE_ID DDIM_DCL_
/* Next available MSG number is 185 */
//
//     DDIM.DCL      Version 1.0
//
//     Copyright (C) 1991, 1992, 1993, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//.
//
//

ddimx_row :row{
    children_alignment = bottom;
}

//
// Dimension line color
//
ddimx_colord :ddimx_row{

    :button{
        label = "&Color...";
        key = /*MSG0*/"clrdl";
    }
    :spacer{ width = 7; }
    :swatch{
        key = /*MSG0*/"clrd";
    }
    :edit_box{
        key = /*MSG0*/"clrdt";
        edit_width = 12;
    }
}

//
// Extension line color
//
ddimx_colore :ddimx_row{

    :button{
        label = "Colo&r...";
        key = /*MSG0*/"clrel";
    }
    :spacer{ width = 7; }
    :swatch{
            key = /*MSG0*/"clre";
    }
    :edit_box{
        key = /*MSG0*/"clret";
        edit_width = 12;
    }
}
//
// Dimension text color
//
ddimx_colort :ddimx_row{

    :button{
        label = "&Color...";
        key = /*MSG0*/"clrtl";
        fixed_width = true;
        width = 10;
    }
    :spacer{ width = 7; }
    :swatch{
        key = /*MSG0*/"clrt";
    }
    :edit_box{
        key = /*MSG0*/"clrtt";
        edit_width = 12;
    }
}

ddimx_alert :dialog{
    label = "ALERT";
    :text{
        label = "Save changes to current style?";
        key = /*MSG0*/"dalert_sty";
        alignment = centered;
    }
    :spacer{ height = 0.5; }
    :row{
        fixed_width = true;
        alignment = centered;
        :button{
            label = "&Yes";
            key = /*MSG0*/"dalert_save";
            width = 8;
            fixed_width = true;
        }
        :spacer{ width = 1; }
        :button{
            label = "&No";
            key = /*MSG0*/"dalert_discard";
            width = 8;
            fixed_width = true;
        }
        :spacer{ width = 1; }
        :button{
            label = "&Cancel";
            key = /*MSG0*/"dalert_cancel";
            is_cancel = true;
            width = 8;
            fixed_width = true;
        }
    }
    :spacer{ height = 0.5; }
}

ddimx_alert_fam :dialog{
    label = "ALERT";

  //This alert message is:
  //  
  //      Running overrides can only be set for 
  //            Parent dimension styles.
  //
    :text{
        label = "Running overrides can only be set for";
        alignment = centered;
    }
    :text{
        label = "Parent dimension styles.";
        alignment = centered;
    }
    :spacer{ height = 0.5; }
    ok_only;
    :spacer{ height = 0.5; }
}

// ===============================================================
//
//  Dimension Style Main Dialog -  calls Geometry, Text Location
//                                  and Annotation subdialogs
//          
// ===============================================================

ddim :dialog{
    label = "Dimension Styles";
    :boxed_column{
        label = "Dimension Style";
        fixed_width = true;
        :row{
            :text_part{
                label = "&Current:";
                width = 9;
                fixed_width = true;
            }
            :popup_list{            // lists for current working dimstyles
                key = /*MSG0*/"style";
                list = /*MSG0*/"";
                edit_width = 31;
            }
        }
        :row{
            :text_part{
                label = "&Name:";     //  style name
                width = 9;
                fixed_width = true;
            }
            :edit_box{                        // for user to enter/specify 
                key = /*MSG0*/"editstyle";
                edit_width = 31;
                edit_limit = 217;
            }
        }
        :row{
            fixed_width = true;
            alignment = centered; 
            :button{                      // save/create edited dimstyle         
                label = "&Save";
                key = /*MSG0*/"save";
                width = 10;
            }
            :spacer{ width = 0.5; }
            :button{                      // rename selected dimstyle name
                label = "&Rename";
                key = /*MSG0*/"rename";
                width = 10;
            }
            :spacer{ width = 0.2; }
        }
    }
    :row{
        :boxed_row{

        // Since DCL doesn't support m x n matrix radio buttons,
        // we have to manually track the choice from multiple clusters
        // as if they were a sinble cluster.
        // When a button from the other cluster was selected, turn off 
        // the current button by sweeping the cluster first, then let
        // the chosen button on. This operation is done in apps.

            label = "Family";
            :radio_column{
                key = /*MSG0*/"family1";
                        :radio_button{
                            label = "&Parent";
                            key = /*MSG0*/"parent";
                        }
                        :radio_button{
                            label = "&Linear";
                            key = /*MSG0*/"linear";
                        }
                        :radio_button{
                            label = "Ra&dial";
                            key = /*MSG0*/"radius";
                        }
                        :radio_button{
                            label = "Ang&ular";
                            key = /*MSG0*/"angle";
                        }
            }
            :radio_column{
                key = /*MSG0*/"family2";
                // Somehow in this layout of clusters, they are
                // slightly off balanced. In other words, the buttons
                // in each clusters are not displayed horizontally. 
                // To correct the bias, we used a spacer of 1.5.

                        : spacer { height = 1.5; }
                        :radio_button{
                            label = "Dia&meter";
                            key = /*MSG0*/"diameter";
                        }
                        :radio_button{
                            label = "&Ordinate";
                            key = /*MSG0*/"ordinate";
                        }
                        :radio_button{
                            label = "L&eader";
                            key = /*MSG0*/"leader";
                        }
            }
        }
        :column{
            alignment = top;
            :spacer{ height = 0.7; }
            :button{                  // calls subdialog
                label = "&Geometry...";  
                key = /*MSG0*/"geometry";
            }
            :button{                  // calls subdialog
                label = "&Format...";
                key = /*MSG0*/"txtloc";
            }
            :button{                  // calls subdialog
                label = "&Annotation...";
                key = /*MSG0*/"annotation";
            }
        }
    }
    spacer;
    ok_cancel_help_errtile;
}

//
//  Dimension Geometry Subdialog
//

ddimx_geometry :dialog{
    label = "Geometry";
    :row{
        fixed_height = true;
        :column{
            :boxed_column{
            //
            // This is boxed column for Dimension Line.
            //
                label = "Dimension Line";
                key = /*MSG0*/"g_diml";
                :row{
                    :text{
                        label = "Suppress: ";
                    }
                    :column{
                        :spacer{ height = 0.2; }
                        :toggle{
                            label = "&1st";
                            key = /*MSG0*/"sd1";
                        }
                    }
                    :column{
                        :spacer{ height = 0.2; } 
                        :toggle{
                            label = "&2nd";
                            key = /*MSG0*/"sd2";
                        }
                    }
                }
                :edit12_box{
                    label = "&Extension: ";
                    key = /*MSG0*/"dle";
                }
                :edit12_box{
                    label = "Sp&acing: ";
                    key = /*MSG0*/"dli";
                }
                ddimx_colord;
            }
            :boxed_column{
            //
            // This is boxed column for Extension Line.
            //
                label = "Extension Line";
                key = /*MSG0*/"extline";
                :row{
                    key = /*MSG0*/"g_extl";
                    :text{
                        label = "Suppress: ";
                    }
                    :column{
                        :spacer{ height = 0.3; }
                        :toggle{
                            label = "1&st";
                            key = /*MSG0*/"se1";
                        }
                    }
                    :column{
                        :spacer{ height = 0.3; }
                        :toggle{
                            label = "2&nd";
                            key = /*MSG0*/"se2";
                        }
                    }
                }
                :edit12_box{
                    label = "E&xtension: ";
                    key = /*MSG0*/"exe";
                }
                :edit12_box{
                    label = "Origin O&ffset: ";
                    key = /*MSG0*/"exo";
                }
                ddimx_colore;
            }
        }
        :column{
            :boxed_column{
       
            // This is boxed column for Arrwos.
            // In this popup lists, 'User Arrow' will let you open another
            // subdialog called 'ddimx_userarr'. 

                label = "Arrowheads";
                key = /*MSG0*/"g_arrs";
                :row{
                    fixed_width = true;
                    alignment = right;
                    :image_button{
                        color                   = 0;
                        width                   = 8.7;
                        aspect_ratio            = 0.36;
                        fixed_height            = true;
                        fixed_width             = true;
                        alignment = right;
                        key = /*MSG0*/"arr_icon1";
                    }
                    :image_button{
                        color                   = 0;
                        width                   = 8.7;
                        aspect_ratio            = 0.36;
                        fixed_height            = true;
                        fixed_width             = true;
                        alignment = right;
                        key = /*MSG0*/"arr_icon2";
                    }
                }
                :popup_list{
                    label = "1s&t: ";
                    key = /*MSG0*/"blk1";
                    list = "None \nClosed \nDot \nClosed Filled \nOblique \nOpen \nOrigin Indication \nRight-Angle \nUser Arrow...";
                    edit_width = 20;
                }
                :popup_list{
                    label = "2n&d:";
                    key = /*MSG0*/"blk2";
                    list = "None \nClosed \nDot \nClosed Filled \nOblique \nOpen \nOrigin Indication \nRight-Angle \nUser Arrow...";
                    edit_width = 20;
                }
                :edit12_box{
                    label = "S&ize: ";
                    key = /*MSG0*/"asz";
                }
            }
            :boxed_column{
                key = /*MSG0*/"cenmarks";

            // This is boxed column for center marks. 
            // Choosing a button, its image will be shown in the image box.

                label = "Center";
                :row{
                    :radio_column{
                        key = /*MSG0*/"cen_mark";
                        :radio_button{
                            label = "&Mark";
                            key = /*MSG0*/"cen_mk";
                        }
                        :radio_button{
                            label = "&Line";
                            key = /*MSG0*/"cen_ln";
                        }
                        :radio_button{
                            label = "N&one";
                            key = /*MSG0*/"cen_no";
                        }
                    }
                    :image_button{
                        color                   = 0;
                        width                   = 11;
                        aspect_ratio            = 0.8;
                        fixed_height            = true;
                        fixed_width             = true;
                        alignment = centered;
                        key = /*MSG0*/"cen_icon"; 
                    }
                }
                :spacer { height = 0.1; }
                :edit12_box{
                    label = "Si&ze: ";
                    key = /*MSG0*/"cen";
                }
            }
        }
    }
    :boxed_column{
        label = "Scale";
        :row{
            :column{
                :edit12_box{
                    fixed_width = true;
                    label = "O&verall Scale: ";
                    key = /*MSG0*/"gdscl";
                }
                :spacer{ height = 0.1; }
            }
            :toggle{
                label = "Scale to &Paper Space";
                key = /*MSG0*/"pspace";
            }
        }
    }
    ok_cancel_help_errtile_too;
}

//
//  Dimension Text Location Subdialog
//

ddimx_txtloc :dialog{
    label = "Format";
    fixed_height = true;
    :row{
        :column{
            :column{
                :spacer{ height = 0.3; }
                :toggle{
                    label = "&User Defined";
                    key = /*MSG0*/"jus";
                }
                :toggle{
                    label = "Force &Line Inside";
                    key = "tofl";
                }
                :text {
                        label = "&Fit: ";

                }
                :popup_list{
                    key = /*MSG0*/"jfit";
                    list = "Text and Arrows \nText Only \nArrows Only \nBest Fit \nLeader";
                }
                :spacer{ height = 0.5; }
            }
            :boxed_column{
            //
            // This is boxed column for Justification.
            //
                label = "Horizontal Justification";
                fixed_height = true;
                height = 6.5;
                :spacer{ height = 0.2; }
                :image_button{
                    color                   = 0;
                    width                   = 11;
                    aspect_ratio            = 0.8;
                    fixed_height            = true;
                    fixed_width             = true;
                    alignment = centered;
                    key = /*MSG0*/"horjust_icon"; 
                }
                :spacer{ height = 0.2; }
                :popup_list{
                    key = /*MSG0*/"horjust";
                    list = "Centered \n1st Extension Line \n2nd Extension Line \nOver 1st Extension \nOver 2nd Extension";
                }
                :spacer{ height = 0.2; }
            }
        }
        :column{
            :boxed_column{
                label = "Text";
                fixed_height = true;
                :image_button{
                    color                   = 0;
                    width                   = 11;
                    aspect_ratio            = 0.8;
                    fixed_height            = true;
                    fixed_width             = true;
                    alignment = centered;
                    key = /*MSG0*/"tioh_icon"; 
                }
                :row{
                    fixed_width = true;
                    :spacer{ width = 0.5; }
                    :column{
                        fixed_height = true;
                        :spacer{ height = 0.2; }
                        :toggle{
                            label = "&Inside Horizontal";
                            key = /*MSG0*/"tih";
                        }
                        :toggle{
                            label = "&Outside Horizontal";
                            key = /*MSG0*/"toh";
                        }
                    }
                }
            }
            :boxed_column{

            // This is Vertical Justification. 
            // Choose one, then highlight the related image box. 
            // Conversely you can choose a image box, then highlight 
            // the pull down list item.

                label = "Vertical Justification";
                fixed_height = true;
                height = 6.5;
                :spacer{ height = 0.2; }
                :image_button{
                    color                   = 0;
                    width                   = 11;
                    aspect_ratio            = 0.8;
                    fixed_height            = true;
                    fixed_width             = true;
                    alignment = centered;
                    key = /*MSG0*/"tad_icon"; 
                }
                :spacer{ height = 0.2; }
                :popup_list{
                    key = /*MSG0*/"tad";
                    list = "Centered \nAbove \nOutside \nJIS";
                }
                :spacer{ height = 0.2; }
            }
        }
    }
    :spacer{ height = 0.2; }
    ok_cancel_help_errtile;
}

//
//  Dimension Annotation Subdialog
//

ddimx_annotation :dialog{
    label = "Annotation";
    fixed_width = true;
    :row{
        :column{
            :boxed_column{
        
        // This is boxed column for Dimension units.
        // The 'Units' button opens another subdialog called 'ddimx_units'.
        // This part is for the primary units.

                label = "Primary Units";
                :row{
                    :button{
                        fixed_width = true;
                        label = "&Units...";
                        key = /*MSG0*/"annot_unitsp";
                    }
                }
                :edit_box{
                    label = "&Prefix: ";
                    key = /*MSG0*/"post_1";
                    edit_width = 12;
                    edit_limit = 91;
                }
                :edit_box{
                    label = "&Suffix: ";
                    key = /*MSG0*/"post_2";
                    edit_width = 12;
                    edit_limit = 105;
                }
                :icon_image{
                    color                   = 0;
              //      width                   = 14;
                    height = 2;
                    aspect_ratio            = 0.45;
                    fixed_height            = true;
                    fixed_width             = true;
                    alignment = right;
                    key = /*MSG0*/"post_icon1"; 
                    allow_accept = false;
                }
            }
            :boxed_column{
            //
            // This is boxed portion for Tolerance.
            //
                label = "Tolerance";
                :popup_list{
                    label = "&Method: ";
                    key = /*MSG0*/"toltypes";
                    list = "None \nSymmetrical \nDeviation \nLimits \nBasic";
                    edit_width = 16;
                }
                :edit12_box{
                    label = "Upper &Value: ";
                    key = /*MSG0*/"tp";
                }
                :edit12_box{
                    label = "Lo&wer Value: ";
                    key = /*MSG0*/"tm";
                }
                :popup_list{
                    label = "&Justification: ";
                    key = "tolj";
                    list = "Top \nMiddle \nBottom";
                    edit_width = 10;
                }
                :edit12_box{
                    label = "He&ight: ";
                    key = /*MSG0*/"tfac";
                }
            }
            :spacer{ height = 0.1; }
        }
        :column{
            :boxed_column{

            // This is boxed column for alternate dimunits.
            // The 'Units' button opens another subdialog 'ddimx_units',
            // but this one is for Alternate Units and the values in
            // ddimx_units subdialog are of the alternate units. It is
            // different from the stuff for the primary units.

                label = "Alternate Units";
                key = "alts";
                :row{
                    :toggle{
                        label = "&Enable Units";
                        key = /*MSG0*/"alt";
                    }
                    :button{
                        fixed_width = true;
                        label = "U&nits...";
                        key = /*MSG0*/"annot_unitsa";
                    }
                }
                :column{
                    key = /*MSG0*/"apost";
                    :edit_box{
                        label = "Pre&fix: ";
                        key = /*MSG0*/"apost_1";
                        edit_width = 12;
                        edit_limit = 91;
                    }
                    :edit_box{
                        label = "Suffi&x: ";
                        key = /*MSG0*/"apost_2";
                        edit_width = 12;
                        edit_limit = 105;
                    }
                    :icon_image{
                        color                   = 0;
                //        width                   = 14;
                        height = 2;
                        aspect_ratio            = 0.45;
                        fixed_height            = true;
                        fixed_width             = true;
                        alignment = right;
                        key = /*MSG0*/"post_icon2"; 
                        allow_accept = false;  
                  }
                }
            }
            :boxed_column{
                label = "Text";
                :popup_list{
                    label = "Sty&le: ";
                    key = /*MSG0*/"txsty";
                    edit_witdh = 31;
                    list = /*MSG0*/"";
                }
                :edit12_box{
                    label = "Heigh&t: ";
                    key = /*MSG0*/"txt";
                }
                :edit12_box{
                    label = "&Gap: ";
                    key = /*MSG0*/"gap";
                }

                ddimx_colort;
            }
            :edit12_box{
                label = "&Round Off:";
                key = /*MSG0*/"rnd";
            }
            :spacer{ height = 0.2; }
        }
    }
    ok_cancel_help_errtile_too;
}

//
//  Dimension Units Subdialog - This is called by Annotation dialog.
//                              There are two calling cases, one for 
//                              the primary units and another is for
//                              the alternate units.
//

ddimx_unitsp :dialog{
    label = "Primary Units";
    fixed_width = true;

    units_list;
    units_ufac;

    ok_cancel_help_errtile_too;
}


ddimx_unitsa :dialog{
    label = "Alternate Units";
    fixed_width = true; 

    units_list;
    units_ufac;

    ok_cancel_help_errtile_too;
}

units_ufac :column{
    :boxed_row{
        label = "Scale";
        :column{
            :edit12_box{
                label = "Linea&r: ";
                key = /*MSG0*/"ufac";
            }
            :spacer{ height = 0.2; }
        }
        :spacer { width = 5; }
        :toggle{
            label = "Paper &Space Only";
            key = /*MSG0*/"psufac";
        }
    }
}

units_list :column{
    //
    // Horizontal cluster that contains the Units and Angles clusters.
    //
        //
        // Units cluster.
        //
    :row{
        : boxed_column {
            width = 24;
            label = "&Units";
            //
            // Radio cluster for the units format selection.
            //
            : popup_list {
                key = /*MSG0*/"u_list";
                list = "Scientific \nDecimal \nEngineering \nArchitectural \nFractional";
            }
            :spacer{ height = 0.2; }
        }
        //
        // Angle Formats Control.
        //
        : boxed_column {
            width = 24;
            label = "&Angles";
            //
            // Radio cluster for the angle format selection.
            //
            : popup_list {
                key = /*MSG0*/"u_alist";
                list = "Decimal Degrees \nDeg/Min/Sec \nGrads \nRadians \nSurveyor";
            }
            :spacer{ height = 0.2; }
        }
    }
    :row{
        :boxed_column{
            label = "Dimension";
            //
            // Linear Units Precision popup_list (System variable LUPREC).
            //
            : text {
                label = "&Precision:";
            }
            : popup_list {
                key = /*MSG0*/"u_dimdec";
            }
            :boxed_row{
                label = "Zero Suppression";
                key = /*MSG0*/"zsuppress";
                :column{
                    :toggle{
                        label = "&Leading";
                        key = /*MSG0*/"z3";
                    }
                    :toggle{
                        label = "&Trailing";
                        key = /*MSG0*/"z4";
                    }
                }
                :column{
                    key = "feetinch";
                    :toggle{
                        label = "0 &Feet";
                        key = /*MSG0*/"z1";
                    }
                    :toggle{
                        label = "0 &Inches";
                        key = /*MSG0*/"z2";
                    }
                }
            }
        }
        :boxed_column{
            label = "Tolerance";
            //
            // Angle Precision popup_list (system variable AUPREC).
            //
            spacer_0;
            : text {
                label = "Precisi&on:";
            }    
            : popup_list {
                key = /*MSG0*/"u_toldec";
            }

            :boxed_row{
                label = "Zero Suppression";
                key = /*MSG0*/"tzsuppress";
                :column{
                    :toggle{
                        label = "Lea&ding";
                        key = /*MSG0*/"tz3";
                    }
                    :toggle{
                        label = "Traili&ng";
                        key = /*MSG0*/"tz4";
                    }
                }
                :column{
                    key = /*MSG0*/"tfeetinch";
                    :toggle{
                        label = "0 F&eet";
                        key = /*MSG0*/"tz1";
                    }
                    :toggle{
                        label = "0 In&ches";
                        key = /*MSG0*/"tz2";
                    }
                }
            }
        }
    }
}


//
//  User Arrow subdialog - This is called by Geometry when the user 
//                         selects 'User Arrow' tile.
//                         This dialog allows for the user to set user
//                         arrow head block names.
//

ddimx_userarr :dialog{
    label = "User Arrow";
    fixed_width = true;
    :spacer{ height = 0.3; }
    :edit_box{
        label = "Arrow &Name: ";
        key = /*MSG0*/"userarr1";
        fixed_width = true;
        alignment = centered;
        edit_width = 12;
        edit_limit = 217;
    }
    :spacer{ height = 0.5; }
    ok_cancel_help_errtile;
}

//==========================================================
//    'rq_chroma:dialog{}' must be present here because DDIM.DCL
//    can not share the same dcl function defined in ACAD.DCL since
//    DDIM has been separated from ACAD.DCL.
//    

// The standard color selection dialogue comes to ADS
// The meat of the dialogue is defined in base.dcl and used here and in
//    acad.dcl.

rq_chroma :dialog {
    label = "Select Color";
    key = "chroma";                   // used by Help button to obtain label
    initial_focus = "color_edit";
    std_rq_color;
}

ok_cancel_help_errtile_too : column {
    :row {
        errtile;
        ok_cancel_help;
    }
}

// ==== End of the DDIMX dialogs portion ====


