; Next available MSG number is    14 
; MODULE_ID DDGRIPS_LSP_
;;;
;;;    ddgrips.lsp
;;;
;;;    Copyright (C) 1992, 1994 by Autodesk, Inc.
;;;
;;;    Permission to use, copy, modify, and distribute this software
;;;    for any purpose and without fee is hereby granted, provided
;;;    that the above copyright notice appears in all copies and
;;;    that both that copyright notice and the limited warranty and
;;;    restricted rights notice below appear in all supporting
;;;    documentation.
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;.
;;; ===================== load-time error checking ============================
;;;

  (defun ai_abort (app msg)
     (defun *error* (s)
        (if old_error (setq *error* old_error))
        (princ)
     )
     (if msg
       (alert (strcat " Application error: "
                      app
                      " \n\n  "
                      msg
                      "  \n"
              )
       )
     )
     (exit)
  )

;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.

  (cond
     (  (and ai_dcl (listp ai_dcl)))          ; it's already loaded.

     (  (not (findfile ;|MSG0|;"ai_utils.lsp"))                     ; find it
        (ai_abort "DDGRIPS"
                  (strcat "Can't locate file AI_UTILS.LSP."
                          "\n Check support directory.")))

     (  (eq ;|MSG0|;"failed" (load "ai_utils" ;|MSG0|;"failed"))            ; load it
        (ai_abort "DDGRIPS" "Can't load file AI_UTILS.LSP"))
  )

  (if (not (ai_acadapp))               ; defined in AI_UTILS.LSP
      (ai_abort "DDGRIPS" nil)         ; a Nil <msg> supresses
  )                                    ; ai_abort's alert box dialog.

;;; ==================== end load-time operations ===========================

;;;----------------------------------------------------------------------------
;;; The Main routine.
;;;----------------------------------------------------------------------------
(defun c:ddgrips( /
                  do_cool        gripcolor      x1             grips_var
                  cmd            gripsize       x2             gripblock_var
                  cnum           do_hot         hotcolor       x_grip    
                  colorint       image_col      x_swatch  
                  coolcolor      do_setvars     y_grip    
                  dcl_id         draw_size      temp_color     y_swatch  
                  globals        whichgrip      ddgrips_main   what_next
                  gripsize_init  hotcolor_init  coolcolor_init 
                  gripblock_init grips_init     undo_init
                )
  ;;
  ;; Disable gripblock when grips are disabled.
  ;;
  (defun grips()
    (if (= "1" (get_tile ;|MSG0|;"grips")) 
      (mode_tile ;|MSG0|;"gripblock" 0) 
      (mode_tile ;|MSG0|;"gripblock" 1)
    )
  )
  ;;
  ;; Pass an integer and draw a square of that size in the gripsize image tile.
  ;; 
  (defun draw_size (intsize)
    (setq x1 (- (/ x_grip 2) (1+ intsize) ))
    (setq x2 (+ (/ x_grip 2) (1+ intsize) ))
    (setq y1 (- (/ y_grip 2) (1+ intsize) ))
    (setq y2 (+ (/ y_grip 2) (1+ intsize) ))
    (start_image ;|MSG0|;"grip_image")
    (fill_image 0 0 x_grip y_grip -2)
    (vector_image x1 y1 x2 y1 coolcolor)
    (vector_image x2 y1 x2 y2 coolcolor)
    (vector_image x2 y2 x1 y2 coolcolor)
    (vector_image x1 y2 x1 y1 coolcolor)
    (end_image)
  )
  ;;
  ;;  Select cool color from color dialogue.
  ;;
  (defun do_cool()
    (if (setq temp_color (acad_colordlg coolcolor nil))
      (progn 
        (setq coolcolor temp_color)
        (set_tile ;|MSG0|;"cool_text" (gripcolor coolcolor ;|MSG0|;"cool"))
        (start_image ;|MSG0|;"cool_image")
        (fill_image 0 0 x_swatch y_swatch (image_col coolcolor ;|MSG0|;"cool"))
        (end_image)
        (draw_size gripsize)
      )
    )
  )
  ;; 
  ;;  Select cool color from color dialogue.
  ;;
  (defun do_hot()
    (if (setq temp_color (acad_colordlg hotcolor nil))
      (progn 
        (setq hotcolor temp_color)
        (set_tile ;|MSG0|;"hot_text" (gripcolor hotcolor ;|MSG0|;"hot"))
        (start_image ;|MSG0|;"hot_image")
        (fill_image  0  0  x_swatch y_swatch (image_col hotcolor ;|MSG0|;"hot"))
        (end_image)
      )
    )
  )
  ;;
  ;; If color is zero pass correct color number.
  ;;
  (defun image_col(colorint whichgrip)
     (cond
       ((and (= 0 colorint) (= whichgrip ;|MSG0|;"cool")) 5)
       ((and (= 0 colorint) (= whichgrip ;|MSG0|;"hot")) 1)
       (t colorint)
    )
  )
  ;;
  ;; Pass an integer and recieve a string stating the color name if it is
  ;; one of AutoCAD's standard colors, else just a string containing the 
  ;; number.
  ;;
  (defun gripcolor(colorint whichgrip)
     (cond
       ((and (= 0 colorint) (= whichgrip ;|MSG0|;"cool")) ;|MSG0|;"5 - Blue")
       ((and (= 0 colorint) (= whichgrip ;|MSG0|;"hot")) ;|MSG0|;"1 - Red")
       ((= 1 colorint) "1 - Red")
       ((= 2 colorint) "2 - Yellow")
       ((= 3 colorint) "3 - Green")
       ((= 4 colorint) "4 - Cyan")
       ((= 5 colorint) "5 - Blue")
       ((= 6 colorint) "6 - Magenta")
       ((= 7 colorint) "7 - White")
       (t (itoa colorint))
     )
  )
  ;;
  ;;  If OK, set all setvars to selected values.
  ;;
  (defun do_setvars()
    (if (/= grips_var grips_init)
      (setvar "grips" (atoi grips_var))
    )
    (if (/= gripblock_var gripblock_init)
      (setvar "gripblock" (atoi gripblock_var))
    )
    (if (/= coolcolor coolcolor_init)
      (setvar "gripcolor" coolcolor)
    )
    (if (/= hotcolor hotcolor_init)
      (setvar "griphot" hotcolor)
    )
    (if (/= gripsize gripsize_init)
      (setvar "gripsize" (1+ gripsize))
    )
  )
  ;;
  ;; Put up the dialogue.
  ;;
  (defun ddgrips_main()

    (if (not (new_dialog ;|MSG0|;"ddgrips" dcl_id)) (exit))

    (setq coolcolor (getvar "gripcolor")
          coolcolor_init coolcolor     ; remember initial value
          hotcolor (getvar "griphot")
          hotcolor_init hotcolor       ; remember initial value
    )

    ;; Get current settings of variables.
    (set_tile ;|MSG0|;"grips" (setq grips_init (itoa (getvar "grips"))))
    (set_tile ;|MSG0|;"gripblock" (setq gripblock_init (itoa (getvar "gripblock"))))

    (setq grips_var grips_init)
    (setq gripblock_var gripblock_init)

    (grips)

    (set_tile ;|MSG0|;"cool_text" (gripcolor coolcolor ;|MSG0|;"cool"))
    (set_tile ;|MSG0|;"hot_text" (gripcolor hotcolor ;|MSG0|;"hot"))

    ;; The gripsize variable must be within 1 - 20 for display within the image 
    ;; tile.  The gripsize variable will only be updated if the user moves
    ;; the slider bar (0 - 19).
    (setq gripsize (1- (getvar "gripsize")))

    (if (< 19 gripsize) (setq gripsize 19))
    (if (> 0 gripsize) (setq gripsize 0))
    (setq gripsize_init gripsize)


    (set_tile ;|MSG0|;"grip_slider" (itoa gripsize))

    (setq x_swatch (dimx_tile ;|MSG0|;"cool_image"))
    (setq y_swatch (dimy_tile ;|MSG0|;"cool_image"))

    (setq x_grip (dimx_tile ;|MSG0|;"grip_image"))
    (setq y_grip (dimy_tile ;|MSG0|;"grip_image"))

    (start_image ;|MSG0|;"cool_image")
    (fill_image  0  0  x_swatch y_swatch (image_col coolcolor ;|MSG0|;"cool"))
    (end_image)

    (start_image ;|MSG0|;"hot_image")
    (fill_image  0  0  x_swatch y_swatch (image_col hotcolor ;|MSG0|;"hot"))
    (end_image)

    (draw_size gripsize)

    (action_tile ;|MSG0|;"default_mode" "(set_default)")
    (action_tile ;|MSG0|;"grips" "(setq grips_var $value)(grips)")
    (action_tile ;|MSG0|;"gripblock" "(setq gripblock_var $value)")
    (action_tile ;|MSG0|;"cool_color" "(do_cool)")
    (action_tile ;|MSG0|;"hot_color" "(do_hot)")
    (action_tile ;|MSG0|;"grip_slider" "(draw_size (setq gripsize (atoi $value)))")
    (action_tile ;|MSG0|;"help" "(help \"\" \"ddgrips\")")
    (action_tile ;|MSG0|;"accept" "(done_dialog 1)")

    (setq what_next (start_dialog))

    (cond 
      ((= 1 what_next)
        (do_setvars)
      )
    )
  )

  ;; Set up error function.
  (setq old_cmd (getvar "cmdecho")    ; save current setting of cmdecho
        old_error  *error*            ; save current error function
        *error* ai_error              ; new error function
  )

  (setvar "cmdecho" 0)

  (cond
     (  (not (ai_transd)))                       ; transparent OK
     (  (not (ai_acadapp)))                      ; ACADAPP.EXP xloaded?
     (  (not (setq dcl_id (ai_dcl ;|MSG0|;"ddgrips"))))  ; is .DCL file loaded?
     (t (if (and (/= 1 (logand 1 (getvar "cmdactive")))
                 (/= 8 (logand 8 (getvar "cmdactive")))
            )
         (ai_undo_push)
        )
        (ddgrips_main)                           ; proceed!
        (if (and (/= 1 (logand 1 (getvar "cmdactive")))
                 (/= 8 (logand 8 (getvar "cmdactive")))
            )
         (ai_undo_pop)
        )        
     )
  )


  (setq *error* old_error) 
  (setvar "cmdecho" old_cmd)
  (princ)
)
;;;----------------------------------------------------------------------------
(princ "  DDGRIPS loaded.")
(princ)


